/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.cache;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.apache.avalon.excalibur.cache.Cache;
import org.apache.avalon.excalibur.cache.CacheEvent;
import org.apache.avalon.excalibur.cache.CacheListener;
import org.apache.avalon.excalibur.cache.CacheValidator;

public abstract class AbstractCache
implements Cache {
    protected CacheValidator m_validator;
    protected ArrayList m_listeners;

    public void setValidator(CacheValidator validator) {
        this.m_validator = validator;
    }

    protected boolean validate(Object key, Object value) {
        if (this.m_validator == null) {
            return true;
        }
        return this.m_validator.validate(key, value);
    }

    public void addListener(CacheListener listener) {
        ArrayList arrayList = this.m_listeners;
        synchronized (arrayList) {
            this.m_listeners.add(listener);
        }
    }

    public void removeListener(CacheListener listener) {
        ArrayList arrayList = this.m_listeners;
        synchronized (arrayList) {
            ((AbstractCollection)this.m_listeners).remove(listener);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void notifyAdded(Object key, Object value) {
        void listeners;
        CacheEvent event = new CacheEvent(this, key, value);
        ArrayList arrayList = this.m_listeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.m_listeners.clone();
        }
        int s = listeners.size();
        int i = 0;
        while (i < s) {
            ((CacheListener)listeners.get(i)).added(event);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void notifyRemoved(Object key, Object value) {
        void listeners;
        CacheEvent event = new CacheEvent(this, key, value);
        ArrayList arrayList = this.m_listeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.m_listeners.clone();
        }
        int s = listeners.size();
        int i = 0;
        while (i < s) {
            ((CacheListener)listeners.get(i)).removed(event);
            ++i;
        }
    }

    public abstract int capacity();

    public abstract int size();

    public abstract Object put(Object var1, Object var2);

    public abstract Object get(Object var1);

    public abstract Object remove(Object var1);

    public abstract boolean containsKey(Object var1);

    public abstract void clear();

    public AbstractCache() {
        this(null);
    }

    public AbstractCache(CacheValidator validator) {
        this.setValidator(validator);
        this.m_listeners = new ArrayList();
    }
}

