/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
        if (this.fNSBinder == null) {
            this.fNSBinder = new NamespaceSupport();
            this.fLocalNSBinder = new NamespaceSupport();
            this.fSymbolTable = new SymbolTable();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        try {
            String string4;
            String string5;
            Object object;
            if (this._printer == null) {
                String string6 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(string6);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2 == null || string2.length() == 0 ? string3 : string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl2 = elementState.preserveSpace;
            attributes = this.extractNamespaces(attributes);
            if (string3 == null || string3.length() == 0) {
                if (string2 == null) {
                    String string7 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                    throw new SAXException(string7);
                }
                string3 = string != null && !string.equals("") ? ((object = this.getPrefix(string)) != null && ((String)object).length() > 0 ? (String)object + ":" + string2 : string2) : string2;
                bl = true;
            }
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    this._printer.printSpace();
                    string5 = attributes.getQName(n);
                    if (string5 != null && string5.length() == 0) {
                        string5 = attributes.getLocalName(n);
                        String string8 = attributes.getURI(n);
                        if (!(string8 == null || string8.length() == 0 || string != null && string.length() != 0 && string8.equals(string) || (object = this.getPrefix(string8)) == null || ((String)object).length() <= 0)) {
                            string5 = (String)object + ":" + string5;
                        }
                    }
                    if ((string4 = attributes.getValue(n)) == null) {
                        string4 = "";
                    }
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    if (string5.equals("xml:space")) {
                        bl2 = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            if (this._prefixes != null) {
                object = this._prefixes.keys();
                while (object.hasMoreElements()) {
                    this._printer.printSpace();
                    string4 = (String)object.nextElement();
                    string5 = (String)this._prefixes.get(string4);
                    if (string5.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string, string2, string3, bl2);
            string5 = string2 == null || string2.length() == 0 ? string3 : string + "^" + string2;
            elementState.doCData = this._format.isCDataElement(string5);
            elementState.unescaped = this._format.isNonEscapingElement(string5);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.endElementIO(string, string2, string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string, String string2, String string3) throws IOException {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.afterComment = false;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(string2);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(string);
            this._printer.indent();
            if (attributeList != null) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    this._printer.printSpace();
                    String string3 = attributeList.getName(n);
                    String string4 = attributeList.getValue(n);
                    if (string4 != null) {
                        this._printer.printText(string3);
                        this._printer.printText("=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                    }
                    if (string3.equals("xml:space")) {
                        bl = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            elementState = this.enterElementState(null, null, string, bl);
            elementState.doCData = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    protected void startDocument(String string) throws IOException {
        String string2 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                String string3 = this._format.getEncoding();
                if (string3 != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(string3);
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int n = 0;
                            while (n < 18 + string.length()) {
                                this._printer.printText(" ");
                                ++n;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (string2 != null && string2.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string2, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (string2 != null && string2.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    this._printer.printText(" [");
                    this.printText(string2, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element element) throws IOException {
        String string;
        String string2;
        Attr attr;
        int n;
        if (this.fNamespaces) {
            this.fLocalNSBinder.reset();
            this.fNSBinder.pushContext();
        }
        String string3 = element.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string3);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (elementState.inCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
        }
        this.fPreserveSpace = elementState.preserveSpace;
        int n2 = 0;
        NamedNodeMap namedNodeMap = null;
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n2 = namedNodeMap.getLength();
        }
        if (!this.fNamespaces) {
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string2 = attr.getName();
                string = attr.getValue();
                if (string == null) {
                    string = "";
                }
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    this._printer.printText(string2);
                    this._printer.printText("=\"");
                    this.printEscaped(string);
                    this._printer.printText('\"');
                }
                if (string2.equals("xml:space")) {
                    this.fPreserveSpace = string.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        } else {
            String string4;
            boolean bl;
            String string5;
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string5 = attr.getNamespaceURI();
                if (string5 != null && string5.equals(NamespaceContext.XMLNS_URI)) {
                    string = attr.getNodeValue();
                    if (string == null) {
                        string = XMLSymbols.EMPTY_STRING;
                    }
                    if (string.equals(NamespaceContext.XMLNS_URI)) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)2, attr);
                            bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                            if (!bl) {
                                throw new RuntimeException("Stopped at user request");
                            }
                        }
                    } else {
                        string4 = attr.getPrefix();
                        string4 = string4 == null || string4.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                        String string6 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string4 == XMLSymbols.PREFIX_XMLNS) {
                            if ((string = this.fSymbolTable.addSymbol(string)).length() != 0) {
                                this.fNSBinder.declarePrefix(string6, string);
                            }
                        } else {
                            string = this.fSymbolTable.addSymbol(string);
                            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, string);
                        }
                    }
                }
                ++n;
            }
            string5 = element.getNamespaceURI();
            string4 = element.getPrefix();
            if (string5 != null && string4 != null && string5.length() == 0 && string4.length() != 0) {
                string4 = null;
                this._printer.printText('<');
                this._printer.printText(element.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(string3);
                this._printer.indent();
            }
            if (string5 != null) {
                string5 = this.fSymbolTable.addSymbol(string5);
                String string7 = string4 = string4 == null || string4.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                if (this.fNSBinder.getURI(string4) != string5) {
                    this.printNamespaceAttr(string4, string5);
                    this.fLocalNSBinder.declarePrefix(string4, string5);
                    this.fNSBinder.declarePrefix(string4, string5);
                }
            } else if (element.getLocalName() == null) {
                if (this.fDOMErrorHandler != null) {
                    this.modifyDOMError("DOM Level 1 Node: " + element.getNodeName(), (short)2, element);
                    bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                    if (!bl) {
                        throw new RuntimeException("Process stoped at user request");
                    }
                }
            } else {
                string5 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                if (string5 != null && string5.length() > 0) {
                    this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                }
            }
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string = attr.getValue();
                string2 = attr.getNodeName();
                string5 = attr.getNamespaceURI();
                if (string5 != null && string5.length() == 0) {
                    string5 = null;
                    string2 = attr.getLocalName();
                }
                if (string == null) {
                    string = XMLSymbols.EMPTY_STRING;
                }
                if (string5 != null) {
                    string4 = attr.getPrefix();
                    string4 = string4 == null ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                    String string8 = this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (string5 != null && string5.equals(NamespaceContext.XMLNS_URI)) {
                        String string9;
                        string4 = attr.getPrefix();
                        string4 = string4 == null || string4.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                        string8 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string4 == XMLSymbols.PREFIX_XMLNS) {
                            string9 = this.fLocalNSBinder.getURI(string8);
                            if ((string = this.fSymbolTable.addSymbol(string)).length() != 0 && string9 == null) {
                                this.printNamespaceAttr(string8, string);
                                this.fLocalNSBinder.declarePrefix(string8, string);
                            }
                        } else {
                            string5 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                            string9 = this.fLocalNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                            string = this.fSymbolTable.addSymbol(string);
                            if (string9 == null) {
                                this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, string);
                            }
                        }
                    } else {
                        string5 = this.fSymbolTable.addSymbol(string5);
                        String string10 = this.fNSBinder.getURI(string4);
                        if (string4 == XMLSymbols.EMPTY_STRING || string10 != string5) {
                            string2 = attr.getNodeName();
                            String string11 = this.fNSBinder.getPrefix(string5);
                            if (string11 != null && string11 != XMLSymbols.EMPTY_STRING) {
                                string4 = string11;
                                string2 = string4 + ":" + string8;
                            } else {
                                if (string4 == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string4) != null) {
                                    int n3 = 1;
                                    string4 = this.fSymbolTable.addSymbol(PREFIX + n3++);
                                    while (this.fLocalNSBinder.getURI(string4) != null) {
                                        string4 = this.fSymbolTable.addSymbol(PREFIX + n3++);
                                    }
                                    string2 = string4 + ":" + string8;
                                }
                                this.printNamespaceAttr(string4, string5);
                                string = this.fSymbolTable.addSymbol(string);
                                this.fLocalNSBinder.declarePrefix(string4, string);
                                this.fNSBinder.declarePrefix(string4, string5);
                            }
                        }
                        this.printAttribute(string2, string == null ? XMLSymbols.EMPTY_STRING : string, attr.getSpecified());
                    }
                } else if (attr.getLocalName() == null) {
                    if (this.fDOMErrorHandler != null) {
                        this.modifyDOMError("DOM Level 1 Node: " + string2, (short)2, attr);
                        boolean bl2 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!bl2) {
                            throw new RuntimeException("Stopped at user request");
                        }
                    }
                    this.printAttribute(string2, string, attr.getSpecified());
                } else {
                    this.printAttribute(string2, string, attr.getSpecified());
                }
                ++n;
            }
        }
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string3, this.fPreserveSpace);
            elementState.doCData = this._format.isCDataElement(string3);
            elementState.unescaped = this._format.isNonEscapingElement(string3);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, string3);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            elementState.afterElement = true;
            elementState.afterComment = false;
            elementState.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String string, String string2) throws IOException {
        this._printer.printSpace();
        if (string == XMLSymbols.EMPTY_STRING) {
            this._printer.printText(XMLSymbols.PREFIX_XMLNS);
        } else {
            this._printer.printText("xmlns:" + string);
        }
        this._printer.printText("=\"");
        this.printEscaped(string2);
        this._printer.printText('\"');
    }

    private void printAttribute(String string, String string2, boolean bl) throws IOException {
        if (bl || (this.features & 0x40) != 0) {
            this._printer.printSpace();
            this._printer.printText(string);
            this._printer.printText("=\"");
            this.printEscaped(string2);
            this._printer.printText('\"');
        }
        if (string.equals("xml:space")) {
            this.fPreserveSpace = string2.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int n) {
        switch (n) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attributes) throws SAXException {
        if (attributes == null) {
            return null;
        }
        int n = attributes.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = attributesImpl.getQName(n2);
            if (string.startsWith("xmlns")) {
                if (string.length() == 5) {
                    this.startPrefixMapping("", attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                } else if (string.charAt(5) == ':') {
                    this.startPrefixMapping(string.substring(6), attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                }
            }
            --n2;
        }
        return attributesImpl;
    }

    protected void printEscaped(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!XMLChar.isValid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string.charAt(n2));
                } else {
                    this.fatalError("The character '" + (char)c + "' is an invalid XML character");
                }
            } else if (c == '\n' || c == '\r' || c == '\t') {
                this.printHex(c);
            } else if (c == '<') {
                this._printer.printText("&lt;");
            } else if (c == '&') {
                this._printer.printText("&amp;");
            } else if (c == '\"') {
                this._printer.printText("&quot;");
            } else if (c >= ' ' && this._encodingInfo.isPrintable(c)) {
                this._printer.printText(c);
            } else {
                this.printHex(c);
            }
            ++n2;
        }
    }

    protected void printXMLChar(int n) throws IOException {
        if (n == 13) {
            this.printHex(n);
        } else if (n == 60) {
            this._printer.printText("&lt;");
        } else if (n == 38) {
            this._printer.printText("&amp;");
        } else if (n == 62) {
            this._printer.printText("&gt;");
        } else if (n == 10 || n == 9 || n >= 32 && this._encodingInfo.isPrintable((char)n)) {
            this._printer.printText((char)n);
        } else {
            this.printHex(n);
        }
    }

    protected void printText(String string, boolean bl, boolean bl2) throws IOException {
        int n = string.length();
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!XMLChar.isValid(c)) {
                    if (++n2 < n) {
                        this.surrogates(c, string.charAt(n2));
                    } else {
                        this.fatalError("The character '" + c + "' is an invalid XML character");
                    }
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c = string.charAt(n3);
                if (!XMLChar.isValid(c)) {
                    if (++n3 < n) {
                        this.surrogates(c, string.charAt(n3));
                    } else {
                        this.fatalError("The character '" + c + "' is an invalid XML character");
                    }
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void printText(char[] var1_1, int var2_2, int var3_3, boolean var4_4, boolean var5_5) throws IOException {
        block8: {
            if (!var4_4) ** GOTO lbl29
            while (var3_3-- > 0) {
                var7_6 = var1_1[var2_2];
                ++var2_2;
                if (!XMLChar.isValid(var7_6)) {
                    if (++var2_2 < var3_3) {
                        this.surrogates(var7_6, var1_1[var2_2]);
                        continue;
                    }
                    this.fatalError("The character '" + var7_6 + "' is an invalid XML character");
                    continue;
                }
                if (var5_5) {
                    this._printer.printText(var7_6);
                    continue;
                }
                this.printXMLChar(var7_6);
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                var7_7 = var1_1[var2_2];
                ++var2_2;
                if (!XMLChar.isValid(var7_7)) {
                    if (++var2_2 < var3_3) {
                        this.surrogates(var7_7, var1_1[var2_2]);
                        continue;
                    }
                    this.fatalError("The character '" + var7_7 + "' is an invalid XML character");
                    continue;
                }
                if (var5_5) {
                    this._printer.printText(var7_7);
                    continue;
                }
                this.printXMLChar(var7_7);
lbl29:
                // 5 sources

                ** while (var3_3-- > 0)
            }
        }
    }

    protected void checkUnboundNamespacePrefixedNode(Node node) throws IOException {
        if (this.fNamespaces) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                Node node3 = node2.getNextSibling();
                String string = node2.getPrefix();
                if (this.fNSBinder.getURI(string) == null && string != null) {
                    this.fatalError("The replacement text of the entity node '" + node.getNodeName() + "' contains an element node '" + node2.getNodeName() + "' with an undeclared prefix '" + string + "'.");
                }
                if (node2.getNodeType() == 1) {
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        String string2 = namedNodeMap.item(n).getPrefix();
                        if (this.fNSBinder.getURI(string2) == null && string2 != null) {
                            this.fatalError("The replacement text of the entity node '" + node.getNodeName() + "' contains an element node '" + node2.getNodeName() + "' with an attribute '" + namedNodeMap.item(n).getNodeName() + "' an undeclared prefix '" + string2 + "'.");
                        }
                        ++n;
                    }
                }
                if (node2.hasChildNodes()) {
                    this.checkUnboundNamespacePrefixedNode(node2);
                }
                node2 = node3;
            }
        }
    }

    public boolean reset() {
        super.reset();
        if (this.fNSBinder != null) {
            this.fNSBinder.reset();
            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        }
        return true;
    }
}

