/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.dvsl.dom4j;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.dvsl.DVSLNode;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.XMLWriter;

public class Dom4jNodeImpl
implements DVSLNode {
    protected Node element = null;
    protected Map attributes = null;

    public Dom4jNodeImpl(Element e) {
        this.element = e;
    }

    public Dom4jNodeImpl(Document e) {
        this.element = e;
    }

    public Dom4jNodeImpl(Text e) {
        this.element = e;
    }

    public Dom4jNodeImpl(Attribute e) {
        this.element = e;
    }

    public Dom4jNodeImpl(Comment e) {
        this.element = e;
    }

    public Dom4jNodeImpl(CDATA e) {
        this.element = e;
    }

    private Dom4jNodeImpl() {
    }

    public String name() {
        return this.element.getName();
    }

    public String attribute(String attribute) {
        if (this.element instanceof Element) {
            return ((Element)this.element).attributeValue(attribute);
        }
        return null;
    }

    public List selectNodes(String xpath) {
        List l = this.element.selectNodes(xpath);
        ArrayList<DVSLNode> list = new ArrayList<DVSLNode>();
        int i = 0;
        while (i < l.size()) {
            Node n = (Node)l.get(i);
            if (n != null) {
                list.add(this.makeDVSLNode(n));
            }
            ++i;
        }
        return list;
    }

    public DVSLNode selectSingleNode(String xpath) {
        Node n = this.element.selectSingleNode(xpath);
        return this.makeDVSLNode(n);
    }

    public DVSLNode get(String xpath) {
        return this.selectSingleNode(xpath);
    }

    public String value() {
        return this.element.getText();
    }

    public Object valueOf(String xpath) {
        return this.element.valueOf(xpath);
    }

    public String toString() {
        return this.value();
    }

    public List children() {
        ArrayList<DVSLNode> list = new ArrayList<DVSLNode>();
        if (this.element.getNodeType() == 1) {
            List nodes = ((Element)this.element).content();
            int i = 0;
            while (i < nodes.size()) {
                list.add(this.makeDVSLNode((Node)nodes.get(i)));
                ++i;
            }
        }
        return list;
    }

    public String copy(List nodes) {
        if (nodes == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        int i = 0;
        while (i < nodes.size()) {
            DVSLNode dn = (DVSLNode)nodes.get(i);
            this.copy((Node)dn.getNodeImpl(), sw);
            ++i;
        }
        return sw.toString();
    }

    public String copy() {
        StringWriter sw = new StringWriter();
        this.copy(this.element, sw);
        return sw.toString();
    }

    /*
     * Loose catch block
     */
    private void copy(Node node, Writer writer) {
        block8: {
            XMLWriter xw = new XMLWriter(writer);
            xw.write(node);
            Object var6_4 = null;
            try {
                xw.flush();
            }
            catch (Exception eee) {}
            break block8;
            {
                catch (Exception ee) {
                    Object var6_5 = null;
                    try {
                        xw.flush();
                    }
                    catch (Exception eee) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    xw.flush();
                }
                catch (Exception eee) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String render() {
        try {
            StringWriter sw = new StringWriter();
            this.element.write((Writer)sw);
            return sw.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String attrib(String name) {
        Attribute attrib;
        if (this.element instanceof Element && (attrib = ((Element)this.element).attribute(name)) != null) {
            return attrib.getValue();
        }
        return null;
    }

    public Object getNodeImpl() {
        return this.element;
    }

    public Map getAttribMap() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (this.element instanceof Element) {
            Iterator it = ((Element)this.element).attributeIterator();
            while (it.hasNext()) {
                Attribute at = (Attribute)it.next();
                this.attributes.put(at.getName(), at.getValue());
            }
        }
        return this.attributes;
    }

    private DVSLNode makeDVSLNode(Node n) {
        if (n == null) {
            return null;
        }
        short type = n.getNodeType();
        if (type == 1) {
            return new Dom4jNodeImpl((Element)n);
        }
        if (type == 3) {
            return new Dom4jNodeImpl((Text)n);
        }
        if (type == 2) {
            return new Dom4jNodeImpl((Attribute)n);
        }
        if (type == 8) {
            return new Dom4jNodeImpl((Comment)n);
        }
        if (type == 4) {
            return new Dom4jNodeImpl((CDATA)n);
        }
        return null;
    }
}

