/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

import java.io.UnsupportedEncodingException;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final byte PAD = 61;
    private static final boolean fDebug = false;
    private static byte[] base64Alphabet = new byte[255];
    private static byte[] lookUpBase64Alphabet = new byte[64];

    protected static boolean isWhiteSpace(byte by) {
        return by == 32 || by == 13 || by == 10 || by == 9;
    }

    protected static boolean isPad(byte by) {
        return by == 61;
    }

    protected static boolean isData(byte by) {
        return base64Alphabet[by] != -1;
    }

    protected static boolean isBase64(byte by) {
        return Base64.isWhiteSpace(by) || Base64.isPad(by) || Base64.isData(by);
    }

    public static byte[] encode(byte[] byArray) {
        byte by;
        byte by2;
        if (byArray == null) {
            return null;
        }
        int n = byArray.length * 8;
        int n2 = n % 24;
        int n3 = n / 24;
        byte[] byArray2 = null;
        byArray2 = n2 != 0 ? new byte[(n3 + 1) * 4] : new byte[n3 * 4];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n6 = 0;
        while (n6 < n3) {
            n5 = n6 * 3;
            by5 = byArray[n5];
            by6 = byArray[n5 + 1];
            by7 = byArray[n5 + 2];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n4 = n6 * 4;
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byte by8 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by | by3 << 4];
            byArray2[n4 + 2] = lookUpBase64Alphabet[by4 << 2 | by8];
            byArray2[n4 + 3] = lookUpBase64Alphabet[by7 & 0x3F];
            ++n6;
        }
        n5 = n6 * 3;
        n4 = n6 * 4;
        if (n2 == 8) {
            by5 = byArray[n5];
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by3 << 4];
            byArray2[n4 + 2] = 61;
            byArray2[n4 + 3] = 61;
        } else if (n2 == 16) {
            by5 = byArray[n5];
            by6 = byArray[n5 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by | by3 << 4];
            byArray2[n4 + 2] = lookUpBase64Alphabet[by4 << 2];
            byArray2[n4 + 3] = 61;
        }
        return byArray2;
    }

    public static byte[] decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length % 4 != 0) {
            return null;
        }
        int n = byArray.length / 4;
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray2 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byArray2 = new byte[n * 3];
        while (n2 < n - 1) {
            if (!(Base64.isData(by5 = byArray[n4++]) && Base64.isData(by6 = byArray[n4++]) && Base64.isData(by7 = byArray[n4++]) && Base64.isData(by8 = byArray[n4++]))) {
                return null;
            }
            by = base64Alphabet[by5];
            by2 = base64Alphabet[by6];
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            byArray2[n3++] = (byte)(by << 2 | by2 >> 4);
            byArray2[n3++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray2[n3++] = (byte)(by3 << 6 | by4);
            ++n2;
        }
        if (!Base64.isData(by5 = byArray[n4++]) || !Base64.isData(by6 = byArray[n4++])) {
            return null;
        }
        by = base64Alphabet[by5];
        by2 = base64Alphabet[by6];
        by7 = byArray[n4++];
        by8 = byArray[n4++];
        if (!Base64.isData(by7) || !Base64.isData(by8)) {
            if (Base64.isPad(by7) && Base64.isPad(by8)) {
                if ((by2 & 0xF) != 0) {
                    return null;
                }
                byte[] byArray3 = new byte[n2 * 3 + 1];
                System.arraycopy(byArray2, 0, byArray3, 0, n2 * 3);
                byArray3[n3] = (byte)(by << 2 | by2 >> 4);
                return byArray3;
            }
            if (!Base64.isPad(by7) && Base64.isPad(by8)) {
                by3 = base64Alphabet[by7];
                if ((by3 & 3) != 0) {
                    return null;
                }
                byte[] byArray4 = new byte[n2 * 3 + 2];
                System.arraycopy(byArray2, 0, byArray4, 0, n2 * 3);
                byArray4[n3++] = (byte)(by << 2 | by2 >> 4);
                byArray4[n3] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
                return byArray4;
            }
            return null;
        }
        by3 = base64Alphabet[by7];
        by4 = base64Alphabet[by8];
        byArray2[n3++] = (byte)(by << 2 | by2 >> 4);
        byArray2[n3++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
        byArray2[n3++] = (byte)(by3 << 6 | by4);
        return byArray2;
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            try {
                byArray = Base64.decode(string.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Object var4_3 = null;
                return byArray == null ? null : new String(byArray);
            }
            Object var4_2 = null;
            return byArray == null ? null : new String(byArray);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            return byArray == null ? null : new String(byArray);
        }
    }

    static {
        int n = 0;
        while (n < 255) {
            Base64.base64Alphabet[n] = -1;
            ++n;
        }
        int n2 = 90;
        while (n2 >= 65) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 65);
            --n2;
        }
        int n3 = 122;
        while (n3 >= 97) {
            Base64.base64Alphabet[n3] = (byte)(n3 - 97 + 26);
            --n3;
        }
        int n4 = 57;
        while (n4 >= 48) {
            Base64.base64Alphabet[n4] = (byte)(n4 - 48 + 52);
            --n4;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int n5 = 0;
        while (n5 <= 25) {
            Base64.lookUpBase64Alphabet[n5] = (byte)(65 + n5);
            ++n5;
        }
        int n6 = 26;
        int n7 = 0;
        while (n6 <= 51) {
            Base64.lookUpBase64Alphabet[n6] = (byte)(97 + n7);
            ++n6;
            ++n7;
        }
        int n8 = 52;
        int n9 = 0;
        while (n8 <= 61) {
            Base64.lookUpBase64Alphabet[n8] = (byte)(48 + n9);
            ++n8;
            ++n9;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

