/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    File tarFile;
    File baseDir;

    public void setTarfile(File tarFile) {
        this.tarFile = tarFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.tarFile == null) {
            throw new BuildException("tarfile attribute must be set!", this.location);
        }
        if (this.baseDir == null) {
            throw new BuildException("basedir attribute must be set!", this.location);
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("basedir does not exist!", this.location);
        }
        DirectoryScanner ds = super.getDirectoryScanner(this.baseDir);
        String[] files = ds.getIncludedFiles();
        if (this.archiveIsUpToDate(files)) {
            this.log("Nothing to do: " + this.tarFile.getAbsolutePath() + " is up to date.", 2);
            return;
        }
        this.log("Building tar: " + this.tarFile.getAbsolutePath(), 2);
        TarOutputStream tOut = null;
        try {
            try {
                tOut = new TarOutputStream(new FileOutputStream(this.tarFile));
                tOut.setDebug(true);
                int i = 0;
                while (i < files.length) {
                    File f = new File(this.baseDir, files[i]);
                    String name = files[i].replace(File.separatorChar, '/');
                    this.tarFile(f, tOut, name);
                    ++i;
                }
            }
            catch (IOException ioe) {
                String msg = "Problem creating TAR: " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.location);
            }
            Object var5_11 = null;
            if (tOut == null) return;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            if (tOut == null) throw throwable;
            try {
                tOut.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        tOut.close();
        return;
    }

    protected void tarFile(File file, TarOutputStream tOut, String vPath) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        try {
            TarEntry te = new TarEntry(vPath);
            te.setSize(file.length());
            te.setModTime(file.lastModified());
            tOut.putNextEntry(te);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                tOut.write(buffer, 0, count);
            } while ((count = fIn.read(buffer, 0, buffer.length)) != -1);
            tOut.closeEntry();
        }
        finally {
            Object var6_8 = null;
            fIn.close();
        }
    }

    protected boolean archiveIsUpToDate(String[] files) {
        SourceFileScanner sfs = new SourceFileScanner(this);
        MergingMapper mm = new MergingMapper();
        mm.setTo(this.tarFile.getAbsolutePath());
        return sfs.restrict(files, this.baseDir, null, mm).length == 0;
    }
}

