/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.i18n;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.avalon.util.i18n.XPathAPI;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.PrefixResolverDefault;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLResourceBundle {
    private Hashtable cacheIS = new Hashtable();
    private Hashtable cacheNO = new Hashtable();
    private Document resource;
    public String bundleName = "";
    protected XMLResourceBundle parent = null;

    public XMLResourceBundle(Document document, String string, XMLResourceBundle xMLResourceBundle) {
        System.out.print("Constructing XMLResourceBundle: " + string);
        if (xMLResourceBundle != null) {
            System.out.println("  --> parent: " + xMLResourceBundle.bundleName);
        } else {
            System.out.println("  --> parent: " + xMLResourceBundle);
        }
        this.resource = document;
        this.bundleName = string;
        this.parent = xMLResourceBundle;
    }

    public void addToCache(String string, String string2) {
        this.cacheIS.put(string, string2);
    }

    public Document getResource() {
        return this.resource;
    }

    public String getStringSimple(String string) {
        String string2 = "";
        try {
            string2 = this.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public String getString(String string) throws MissingResourceException {
        if (this.cacheIS.containsKey(string)) {
            return (String)this.cacheIS.get(string);
        }
        if (this.cacheNO.containsKey(string)) {
            new MissingResourceException("Unable to locate resource: " + string, "XMLResourceBundle", string);
        }
        Element element = this.resource.getDocumentElement();
        try {
            Node node = XPathAPI.selectSingleNode(element, string);
            if (node != null) {
                String string2 = this.getTextNodeAsString(node);
                this.addToCache(string, string2);
                return string2;
            }
            if (this.parent != null) {
                return this.parent.getString(string);
            }
            throw new Exception();
        }
        catch (Exception exception) {
            this.cacheNO.put(string, "");
            throw new MissingResourceException("Unable to locate resource: " + string, "XMLResourceBundle", string);
        }
    }

    public String getString(Node node, String string) throws MissingResourceException {
        try {
            Node node2 = XPathAPI.selectSingleNode(node, string);
            if (node2 != null) {
                return this.getTextNodeAsString(node2);
            }
            throw new Exception();
        }
        catch (Exception exception) {
            throw new MissingResourceException("Unable to locate resource: " + string, "XMLResourceBundle", string);
        }
    }

    private String getTextNodeAsString(Node node) throws MissingResourceException {
        if ((node = node.getFirstChild()).getNodeType() == 3) {
            return ((TextImpl)node).getData();
        }
        throw new MissingResourceException("Unable to locate XMLResourceBundle", "XMLResourceBundleFactory", "");
    }

    public Node getRole(String string) {
        Element element = this.resource.getDocumentElement();
        try {
            Node node = XPathAPI.selectSingleNode(element, string);
            if (node != null) {
                return node;
            }
            throw new Exception();
        }
        catch (Exception exception) {
            throw new MissingResourceException("Unable to locate resource: " + string, "XMLResourceBundle", string);
        }
    }

    public Node getRole(Node node, String string) {
        try {
            Node node2 = XPathAPI.selectSingleNode(node, string);
            if (node2 != null) {
                return node2;
            }
            throw new Exception();
        }
        catch (Exception exception) {
            throw new MissingResourceException("Unable to locate resource: " + string, "XMLResourceBundle", string);
        }
    }

    public XPath createXPath(String string, Node node) throws SAXException {
        XMLParserLiaisonDefault xMLParserLiaisonDefault = new XMLParserLiaisonDefault();
        if (null == node) {
            throw new SAXException("A namespace node is required to resolve prefixes!");
        }
        PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : node);
        XPath xPath = new XPath();
        XPathProcessorImpl xPathProcessorImpl = new XPathProcessorImpl((XPathSupport)xMLParserLiaisonDefault);
        xPathProcessorImpl.initXPath(xPath, string, (PrefixResolver)prefixResolverDefault);
        return xPath;
    }

    public Locale getLocale() {
        String string = this.bundleName.substring(0, this.bundleName.indexOf(".xml"));
        int n = string.indexOf("_");
        if (n == -1) {
            return new Locale("", "", "");
        }
        if ((n = (string = string.substring(n + 1)).indexOf("_")) == -1) {
            return new Locale(string, "", "");
        }
        String string2 = string.substring(0, n);
        if ((n = (string = string.substring(n + 1)).indexOf("_")) == -1) {
            return new Locale(string2, string, "");
        }
        String string3 = string.substring(0, n);
        string = string.substring(n + 1);
        return new Locale(string2, string3, string);
    }
}

