/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.cli.test;

import java.util.Vector;
import org.apache.avalon.util.cli.AbstractParserControl;
import org.apache.avalon.util.cli.CLArgsParser;
import org.apache.avalon.util.cli.CLOption;
import org.apache.avalon.util.cli.CLOptionDescriptor;
import org.apache.testlet.AbstractTestlet;

public final class ClutilTestlet
extends AbstractTestlet {
    protected static final String[] ARGLIST1 = new String[]{"--you", "are", "--all", "-cler", "kid"};
    protected static final String[] ARGLIST2 = new String[]{"-Dstupid=idiot", "are", "--all", "here"};
    protected static final String[] ARGLIST3 = new String[]{"-Dstupid=idiot", "are", "--all", "--all", "here"};
    protected static final String[] ARGLIST4 = new String[]{"-Dstupid=idiot", "are", "--all", "--blee", "here"};
    protected static final String[] ARGLIST5 = new String[]{"-f", "myfile.txt"};
    private static final int DEFINE_OPT = 68;
    private static final int YOU_OPT = 121;
    private static final int ALL_OPT = 97;
    private static final int CLEAR1_OPT = 99;
    private static final int CLEAR2_OPT = 108;
    private static final int CLEAR3_OPT = 101;
    private static final int CLEAR5_OPT = 114;
    private static final int BLEE_OPT = 98;
    private static final int FILE_OPT = 102;
    protected static final CLOptionDescriptor DEFINE = new CLOptionDescriptor("define", 16, 68, "define");
    protected static final CLOptionDescriptor YOU = new CLOptionDescriptor("you", 8, 121, "you");
    protected static final CLOptionDescriptor ALL = new CLOptionDescriptor("all", 8, 97, "all", new int[]{98});
    protected static final CLOptionDescriptor CLEAR1 = new CLOptionDescriptor("c", 8, 99, "c");
    protected static final CLOptionDescriptor CLEAR2 = new CLOptionDescriptor("l", 8, 108, "l");
    protected static final CLOptionDescriptor CLEAR3 = new CLOptionDescriptor("e", 8, 101, "e");
    protected static final CLOptionDescriptor CLEAR5 = new CLOptionDescriptor("r", 8, 114, "r");
    protected static final CLOptionDescriptor BLEE = new CLOptionDescriptor("blee", 8, 98, "blee");
    protected static final CLOptionDescriptor FILE = new CLOptionDescriptor("file", 2, 102, "the build file.");

    public void testFullParse() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{YOU, ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST1, cLOptionDescriptorArray);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 8);
        this.assertEquality(((CLOption)vector.get(0)).getId(), 121);
        this.assertEquality(((CLOption)vector.get(1)).getId(), 0);
        this.assertEquality(((CLOption)vector.get(2)).getId(), 97);
        this.assertEquality(((CLOption)vector.get(3)).getId(), 99);
        this.assertEquality(((CLOption)vector.get(4)).getId(), 108);
        this.assertEquality(((CLOption)vector.get(5)).getId(), 101);
        this.assertEquality(((CLOption)vector.get(6)).getId(), 114);
        this.assertEquality(((CLOption)vector.get(7)).getId(), 0);
    }

    public void testDuplicateOptions() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1};
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST3, cLOptionDescriptorArray);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 5);
        this.assertEquality(((CLOption)vector.get(0)).getId(), 68);
        this.assertEquality(((CLOption)vector.get(1)).getId(), 0);
        this.assertEquality(((CLOption)vector.get(2)).getId(), 97);
        this.assertEquality(((CLOption)vector.get(3)).getId(), 97);
        this.assertEquality(((CLOption)vector.get(4)).getId(), 0);
    }

    public void testIncompatableOptions() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1, BLEE};
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST4, cLOptionDescriptorArray);
        this.assertNotNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 5);
        this.assertEquality(((CLOption)vector.get(0)).getId(), 68);
        this.assertEquality(((CLOption)vector.get(1)).getId(), 0);
        this.assertEquality(((CLOption)vector.get(2)).getId(), 97);
        this.assertEquality(((CLOption)vector.get(3)).getId(), 98);
        this.assertEquality(((CLOption)vector.get(4)).getId(), 0);
    }

    public void testSingleArg() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{FILE};
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST5, cLOptionDescriptorArray);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 1);
        this.assertEquality(((CLOption)vector.get(0)).getId(), 102);
        this.assertEquality(((CLOption)vector.get(0)).getArgument(), "myfile.txt");
    }

    public void test2ArgsParse() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1};
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST2, cLOptionDescriptorArray);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 4);
        this.assertEquality(((CLOption)vector.get(0)).getId(), 68);
        this.assertEquality(((CLOption)vector.get(1)).getId(), 0);
        this.assertEquality(((CLOption)vector.get(2)).getId(), 97);
        this.assertEquality(((CLOption)vector.get(3)).getId(), 0);
        CLOption cLOption = (CLOption)vector.get(0);
        this.assertEquality("stupid", cLOption.getArgument(0));
        this.assertEquality("idiot", cLOption.getArgument(1));
    }

    public void testPartParse() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{YOU};
        AbstractParserControl abstractParserControl = new AbstractParserControl(){

            public boolean isFinished(int n) {
                return n == 121;
            }
        };
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST1, cLOptionDescriptorArray, abstractParserControl);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 1);
        this.assertEquality(((CLOption)vector.get(0)).getId(), 121);
    }

    public void test2PartParse() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{YOU};
        CLOptionDescriptor[] cLOptionDescriptorArray2 = new CLOptionDescriptor[]{ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        AbstractParserControl abstractParserControl = new AbstractParserControl(){

            public boolean isFinished(int n) {
                return n == 121;
            }
        };
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST1, cLOptionDescriptorArray, abstractParserControl);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 1);
        this.assertEquality(((CLOption)vector.get(0)).getId(), 121);
        CLArgsParser cLArgsParser2 = new CLArgsParser(cLArgsParser.getUnparsedArgs(), cLOptionDescriptorArray2);
        this.assertNull(cLArgsParser2.getErrorString());
        Vector vector2 = cLArgsParser2.getArguments();
        int n2 = vector2.size();
        this.assertEquality(n2, 7);
        this.assertEquality(((CLOption)vector2.get(0)).getId(), 0);
        this.assertEquality(((CLOption)vector2.get(1)).getId(), 97);
        this.assertEquality(((CLOption)vector2.get(2)).getId(), 99);
        this.assertEquality(((CLOption)vector2.get(3)).getId(), 108);
        this.assertEquality(((CLOption)vector2.get(4)).getId(), 101);
        this.assertEquality(((CLOption)vector2.get(5)).getId(), 114);
        this.assertEquality(((CLOption)vector2.get(6)).getId(), 0);
    }

    public void test2PartPartialParse() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{YOU, ALL, CLEAR1};
        CLOptionDescriptor[] cLOptionDescriptorArray2 = new CLOptionDescriptor[]{};
        AbstractParserControl abstractParserControl = new AbstractParserControl(){

            public boolean isFinished(int n) {
                return n == 99;
            }
        };
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST1, cLOptionDescriptorArray, abstractParserControl);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 4);
        this.assertEquality(((CLOption)vector.get(0)).getId(), 121);
        this.assertEquality(((CLOption)vector.get(1)).getId(), 0);
        this.assertEquality(((CLOption)vector.get(2)).getId(), 97);
        this.assertEquality(((CLOption)vector.get(3)).getId(), 99);
        this.assert(cLArgsParser.getUnparsedArgs()[0].equals("ler"));
        CLArgsParser cLArgsParser2 = new CLArgsParser(cLArgsParser.getUnparsedArgs(), cLOptionDescriptorArray2);
        this.assertNull(cLArgsParser2.getErrorString());
        Vector vector2 = cLArgsParser2.getArguments();
        int n2 = vector2.size();
        this.assertEquality(n2, 2);
        this.assertEquality(((CLOption)vector2.get(0)).getId(), 0);
        this.assertEquality(((CLOption)vector2.get(1)).getId(), 0);
    }

    public void testDuplicatesFail() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{YOU, ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        String[] stringArray = new String[]{"--you", "are", "--all", "-clear", "kid"};
        CLArgsParser cLArgsParser = new CLArgsParser(ARGLIST1, cLOptionDescriptorArray);
        this.assertNull(cLArgsParser.getErrorString());
    }

    public void testIncomplete2Args() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{DEFINE};
        CLArgsParser cLArgsParser = new CLArgsParser(new String[]{"-Dstupid="}, cLOptionDescriptorArray);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 1);
        CLOption cLOption = (CLOption)vector.get(0);
        this.assertEquality(cLOption.getId(), 68);
        this.assertEquality(cLOption.getArgument(0), "stupid");
        this.assertEquality(cLOption.getArgument(1), "");
    }

    public void testIncomplete2ArgsMixed() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{DEFINE, CLEAR1};
        String[] stringArray = new String[]{"-Dstupid=", "-c"};
        CLArgsParser cLArgsParser = new CLArgsParser(stringArray, cLOptionDescriptorArray);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 2);
        this.assertEquality(((CLOption)vector.get(1)).getId(), 99);
        CLOption cLOption = (CLOption)vector.get(0);
        this.assertEquality(cLOption.getId(), 68);
        this.assertEquality(cLOption.getArgument(0), "stupid");
        this.assertEquality(cLOption.getArgument(1), "");
    }

    public void fail_testIncomplete2ArgsMixedNoEq() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{DEFINE, CLEAR1};
        String[] stringArray = new String[]{"-Dstupid", "-c"};
        CLArgsParser cLArgsParser = new CLArgsParser(stringArray, cLOptionDescriptorArray);
        this.assertNull(cLArgsParser.getErrorString());
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        this.assertEquality(n, 2);
        this.assertEquality(((CLOption)vector.get(1)).getId(), 99);
        CLOption cLOption = (CLOption)vector.get(0);
        this.assertEquality(cLOption.getId(), 68);
        this.assertEquality(cLOption.getArgument(0), "stupid");
        this.assertEquality(cLOption.getArgument(1), "");
    }
}

