/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DOMNormalizer;
import org.apache.xerces.dom.DOMValidationConfiguration;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentFragmentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeListCache;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.UserDataHandler;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.ShadowedSymbolTable;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.DOMWriter;
import org.w3c.dom.ls.DocumentLS;

public class CoreDocumentImpl
extends ParentNode
implements Document,
DocumentLS {
    static final long serialVersionUID = 0L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    transient NodeListCache fFreeNLCache;
    protected String encoding;
    protected String actualEncoding;
    protected String version;
    protected boolean standalone;
    protected String fDocumentURI;
    protected final transient DOMErrorHandlerWrapper fErrorHandlerWrapper = new DOMErrorHandlerWrapper();
    protected Hashtable userData;
    protected Hashtable identifiers;
    protected short features = 0;
    protected static final short NAMESPACES = 1;
    protected static final short DTNORMALIZATION = 2;
    protected static final short ENTITIES = 4;
    protected static final short CDATA = 8;
    protected static final short DEFAULTS = 16;
    protected static final short SPLITCDATA = 32;
    protected static final short COMMENTS = 64;
    protected static final short VALIDATION = 128;
    protected DOMNormalizer domNormalizer = null;
    protected DOMValidationConfiguration fConfiguration = null;
    private static final int[] kidOK = new int[13];
    protected int changes = 0;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;

    public CoreDocumentImpl() {
        this(false);
    }

    public CoreDocumentImpl(boolean bl) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = bl;
        this.features = (short)(this.features | 1);
        this.features = (short)(this.features | 4);
        this.features = (short)(this.features | 0x40);
        this.features = (short)(this.features | 2);
        this.features = (short)(this.features | 8);
        this.features = (short)(this.features | 0x10);
        this.features = (short)(this.features | 0x20);
    }

    public CoreDocumentImpl(DocumentType documentType) {
        this(documentType, false);
    }

    public CoreDocumentImpl(DocumentType documentType, boolean bl) {
        this(bl);
        if (documentType != null) {
            try {
                DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)documentType;
            }
            catch (ClassCastException classCastException) {
                String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string);
            }
            documentTypeImpl.ownerDocument = this;
            this.appendChild(documentType);
        }
    }

    public final Document getOwnerDocument() {
        return null;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public Node cloneNode(boolean bl) {
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl();
        this.callUserDataHandlers(this, coreDocumentImpl, (short)1);
        this.cloneNode(coreDocumentImpl, bl);
        return coreDocumentImpl;
    }

    protected void cloneNode(CoreDocumentImpl coreDocumentImpl, boolean bl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            Object object;
            Hashtable hashtable = null;
            if (this.identifiers != null) {
                hashtable = new Hashtable();
                object = this.identifiers.keys();
                while (object.hasMoreElements()) {
                    Object e = object.nextElement();
                    hashtable.put(this.identifiers.get(e), e);
                }
            }
            object = this.firstChild;
            while (object != null) {
                coreDocumentImpl.appendChild(coreDocumentImpl.importNode((Node)object, true, true, hashtable));
                object = ((ChildNode)object).nextSibling;
            }
        }
        coreDocumentImpl.allowGrammarAccess = this.allowGrammarAccess;
        coreDocumentImpl.errorChecking = this.errorChecking;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (this.errorChecking && (s == 1 && this.docElement != null || s == 10 && this.docType != null)) {
            String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
            throw new DOMException(3, string);
        }
        if (node.getOwnerDocument() == null && node instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)node).ownerDocument = this;
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node.getOwnerDocument() == null && node instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)node).ownerDocument = this;
        }
        super.replaceChild(node, node2);
        short s = node2.getNodeType();
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node2;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String string) throws DOMException {
    }

    public Attr createAttribute(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrImpl(this, string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new ElementImpl(this, string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new EntityReferenceImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string3);
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public DOMImplementation getImplementation() {
        return CoreDOMImplementationImpl.getDOMImplementation();
    }

    public void setErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    public boolean getStrictErrorChecking() {
        return this.errorChecking;
    }

    public String getActualEncoding() {
        return this.actualEncoding;
    }

    public void setActualEncoding(String string) {
        this.actualEncoding = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public String getDocumentURI() {
        return this.fDocumentURI;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fErrorHandlerWrapper.getErrorHandler();
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.fErrorHandlerWrapper.setErrorHandler(dOMErrorHandler);
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        if (node.getOwnerDocument() != this) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, string3);
        }
        switch (node.getNodeType()) {
            case 1: {
                ElementImpl elementImpl = (ElementImpl)node;
                if (elementImpl instanceof ElementNSImpl) {
                    ((ElementNSImpl)elementImpl).rename(string, string2);
                } else if (string == null) {
                    elementImpl.rename(string2);
                } else {
                    ElementNSImpl elementNSImpl = new ElementNSImpl(this, string, string2);
                    this.copyEventListeners(elementImpl, elementNSImpl);
                    Hashtable hashtable = this.removeUserDataTable(elementImpl);
                    Node node2 = elementImpl.getParentNode();
                    Node node3 = elementImpl.getNextSibling();
                    if (node2 != null) {
                        node2.removeChild(elementImpl);
                    }
                    Node node4 = elementImpl.getFirstChild();
                    while (node4 != null) {
                        elementImpl.removeChild(node4);
                        elementNSImpl.appendChild(node4);
                        node4 = elementImpl.getFirstChild();
                    }
                    elementNSImpl.moveSpecifiedAttributes(elementImpl);
                    this.setUserDataTable(elementNSImpl, hashtable);
                    this.callUserDataHandlers(elementImpl, elementNSImpl, (short)4);
                    if (node2 != null) {
                        node2.insertBefore(elementNSImpl, node3);
                    }
                    elementImpl = elementNSImpl;
                }
                this.renamedElement((Element)node, elementImpl);
                return elementImpl;
            }
            case 2: {
                AttrImpl attrImpl = (AttrImpl)node;
                Element element = attrImpl.getOwnerElement();
                if (element != null) {
                    element.removeAttributeNode(attrImpl);
                }
                if (node instanceof AttrNSImpl) {
                    ((AttrNSImpl)attrImpl).rename(string, string2);
                    if (element != null) {
                        element.setAttributeNodeNS(attrImpl);
                    }
                } else if (string == null) {
                    attrImpl.rename(string2);
                    if (element != null) {
                        element.setAttributeNode(attrImpl);
                    }
                } else {
                    AttrNSImpl attrNSImpl = new AttrNSImpl(this, string, string2);
                    this.copyEventListeners(attrImpl, attrNSImpl);
                    Hashtable hashtable = this.removeUserDataTable(attrImpl);
                    Node node5 = attrImpl.getFirstChild();
                    while (node5 != null) {
                        attrImpl.removeChild(node5);
                        attrNSImpl.appendChild(node5);
                        node5 = attrImpl.getFirstChild();
                    }
                    this.setUserDataTable(attrNSImpl, hashtable);
                    this.callUserDataHandlers(attrImpl, attrNSImpl, (short)4);
                    if (element != null) {
                        element.setAttributeNode(attrNSImpl);
                    }
                    attrImpl = attrNSImpl;
                }
                this.renamedAttrNode((Attr)node, attrImpl);
                return attrImpl;
            }
        }
        String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
        throw new DOMException(9, string4);
    }

    public void normalizeDocument() {
        if (this.isNormalized() && !this.isNormalizeDocRequired()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.domNormalizer == null) {
            this.domNormalizer = new DOMNormalizer();
        }
        if (this.fConfiguration == null) {
            this.fConfiguration = new DOMValidationConfiguration();
        }
        if (this.fErrorHandlerWrapper.getErrorHandler() != null) {
            this.fConfiguration.setErrorHandler(this.fErrorHandlerWrapper);
        }
        this.fConfiguration.reset();
        if ((this.features & 0x80) != 0) {
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.domNormalizer.setValidationHandler(CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/2001/XMLSchema"));
        } else {
            this.domNormalizer.setValidationHandler(null);
        }
        this.domNormalizer.reset(this.fConfiguration);
        try {
            this.domNormalizer.normalizeDocument(this);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if ((this.features & 0x80) != 0) {
            CoreDOMImplementationImpl.singleton.releaseValidator("http://www.w3.org/2001/XMLSchema");
        }
        this.isNormalized(true);
    }

    protected boolean isNormalizeDocRequired() {
        return true;
    }

    public void setNormalizationFeature(String string, boolean bl) throws DOMException {
        if (string.equals("comments")) {
            this.features = bl ? (short)(this.features | 0x40) : (short)(this.features & 0xFFFFFFBF);
        } else if (string.equals("datatype-normalization")) {
            this.features = bl ? (short)(this.features | 2) : (short)(this.features & 0xFFFFFFFD);
        } else if (string.equals("namespaces")) {
            this.features = bl ? (short)(this.features | 1) : (short)(this.features & 0xFFFFFFFE);
        } else if (string.equals("cdata-sections")) {
            this.features = bl ? (short)(this.features | 8) : (short)(this.features & 0xFFFFFFF7);
        } else if (string.equals("entities")) {
            this.features = bl ? (short)(this.features | 4) : (short)(this.features & 0xFFFFFFFB);
        } else if (string.equals("discard-default-content")) {
            this.features = bl ? (short)(this.features | 0x10) : (short)(this.features & 0xFFFFFFEF);
        } else if (string.equals("split-cdata-sections")) {
            this.features = bl ? (short)(this.features | 0x20) : (short)(this.features & 0xFFFFFFDF);
        } else if (string.equals("validate")) {
            this.features = bl ? (short)(this.features | 0x80) : (short)(this.features & 0xFFFFFF7F);
        } else if (string.equals("infoset") || string.equals("normalize-characters") || string.equals("canonical-form") || string.equals("validate-if-schema")) {
            if (bl) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string2);
            }
        } else if (string.equals("namespace-declarations") || string.equals("whitespace-in-element-content")) {
            if (!bl) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string3);
            }
        } else {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string4);
        }
    }

    public boolean getNormalizationFeature(String string) throws DOMException {
        if (string.equals("comments")) {
            return (this.features & 0x40) != 0;
        }
        if (string.equals("namespaces")) {
            return (this.features & 1) != 0;
        }
        if (string.equals("datatype-normalization")) {
            return (this.features & 2) != 0;
        }
        if (string.equals("cdata-sections")) {
            return (this.features & 8) != 0;
        }
        if (string.equals("entities")) {
            return (this.features & 4) != 0;
        }
        if (string.equals("discard-default-content")) {
            return (this.features & 0x10) != 0;
        }
        if (string.equals("split-cdata-sections")) {
            return (this.features & 0x20) != 0;
        }
        if (string.equals("infoset") || string.equals("normalize-characters") || string.equals("canonical-form") || string.equals("validate") || string.equals("validate-if-schema")) {
            return false;
        }
        if (string.equals("namespace-declarations") || string.equals("whitespace-in-element-content")) {
            return true;
        }
        String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
        throw new DOMException(8, string2);
    }

    public boolean canSetNormalizationFeature(String string, boolean bl) {
        if (string.equals("comments") || string.equals("datatype-normalization") || string.equals("cdata-sections") || string.equals("entities") || string.equals("discard-default-content") || string.equals("split-cdata-sections") || string.equals("namespaces")) {
            return true;
        }
        if (string.equals("infoset") || string.equals("normalize-characters") || string.equals("canonical-form") || string.equals("validate") || string.equals("validate-if-schema")) {
            return !bl;
        }
        if (string.equals("namespace-declarations") || string.equals("whitespace-in-element-content")) {
            return bl;
        }
        String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
        throw new DOMException(8, string2);
    }

    public String getBaseURI() {
        return this.fDocumentURI;
    }

    public void setDocumentURI(String string) {
        this.fDocumentURI = string;
    }

    public boolean getAsync() {
        return false;
    }

    public void setAsync(boolean bl) {
        if (bl) {
            String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string);
        }
    }

    public void abort() {
    }

    public boolean load(String string) {
        return false;
    }

    public boolean loadXML(String string) {
        return false;
    }

    public String saveXML(Node node) throws DOMException {
        if (node != null && this.getOwnerDocument() != node.getOwnerDocument()) {
            String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, string);
        }
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)DOMImplementationImpl.getDOMImplementation());
        DOMWriter dOMWriter = dOMImplementationLS.createDOMWriter();
        if (node == null) {
            node = this;
        }
        return dOMWriter.writeToString(node);
    }

    void setMutationEvents(boolean bl) {
    }

    boolean getMutationEvents() {
        return false;
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string4);
        }
        return new DocumentTypeImpl(this, string, string2, string3);
    }

    public Entity createEntity(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new EntityImpl(this, string);
    }

    public Notation createNotation(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new NotationImpl(this, string);
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new ElementDefinitionImpl(this, string);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.importNode(node, bl, false, null);
    }

    private Node importNode(Node node, boolean bl, boolean bl2, Hashtable hashtable) throws DOMException {
        Node node2;
        Node node3 = null;
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                Object v;
                int n;
                boolean bl3 = node.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                node2 = !bl3 || node.getLocalName() == null ? this.createElement(node.getNodeName()) : this.createElementNS(node.getNamespaceURI(), node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n2 = namedNodeMap.getLength();
                    n = 0;
                    while (n < n2) {
                        Attr attr = (Attr)namedNodeMap.item(n);
                        if (attr.getSpecified() || bl2) {
                            Attr attr2 = (Attr)this.importNode(attr, true, bl2, hashtable);
                            if (!bl3 || attr.getLocalName() == null) {
                                node2.setAttributeNode(attr2);
                            } else {
                                node2.setAttributeNodeNS(attr2);
                            }
                        }
                        ++n;
                    }
                }
                if (hashtable != null && (v = hashtable.get(node)) != null) {
                    if (this.identifiers == null) {
                        this.identifiers = new Hashtable();
                    }
                    this.identifiers.put(v, node2);
                }
                node3 = node2;
                break;
            }
            case 2: {
                node3 = node.getOwnerDocument().getImplementation().hasFeature("XML", "2.0") ? (node.getLocalName() == null ? this.createAttribute(node.getNodeName()) : this.createAttributeNS(node.getNamespaceURI(), node.getNodeName())) : this.createAttribute(node.getNodeName());
                if (node instanceof AttrImpl) {
                    node2 = (AttrImpl)node;
                    if (((NodeImpl)node2).hasStringValue()) {
                        AttrImpl attrImpl = (AttrImpl)node3;
                        attrImpl.setValue(((AttrImpl)node2).getValue());
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (node.getFirstChild() == null) {
                    node3.setNodeValue(node.getNodeValue());
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 3: {
                node3 = this.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                node3 = this.createCDATASection(node.getNodeValue());
                break;
            }
            case 5: {
                node3 = this.createEntityReference(node.getNodeName());
                bl = false;
                break;
            }
            case 6: {
                node2 = (Entity)node;
                EntityImpl entityImpl = (EntityImpl)this.createEntity(node.getNodeName());
                entityImpl.setPublicId(node2.getPublicId());
                entityImpl.setSystemId(node2.getSystemId());
                entityImpl.setNotationName(node2.getNotationName());
                entityImpl.isReadOnly(false);
                node3 = entityImpl;
                break;
            }
            case 7: {
                node3 = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                node3 = this.createComment(node.getNodeValue());
                break;
            }
            case 10: {
                int n;
                if (!bl2) {
                    String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                    throw new DOMException(9, string);
                }
                node2 = (DocumentType)node;
                DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)this.createDocumentType(node2.getNodeName(), node2.getPublicId(), node2.getSystemId());
                NamedNodeMap namedNodeMap = node2.getEntities();
                NamedNodeMap namedNodeMap2 = documentTypeImpl.getEntities();
                if (namedNodeMap != null) {
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        namedNodeMap2.setNamedItem(this.importNode(namedNodeMap.item(n), true, true, hashtable));
                        ++n;
                    }
                }
                namedNodeMap = node2.getNotations();
                namedNodeMap2 = documentTypeImpl.getNotations();
                if (namedNodeMap != null) {
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        namedNodeMap2.setNamedItem(this.importNode(namedNodeMap.item(n), true, true, hashtable));
                        ++n;
                    }
                }
                node3 = documentTypeImpl;
                break;
            }
            case 11: {
                node3 = this.createDocumentFragment();
                break;
            }
            case 12: {
                node2 = (Notation)node;
                NotationImpl notationImpl = (NotationImpl)this.createNotation(node.getNodeName());
                notationImpl.setPublicId(node2.getPublicId());
                notationImpl.setSystemId(node2.getSystemId());
                node3 = notationImpl;
                break;
            }
            default: {
                String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                throw new DOMException(9, string);
            }
        }
        this.callUserDataHandlers(node, node3, (short)2);
        if (bl) {
            node2 = node.getFirstChild();
            while (node2 != null) {
                node3.appendChild(this.importNode(node2, true, bl2, hashtable));
                node2 = node2.getNextSibling();
            }
        }
        if (node3.getNodeType() == 6) {
            ((NodeImpl)node3).setReadOnly(true, true);
        }
        return node3;
    }

    public Node adoptNode(Node node) {
        NodeImpl nodeImpl;
        try {
            nodeImpl = (NodeImpl)node;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        switch (nodeImpl.getNodeType()) {
            case 2: {
                AttrImpl attrImpl = (AttrImpl)nodeImpl;
                attrImpl.getOwnerElement().removeAttributeNode(attrImpl);
                attrImpl.isSpecified(true);
                attrImpl.setOwnerDocument(this);
                break;
            }
            case 9: 
            case 10: {
                String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                throw new DOMException(9, string);
            }
            case 5: {
                NamedNodeMap namedNodeMap;
                Node node2;
                Node node3;
                Node node4 = nodeImpl.getParentNode();
                if (node4 != null) {
                    node4.removeChild(node);
                }
                while ((node3 = nodeImpl.getFirstChild()) != null) {
                    nodeImpl.removeChild(node3);
                }
                nodeImpl.setOwnerDocument(this);
                if (this.docType == null || (node2 = (namedNodeMap = this.docType.getEntities()).getNamedItem(nodeImpl.getNodeName())) == null) break;
                EntityImpl entityImpl = (EntityImpl)node2;
                node3 = node2.getFirstChild();
                while (node3 != null) {
                    Node node5 = node3.cloneNode(true);
                    nodeImpl.appendChild(node5);
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 1: {
                Node node6 = nodeImpl.getParentNode();
                if (node6 != null) {
                    node6.removeChild(node);
                }
                nodeImpl.setOwnerDocument(this);
                ((ElementImpl)nodeImpl).reconcileDefaultAttributes();
                break;
            }
            default: {
                Node node7 = nodeImpl.getParentNode();
                if (node7 != null) {
                    node7.removeChild(node);
                }
                nodeImpl.setOwnerDocument(this);
            }
        }
        return nodeImpl;
    }

    public Element getElementById(String string) {
        return this.getIdentifier(string);
    }

    public void putIdentifier(String string, Element element) {
        if (element == null) {
            this.removeIdentifier(string);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    public Element getIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(string);
    }

    public void removeIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(string);
    }

    public Enumeration getIdentifiers() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string3);
        }
        return new ElementNSImpl(this, string, string2);
    }

    public Element createElementNS(String string, String string2, String string3) throws DOMException {
        return new ElementNSImpl(this, string, string2, string3);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string3);
        }
        return new AttrNSImpl(this, string, string2);
    }

    public Attr createAttributeNS(String string, String string2, String string3) throws DOMException {
        return new AttrNSImpl(this, string, string2, string3);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public Object clone() throws CloneNotSupportedException {
        CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)super.clone();
        coreDocumentImpl.docType = null;
        coreDocumentImpl.docElement = null;
        return coreDocumentImpl;
    }

    public static boolean isXMLName(String string) {
        if (string == null) {
            return false;
        }
        return XMLChar.isValidName(string);
    }

    protected boolean isKidOK(Node node, Node node2) {
        if (this.allowGrammarAccess && node.getNodeType() == 10) {
            return node2.getNodeType() == 1;
        }
        return 0 != (kidOK[node.getNodeType()] & 1 << node2.getNodeType());
    }

    protected void changed() {
        ++this.changes;
    }

    protected int changes() {
        return this.changes;
    }

    NodeListCache getNodeListCache(ParentNode parentNode) {
        if (this.fFreeNLCache == null) {
            return new NodeListCache(parentNode);
        }
        NodeListCache nodeListCache = this.fFreeNLCache;
        this.fFreeNLCache = this.fFreeNLCache.next;
        nodeListCache.fChild = null;
        nodeListCache.fChildIndex = -1;
        nodeListCache.fLength = -1;
        if (nodeListCache.fOwner != null) {
            nodeListCache.fOwner.fNodeListCache = null;
        }
        nodeListCache.fOwner = parentNode;
        return nodeListCache;
    }

    void freeNodeListCache(NodeListCache nodeListCache) {
        nodeListCache.next = this.fFreeNLCache;
        this.fFreeNLCache = nodeListCache;
    }

    public Object setUserData(Node node, String string, Object object, UserDataHandler userDataHandler) {
        Hashtable<String, UserDataRecord> hashtable;
        if (object == null) {
            Object v;
            Hashtable hashtable2;
            if (this.userData != null && (hashtable2 = (Hashtable)this.userData.get(node)) != null && (v = hashtable2.remove(string)) != null) {
                UserDataRecord userDataRecord = (UserDataRecord)v;
                return userDataRecord.fData;
            }
            return null;
        }
        if (this.userData == null) {
            this.userData = new Hashtable();
            hashtable = new Hashtable<String, UserDataRecord>();
            this.userData.put(node, hashtable);
        } else {
            hashtable = (Hashtable<String, UserDataRecord>)this.userData.get(node);
            if (hashtable == null) {
                hashtable = new Hashtable();
                this.userData.put(node, hashtable);
            }
        }
        UserDataRecord userDataRecord = hashtable.put(string, new UserDataRecord(object, userDataHandler));
        if (userDataRecord != null) {
            UserDataRecord userDataRecord2 = userDataRecord;
            return userDataRecord2.fData;
        }
        return null;
    }

    public Object getUserData(Node node, String string) {
        if (this.userData == null) {
            return null;
        }
        Hashtable hashtable = (Hashtable)this.userData.get(node);
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v != null) {
            UserDataRecord userDataRecord = (UserDataRecord)v;
            return userDataRecord.fData;
        }
        return null;
    }

    Hashtable removeUserDataTable(Node node) {
        if (this.userData == null) {
            return null;
        }
        return (Hashtable)this.userData.get(node);
    }

    void setUserDataTable(Node node, Hashtable hashtable) {
        if (hashtable != null) {
            this.userData.put(node, hashtable);
        }
    }

    void callUserDataHandlers(Node node, Node node2, short s) {
        if (this.userData == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.userData.get(node);
        if (hashtable == null || hashtable.isEmpty()) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            UserDataRecord userDataRecord = (UserDataRecord)hashtable.get(string);
            if (userDataRecord.fHandler == null) continue;
            userDataRecord.fHandler.handle(s, string, userDataRecord.fData, node, node2);
        }
    }

    public void copyConfigurationProperties(XMLParserConfiguration xMLParserConfiguration) {
        XMLGrammarPool xMLGrammarPool;
        ShadowedSymbolTable shadowedSymbolTable = new ShadowedSymbolTable((SymbolTable)xMLParserConfiguration.getProperty("http://apache.org/xml/properties/internal/symbol-table"));
        this.fConfiguration = new DOMValidationConfiguration(shadowedSymbolTable);
        XMLEntityResolver xMLEntityResolver = xMLParserConfiguration.getEntityResolver();
        if (xMLEntityResolver != null) {
            this.fConfiguration.setEntityResolver(xMLEntityResolver);
        }
        if ((xMLGrammarPool = (XMLGrammarPool)xMLParserConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool")) != null) {
            XMLGrammarPoolImpl xMLGrammarPoolImpl = new XMLGrammarPoolImpl();
            xMLGrammarPoolImpl.cacheGrammars("http://www.w3.org/2001/XMLSchema", xMLGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema"));
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", xMLGrammarPoolImpl);
        }
    }

    protected void setUserData(NodeImpl nodeImpl, Object object) {
        this.setUserData(nodeImpl, "XERCES1DOMUSERDATA", object, null);
    }

    protected Object getUserData(NodeImpl nodeImpl) {
        return this.getUserData(nodeImpl, "XERCES1DOMUSERDATA");
    }

    protected void addEventListener(NodeImpl nodeImpl, String string, EventListener eventListener, boolean bl) {
    }

    protected void removeEventListener(NodeImpl nodeImpl, String string, EventListener eventListener, boolean bl) {
    }

    protected void copyEventListeners(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
    }

    protected boolean dispatchEvent(NodeImpl nodeImpl, Event event) {
        return false;
    }

    void replacedText(NodeImpl nodeImpl) {
    }

    void deletedText(NodeImpl nodeImpl, int n, int n2) {
    }

    void insertedText(NodeImpl nodeImpl, int n, int n2) {
    }

    void modifyingCharacterData(NodeImpl nodeImpl) {
    }

    void modifiedCharacterData(NodeImpl nodeImpl, String string, String string2) {
    }

    void insertingNode(NodeImpl nodeImpl, boolean bl) {
    }

    void insertedNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
    }

    void removingNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
    }

    void removedNode(NodeImpl nodeImpl, boolean bl) {
    }

    void replacingNode(NodeImpl nodeImpl) {
    }

    void replacedNode(NodeImpl nodeImpl) {
    }

    void modifiedAttrValue(AttrImpl attrImpl, String string) {
    }

    void setAttrNode(AttrImpl attrImpl, AttrImpl attrImpl2) {
    }

    void removedAttrNode(AttrImpl attrImpl, NodeImpl nodeImpl, String string) {
    }

    void renamedAttrNode(Attr attr, Attr attr2) {
    }

    void renamedElement(Element element, Element element2) {
    }

    static {
        CoreDocumentImpl.kidOK[9] = 1410;
        CoreDocumentImpl.kidOK[1] = 442;
        CoreDocumentImpl.kidOK[5] = 442;
        CoreDocumentImpl.kidOK[6] = 442;
        CoreDocumentImpl.kidOK[11] = 442;
        CoreDocumentImpl.kidOK[2] = 40;
        CoreDocumentImpl.kidOK[12] = 0;
        CoreDocumentImpl.kidOK[4] = 0;
        CoreDocumentImpl.kidOK[3] = 0;
        CoreDocumentImpl.kidOK[8] = 0;
        CoreDocumentImpl.kidOK[7] = 0;
        CoreDocumentImpl.kidOK[10] = 0;
    }

    class UserDataRecord
    implements Serializable {
        Object fData;
        UserDataHandler fHandler;

        UserDataRecord(Object object, UserDataHandler userDataHandler) {
            this.fData = object;
            this.fHandler = userDataHandler;
        }
    }
}

