/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public abstract class AbstractConfiguration
implements Configuration {
    protected abstract String getPrefix() throws ConfigurationException;

    public int getValueAsInteger() throws ConfigurationException {
        String value = this.getValue();
        try {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Integer.parseInt(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Integer.parseInt(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (Exception nfe) {
            throw new ConfigurationException("Cannot parse the value \"" + value + "\" as an integer in the configuration element \"" + this.getName() + "\" at " + this.getLocation());
        }
    }

    public int getValueAsInteger(int defaultValue) {
        try {
            return this.getValueAsInteger();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public long getValueAsLong() throws ConfigurationException {
        String value = this.getValue();
        try {
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Long.parseLong(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (Exception nfe) {
            throw new ConfigurationException("Cannot parse the value \"" + value + "\" as a long in the configuration element \"" + this.getName() + "\" at " + this.getLocation());
        }
    }

    public long getValueAsLong(long defaultValue) {
        try {
            return this.getValueAsLong();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public float getValueAsFloat() throws ConfigurationException {
        String value = this.getValue();
        try {
            return Float.parseFloat(value);
        }
        catch (Exception nfe) {
            throw new ConfigurationException("Cannot parse the value \"" + value + "\" as a float in the configuration element \"" + this.getName() + "\" at " + this.getLocation());
        }
    }

    public float getValueAsFloat(float defaultValue) {
        try {
            return this.getValueAsFloat();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public boolean getValueAsBoolean() throws ConfigurationException {
        String value = this.getValue();
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Cannot parse the value \"" + value + "\" as a boolean in the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public boolean getValueAsBoolean(boolean defaultValue) {
        try {
            return this.getValueAsBoolean();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public String getValue(String defaultValue) {
        try {
            return this.getValue();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public int getAttributeAsInteger(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Integer.parseInt(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Integer.parseInt(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (Exception nfe) {
            throw new ConfigurationException("Cannot parse the value \"" + value + "\" as an integer in the attribute \"" + name + "\" at " + this.getLocation());
        }
    }

    public int getAttributeAsInteger(String name, int defaultValue) {
        try {
            return this.getAttributeAsInteger(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public long getAttributeAsLong(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Long.parseLong(value.substring(2), 2);
            }
            return Long.parseLong(value);
        }
        catch (Exception nfe) {
            throw new ConfigurationException("Cannot parse the value \"" + value + "\" as a long in the attribute \"" + name + "\" at " + this.getLocation());
        }
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        try {
            return this.getAttributeAsLong(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public float getAttributeAsFloat(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            return Float.parseFloat(value);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot parse the value \"" + value + "\" as a float in the attribute \"" + name + "\" at " + this.getLocation());
        }
    }

    public float getAttributeAsFloat(String name, float defaultValue) {
        try {
            return this.getAttributeAsFloat(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public boolean getAttributeAsBoolean(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ConfigurationException("Cannot parse the value \"" + value + "\" as a boolean in the attribute \"" + name + "\" at " + this.getLocation());
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        try {
            return this.getAttributeAsBoolean(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public String getAttribute(String name, String defaultValue) {
        try {
            return this.getAttribute(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public Configuration getChild(String name) {
        return this.getChild(name, true);
    }

    public Configuration getChild(String name, boolean createNew) {
        Configuration[] children = this.getChildren(name);
        if (children.length > 0) {
            return children[0];
        }
        if (createNew) {
            return new DefaultConfiguration(name, "-");
        }
        return null;
    }

    public abstract String getValue() throws ConfigurationException;

    public abstract String getAttribute(String var1) throws ConfigurationException;

    public abstract String[] getAttributeNames();

    public abstract Configuration[] getChildren(String var1);

    public abstract Configuration[] getChildren();

    public abstract String getNamespace() throws ConfigurationException;

    public abstract String getLocation();

    public abstract String getName();
}

