/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.ant.antunit.AntUnitListener;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.ant.antunit.LogCapturer;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;

public class AntUnit
extends Task {
    public static final String ERROR_TESTS_FAILED = "Tests failed with ";
    public static final String ERROR_NO_TESTS = "You must specify build files to test.";
    public static final String ERROR_NON_FILES = "Only file system resources are supported.";
    private static final String SETUP = "setUp";
    private static final String TEST = "test";
    private static final String TEARDOWN = "tearDown";
    private Union buildFiles;
    private Project newProject;
    private ArrayList listeners = new ArrayList();
    private ArrayList propertySets = new ArrayList();
    private int failures = 0;
    private int errors = 0;
    private boolean failOnError = true;
    private String errorProperty = null;

    public void add(ResourceCollection rc) {
        if (this.buildFiles == null) {
            this.buildFiles = new Union();
        }
        this.buildFiles.add(rc);
    }

    public void add(AntUnitListener al) {
        this.listeners.add(al);
        al.setParentTask(this);
    }

    public void addPropertySet(PropertySet ps) {
        this.propertySets.add(ps);
    }

    public void setErrorProperty(String s) {
        this.errorProperty = s;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void execute() {
        if (this.buildFiles == null) {
            throw new BuildException(ERROR_NO_TESTS);
        }
        this.doResourceCollection((ResourceCollection)this.buildFiles);
        if (this.failures > 0 || this.errors > 0) {
            if (this.errorProperty != null) {
                this.getProject().setNewProperty(this.errorProperty, "true");
            }
            if (this.failOnError) {
                throw new BuildException(ERROR_TESTS_FAILED + this.failures + " failure" + (this.failures != 1 ? "s" : "") + " and " + this.errors + " error" + (this.errors != 1 ? "s" : ""));
            }
        }
    }

    private void doResourceCollection(ResourceCollection rc) {
        if (!rc.isFilesystemOnly()) {
            throw new BuildException(ERROR_NON_FILES);
        }
        Iterator i = rc.iterator();
        while (i.hasNext()) {
            FileResource r = (FileResource)i.next();
            if (r.isExists()) {
                this.doFile(r.getFile());
                continue;
            }
            this.log("Skipping " + r + " since it doesn't exist", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doFile(File f) {
        block39: {
            this.log("Running tests in build file " + f, 4);
            this.newProject = this.createProjectForFile(f);
            Hashtable targets = this.newProject.getTargets();
            boolean setUp = targets.containsKey(SETUP);
            boolean tearDown = targets.containsKey(TEARDOWN);
            this.newProject.fireBuildStarted();
            Throwable caught = null;
            try {
                Iterator iter = targets.keySet().iterator();
                while (iter.hasNext()) {
                    Throwable t;
                    boolean failed;
                    BuildException e2222;
                    Object var14_16;
                    String name;
                    block35: {
                        name = (String)iter.next();
                        if (!name.startsWith(TEST) || name.equals(TEST)) continue;
                        Vector<String> v = new Vector<String>();
                        if (setUp) {
                            v.add(SETUP);
                        }
                        v.add(name);
                        LogCapturer lc = new LogCapturer(this.newProject);
                        this.fireStartTest(name);
                        this.newProject.executeTargets(v);
                        var14_16 = null;
                        this.fireEndTest(name);
                        if (!tearDown) break block35;
                        try {
                            this.newProject.executeTarget(TEARDOWN);
                        }
                        catch (AssertionFailedException e2222) {
                            this.fireFail(name, (AssertionFailedException)e2222);
                        }
                        catch (BuildException e2222) {
                            failed = false;
                            t = e2222.getCause();
                            while (t != null && t instanceof BuildException) {
                                if (t instanceof AssertionFailedException) {
                                    failed = true;
                                    this.fireFail(name, (AssertionFailedException)((Object)t));
                                    break;
                                }
                                t = ((BuildException)t).getCause();
                            }
                            if (failed) break block35;
                            this.fireError(name, e2222);
                        }
                    }
                    if (!iter.hasNext()) continue;
                    this.newProject = this.createProjectForFile(f);
                    {
                        continue;
                        catch (AssertionFailedException e3) {
                            block36: {
                                this.fireFail(name, e3);
                                var14_16 = null;
                                this.fireEndTest(name);
                                if (tearDown) {
                                    try {
                                        this.newProject.executeTarget(TEARDOWN);
                                    }
                                    catch (AssertionFailedException e2222) {
                                        this.fireFail(name, (AssertionFailedException)e2222);
                                    }
                                    catch (BuildException e2222) {
                                        failed = false;
                                        t = e2222.getCause();
                                        while (t != null && t instanceof BuildException) {
                                            if (t instanceof AssertionFailedException) {
                                                failed = true;
                                                this.fireFail(name, (AssertionFailedException)((Object)t));
                                                break;
                                            }
                                            t = ((BuildException)t).getCause();
                                        }
                                        if (failed) break block36;
                                        this.fireError(name, e2222);
                                    }
                                }
                            }
                            if (!iter.hasNext()) continue;
                            this.newProject = this.createProjectForFile(f);
                            continue;
                        }
                        catch (BuildException e4) {
                            block37: {
                                boolean failed2 = false;
                                Throwable t2 = e4.getCause();
                                while (t2 != null && t2 instanceof BuildException) {
                                    if (t2 instanceof AssertionFailedException) {
                                        failed2 = true;
                                        this.fireFail(name, (AssertionFailedException)((Object)t2));
                                        break;
                                    }
                                    t2 = ((BuildException)t2).getCause();
                                }
                                if (!failed2) {
                                    this.fireError(name, e4);
                                }
                                var14_16 = null;
                                this.fireEndTest(name);
                                if (tearDown) {
                                    try {
                                        this.newProject.executeTarget(TEARDOWN);
                                    }
                                    catch (AssertionFailedException e2222) {
                                        this.fireFail(name, (AssertionFailedException)e2222);
                                    }
                                    catch (BuildException e2222) {
                                        failed = false;
                                        t = e2222.getCause();
                                        while (t != null && t instanceof BuildException) {
                                            if (t instanceof AssertionFailedException) {
                                                failed = true;
                                                this.fireFail(name, (AssertionFailedException)((Object)t));
                                                break;
                                            }
                                            t = ((BuildException)t).getCause();
                                        }
                                        if (failed) break block37;
                                        this.fireError(name, e2222);
                                    }
                                }
                            }
                            if (!iter.hasNext()) continue;
                            this.newProject = this.createProjectForFile(f);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        block38: {
                            var14_16 = null;
                            this.fireEndTest(name);
                            if (tearDown) {
                                try {
                                    this.newProject.executeTarget(TEARDOWN);
                                }
                                catch (AssertionFailedException e2222) {
                                    this.fireFail(name, (AssertionFailedException)e2222);
                                }
                                catch (BuildException e2222) {
                                    failed = false;
                                    t = e2222.getCause();
                                    while (t != null && t instanceof BuildException) {
                                        if (t instanceof AssertionFailedException) {
                                            failed = true;
                                            this.fireFail(name, (AssertionFailedException)((Object)t));
                                            break;
                                        }
                                        t = ((BuildException)t).getCause();
                                    }
                                    if (failed) break block38;
                                    this.fireError(name, e2222);
                                }
                            }
                        }
                        if (iter.hasNext()) {
                            this.newProject = this.createProjectForFile(f);
                        }
                        throw throwable;
                    }
                }
                Object var19_21 = null;
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                this.newProject.fireBuildFinished(caught);
                this.newProject = null;
                throw throwable;
            }
            this.newProject.fireBuildFinished(caught);
            this.newProject = null;
            {
                break block39;
                catch (Throwable e) {
                    caught = e;
                    Object var19_22 = null;
                    this.newProject.fireBuildFinished(caught);
                    this.newProject = null;
                }
            }
        }
    }

    public void handleOutput(String outputToHandle) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(outputToHandle, false);
        } else {
            super.handleOutput(outputToHandle);
        }
    }

    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.newProject != null) {
            return this.newProject.demuxInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    public void handleFlush(String toFlush) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(toFlush, false);
        } else {
            super.handleFlush(toFlush);
        }
    }

    public void handleErrorOutput(String errorOutputToHandle) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(errorOutputToHandle, true);
        } else {
            super.handleErrorOutput(errorOutputToHandle);
        }
    }

    public void handleErrorFlush(String errorOutputToFlush) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(errorOutputToFlush, true);
        } else {
            super.handleErrorFlush(errorOutputToFlush);
        }
    }

    private Project createProjectForFile(File f) {
        Project p = new Project();
        p.setDefaultInputStream(this.getProject().getDefaultInputStream());
        p.initProperties();
        p.setInputHandler(this.getProject().getInputHandler());
        this.getProject().initSubProject(p);
        Iterator outer = this.propertySets.iterator();
        while (outer.hasNext()) {
            PropertySet set = (PropertySet)outer.next();
            Properties props = set.getProperties();
            Iterator keys = props.keySet().iterator();
            while (keys.hasNext()) {
                Object value;
                String key = keys.next().toString();
                if ("basedir".equals(key) || "ant.file".equals(key) || (value = props.get(key)) == null || !(value instanceof String) || p.getProperty(key) != null) continue;
                p.setNewProperty(key, (String)value);
            }
        }
        p.setUserProperty("ant.file", f.getAbsolutePath());
        this.attachListeners(f, p);
        ProjectHelper.configureProject((Project)p, (File)f);
        return p;
    }

    private void attachListeners(File buildFile, Project p) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            p.addBuildListener((BuildListener)new BuildToAntUnitListener(buildFile.getAbsolutePath(), al));
        }
    }

    private void fireStartTest(String targetName) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.startTest(targetName);
        }
    }

    private void fireFail(String targetName, AssertionFailedException ae) {
        ++this.failures;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.addFailure(targetName, ae);
        }
    }

    private void fireError(String targetName, Throwable t) {
        ++this.errors;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.addError(targetName, t);
        }
    }

    private void fireEndTest(String targetName) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            AntUnitListener al = (AntUnitListener)it.next();
            al.endTest(targetName);
        }
    }

    private class BuildToAntUnitListener
    implements BuildListener {
        private String buildFile;
        private AntUnitListener a;

        BuildToAntUnitListener(String buildFile, AntUnitListener a) {
            this.buildFile = buildFile;
            this.a = a;
        }

        public void buildStarted(BuildEvent event) {
            this.a.startTestSuite(event.getProject(), this.buildFile);
        }

        public void buildFinished(BuildEvent event) {
            this.a.endTestSuite(event.getProject(), this.buildFile);
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
        }
    }
}

