/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.monitor.Monitor;
import org.apache.avalon.excalibur.monitor.Resource;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public final class PassiveMonitor
extends AbstractLoggable
implements Monitor,
Component,
ThreadSafe,
Configurable {
    private static final Class[] m_constructorParams = new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = PassiveMonitor.class$("java.lang.String"))};
    private Map m_resources = new HashMap();
    private Map m_lastModified = Collections.synchronizedMap(new HashMap());
    private static /* synthetic */ Class class$Ljava$lang$String;

    public final void configure(Configuration conf) throws ConfigurationException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Configuration[] initialResources = conf.getChild("init-resources").getChildren("resource");
        int i = 0;
        while (i < initialResources.length) {
            block4: {
                String key = initialResources[i].getAttribute("key", "*** KEY NOT SPECIFIED ***");
                String className = initialResources[i].getAttribute("class", "*** CLASSNAME NOT SPECIFIED ***");
                try {
                    Class<?> clazz = loader.loadClass(className);
                    Constructor<?> initializer = clazz.getConstructor(m_constructorParams);
                    this.addResource((Resource)initializer.newInstance(key));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Initial Resource: \"" + key + "\" Initialized.");
                    }
                }
                catch (Exception e) {
                    if (!this.getLogger().isWarnEnabled()) break block4;
                    this.getLogger().warn("Initial Resource: \"" + key + "\" Failed (" + className + ").", (Throwable)e);
                }
            }
            ++i;
        }
    }

    public final void addResource(Resource resource) {
        Map map = this.m_resources;
        synchronized (map) {
            if (this.m_resources.containsKey(resource.getResourceKey())) {
                Resource original = (Resource)this.m_resources.get(resource.getResourceKey());
                original.addPropertyChangeListenersFrom(resource);
            } else {
                this.m_resources.put(resource.getResourceKey(), resource);
            }
        }
    }

    public final Resource getResource(String key) {
        Map map = this.m_resources;
        synchronized (map) {
            Resource resource = (Resource)this.m_resources.get(key);
            if (resource != null) {
                Long lastModified = (Long)this.m_lastModified.get(key);
                if (lastModified != null) {
                    resource.testModifiedAfter(lastModified);
                }
                this.m_lastModified.put(key, new Long(System.currentTimeMillis()));
            }
            return resource;
        }
    }

    public final void removeResource(String key) {
        Map map = this.m_resources;
        synchronized (map) {
            Resource resource = (Resource)this.m_resources.remove(key);
            resource.removeAllPropertyChangeListeners();
        }
    }

    public final void removeResource(Resource resource) {
        this.removeResource(resource.getResourceKey());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

