/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.datasource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Recyclable;
import org.apache.avalon.util.pool.Pool;

public class JdbcConnection
extends AbstractLoggable
implements Connection,
Recyclable {
    private Connection m_connection;
    private Pool m_pool;

    public JdbcConnection(Connection connection, Pool pool) {
        this.m_connection = connection;
        this.m_pool = pool;
    }

    public Statement createStatement() throws SQLException {
        return this.m_connection.createStatement();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.m_connection.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.m_connection.prepareCall(string);
    }

    public String nativeSQL(String string) throws SQLException {
        return this.m_connection.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.m_connection.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.m_connection.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.m_connection.commit();
    }

    public void rollback() throws SQLException {
        this.m_connection.rollback();
    }

    public void close() throws SQLException {
        this.setAutoCommit(false);
        this.m_pool.put(this);
    }

    public void recycle() {
        try {
            this.m_connection.close();
        }
        catch (SQLException sQLException) {
            this.getLogger().warn("Could not close connection", sQLException);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.m_connection.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.m_connection.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.m_connection.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.m_connection.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.m_connection.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        return this.m_connection.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.m_connection.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.m_connection.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_connection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.m_connection.clearWarnings();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.m_connection.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.m_connection.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.m_connection.prepareCall(string, n, n2);
    }

    public Map getTypeMap() throws SQLException {
        return this.m_connection.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.m_connection.setTypeMap(map);
    }
}

