/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import xjavadoc.AbstractProgramElement;
import xjavadoc.JavaDocReader;
import xjavadoc.TagIterator;
import xjavadoc.Token;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XJavaDocException;
import xjavadoc.XProgramElement;
import xjavadoc.XTag;
import xjavadoc.XTagFactory;
import xjavadoc.event.XDocEvent;
import xjavadoc.event.XDocListener;
import xjavadoc.event.XTagEvent;
import xjavadoc.event.XTagListener;

public final class XDoc
implements XTagListener {
    public static int instanceCount = 0;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String EMPTY_COMMENT = "/**\n */";
    private static final Log _log = LogFactory.getLog((String)(class$xjavadoc$XDoc == null ? (class$xjavadoc$XDoc = XDoc.class$("xjavadoc.XDoc")) : class$xjavadoc$XDoc).getName());
    private Map _tagMap;
    private Token _javadocToken;
    private XProgramElement _owner;
    private Collection _tags;
    private String _commentText = "";
    private String _firstSentence;
    private boolean _dirty = true;
    private Set _docListeners = new HashSet();
    static /* synthetic */ Class class$xjavadoc$XDoc;

    public XDoc(Token javadocToken, XProgramElement owner) {
        ++instanceCount;
        this._javadocToken = javadocToken == null ? Token.newToken(10) : javadocToken;
        this._owner = owner;
        if (this._javadocToken.image == null) {
            this._javadocToken.image = EMPTY_COMMENT;
        }
    }

    public static String dotted(String tagName) {
        return tagName.replace(':', '.');
    }

    private static final String tokenizeAndTrim(String s) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken()).append(" ");
        }
        return sb.toString().trim();
    }

    public XProgramElement getOwner() {
        return this._owner;
    }

    public Collection getTags(String tagName) {
        return this.getTags(tagName, false);
    }

    public Collection getTags(String tagName, boolean superclasses) {
        XDoc superDoc;
        tagName = XDoc.dotted(tagName);
        if (this._dirty) {
            this.parse();
        }
        this.ensureTagMapInitialised();
        Collection tags = (Collection)this._tagMap.get(tagName);
        if (!superclasses) {
            if (tags == null) {
                tags = AbstractProgramElement.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(tags);
        }
        LinkedList superTags = new LinkedList();
        if (tags != null) {
            superTags.addAll(tags);
        }
        if ((superDoc = this.getSuperDoc()) != null) {
            superTags.addAll(superDoc.getTags(tagName, true));
        }
        return Collections.unmodifiableCollection(superTags);
    }

    public Collection getTags() {
        return this.getTags(false);
    }

    public Collection getTags(boolean superclasses) {
        XDoc superDoc;
        if (this._dirty) {
            this.parse();
        }
        if (!superclasses) {
            if (this._tags == null) {
                return AbstractProgramElement.EMPTY_LIST;
            }
            return this._tags;
        }
        LinkedList tags = new LinkedList();
        if (this._tags != null) {
            tags.addAll(this._tags);
        }
        if ((superDoc = this.getSuperDoc()) != null) {
            tags.addAll(superDoc.getTags(true));
        }
        return Collections.unmodifiableCollection(tags);
    }

    public XTag getTag(String tagName) {
        return this.getTag(tagName, false);
    }

    public XTag getTag(String tagName, boolean superclasses) {
        Collection tags = this.getTags(tagName = XDoc.dotted(tagName), superclasses);
        if (tags.size() == 0) {
            return null;
        }
        return (XTag)tags.iterator().next();
    }

    public String getTagAttributeValue(String tagName, String attributeName) {
        return this.getTagAttributeValue(tagName, attributeName, false);
    }

    public String getTagAttributeValue(String tagName, String attributeName, boolean superclasses) {
        tagName = XDoc.dotted(tagName);
        Iterator tags = this.getTags(tagName).iterator();
        while (tags.hasNext()) {
            XTag tag = (XTag)tags.next();
            String attributeValue = tag.getAttributeValue(attributeName);
            if (attributeValue == null) continue;
            return attributeValue;
        }
        if (superclasses) {
            XDoc superDoc = this.getSuperDoc();
            if (superDoc != null) {
                return superDoc.getTagAttributeValue(tagName, attributeName, superclasses);
            }
            return null;
        }
        return null;
    }

    public String getCommentText() {
        if (this._dirty) {
            this.parse();
        }
        return this._commentText;
    }

    public String getFirstSentence() {
        if (this._dirty) {
            this.parse();
        }
        if (this._firstSentence == null) {
            if (this._commentText.indexOf(46) == -1) {
                this._firstSentence = this._commentText;
                return this._firstSentence;
            }
            int fromIndex = 0;
            while (fromIndex < this._commentText.length() - 1 && this._firstSentence == null) {
                int dotIndex = this._commentText.indexOf(46, fromIndex);
                if (dotIndex != -1 && dotIndex < this._commentText.length() - 1) {
                    if (" \t\r\n".indexOf(this._commentText.charAt(dotIndex + 1)) != -1) {
                        this._firstSentence = this._commentText.substring(0, dotIndex + 1);
                        continue;
                    }
                    fromIndex = dotIndex + 1;
                    continue;
                }
                this._firstSentence = this._commentText;
            }
            if (this._firstSentence == null) {
                this._firstSentence = this._commentText;
            }
        }
        return this._firstSentence;
    }

    public void setCommentText(String commentText) {
        if (this._dirty) {
            this.parse();
        }
        this._commentText = commentText;
        this._firstSentence = null;
        this.fireDocChanged();
    }

    public boolean hasTag(String tagName) {
        return this.hasTag(tagName, false);
    }

    public boolean hasTag(String tagName, boolean superclasses) {
        return this.getTags(tagName, superclasses).size() != 0;
    }

    public XTag updateTagValue(String tagName, String attributeName, String attributeValue, int tagIndex) throws XJavaDocException {
        XTag tag = null;
        Collection tags = this.getTags(tagName);
        if (tags.size() == 0 || tags.size() <= tagIndex) {
            String tagValue = attributeName + "=\"" + attributeValue + "\"";
            tag = this.addTag_Impl(tagName, tagValue);
        } else {
            TagIterator tagIterator = XCollections.tagIterator(tags);
            int i = 0;
            while (i < tagIndex) {
                tag = tagIterator.next();
                ++i;
            }
            if (tag != null) {
                tag.setAttribute(attributeName, attributeValue);
            }
        }
        return tag;
    }

    public void addDocListener(XDocListener docListener) {
        this._docListeners.add(docListener);
    }

    public void removeDocListener(XDocListener docListener) {
        this._docListeners.remove(docListener);
    }

    public String toString() {
        if (this._dirty) {
            this.parse();
        }
        StringBuffer sb = new StringBuffer("/**").append(NEWLINE);
        if (!this._commentText.trim().equals("")) {
            this.appendWhiteSpaces(sb).append(" * ").append(this._commentText).append(NEWLINE);
            this.appendWhiteSpaces(sb).append(" * ").append(NEWLINE);
        }
        Iterator tags = this.getTags().iterator();
        while (tags.hasNext()) {
            XTag tag = (XTag)tags.next();
            this.appendWhiteSpaces(sb).append(" * @").append(tag.getName());
            Collection attributeNames = tag.getAttributeNames();
            if (attributeNames.size() == 0) {
                sb.append(' ').append(tag.getValue()).append(NEWLINE);
                continue;
            }
            sb.append(NEWLINE);
            Iterator attrs = attributeNames.iterator();
            while (attrs.hasNext()) {
                String attibuteName = (String)attrs.next();
                String attributeValue = tag.getAttributeValue(attibuteName);
                this.appendWhiteSpaces(sb).append(" *    ").append(attibuteName).append("=\"").append(attributeValue).append("\"").append(NEWLINE);
            }
        }
        this.appendWhiteSpaces(sb).append(" */");
        return sb.toString();
    }

    public void updateToken() {
        this._javadocToken.image = this.toString();
    }

    public boolean removeTag(XTag tag) {
        boolean removed = this._tags.remove(tag);
        if (removed) {
            this.ensureTagMapInitialised();
            Collection tags = (Collection)this._tagMap.get(XDoc.dotted(tag.getName()));
            tags.remove(tag);
            this.fireDocChanged();
        }
        return removed;
    }

    public XTag addTag(String tagName, String text) {
        if (this._dirty) {
            this.parse();
        }
        XTag rtag = this.addTag_Impl(tagName, text);
        this.fireDocChanged();
        return rtag;
    }

    public void tagChanged(XTagEvent event) {
        if (event.getSource() instanceof XTag) {
            this.fireDocChanged();
        }
    }

    private XDoc getSuperDoc() {
        XProgramElement superElement = this._owner.getSuperElement();
        if (superElement != null) {
            return superElement.getDoc();
        }
        return null;
    }

    private final void ensureTagMapInitialised() {
        if (this._tagMap == null) {
            this._tagMap = new TreeMap();
        }
    }

    private XTag addTag_Impl(String tagName, String text) {
        tagName = XDoc.dotted(tagName);
        this.ensureTagMapInitialised();
        LinkedList<XTag> tags = (LinkedList<XTag>)this._tagMap.get(tagName);
        if (tags == null) {
            tags = new LinkedList<XTag>();
            this._tagMap.put(tagName, tags);
        }
        if (this._tags == null) {
            this._tags = new LinkedList();
        }
        XTag tag = XTagFactory.createTag(tagName, text);
        tag.addTagListener(this);
        tags.add(tag);
        this._tags.add(tag);
        return tag;
    }

    private void fireDocChanged() {
        Iterator i = this._docListeners.iterator();
        while (i.hasNext()) {
            XDocListener docListener = (XDocListener)i.next();
            docListener.docChanged(new XDocEvent(this));
        }
        if (this._owner != null) {
            XClass clazz = this._owner instanceof XClass ? (XClass)this._owner : this._owner.getContainingClass();
            clazz.setDirty();
        }
    }

    private StringBuffer appendWhiteSpaces(StringBuffer sb) {
        return sb.append("   ");
    }

    private void parse() {
        if (this._dirty) {
            BufferedReader in = new BufferedReader(new JavaDocReader(new StringReader(this._javadocToken.image)));
            StringBuffer docElement = new StringBuffer();
            String tagName = null;
            String line = null;
            try {
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("@")) {
                        if (tagName == null) {
                            this._commentText = XDoc.tokenizeAndTrim(docElement.toString());
                        } else {
                            this.addTag_Impl(tagName, XDoc.tokenizeAndTrim(docElement.toString()));
                        }
                        docElement = new StringBuffer();
                        StringTokenizer st = new StringTokenizer(line);
                        tagName = st.nextToken().substring(1);
                        docElement.append(line.substring(tagName.length() + 1).trim()).append(' ');
                        continue;
                    }
                    if (docElement == null) {
                        docElement = new StringBuffer();
                    }
                    docElement.append(line.trim()).append(' ');
                }
                if (tagName == null) {
                    this._commentText = docElement.toString().trim();
                } else {
                    this.addTag_Impl(tagName, XDoc.tokenizeAndTrim(docElement.toString()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (StringIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            this._dirty = false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

