/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.DoubleOrderedMap;

public final class DoubleOrderedMap
extends AbstractMap {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node[] rootNode = new Node[]{null, null};
    private int nodeCount = 0;
    private int modifications = 0;
    private Set[] setOfKeys = new Set[]{null, null};
    private Set[] setOfEntries = new Set[]{null, null};
    private Collection[] collectionOfValues = new Collection[]{null, null};

    public final Object getKeyForValue(Object object) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)object, 1);
    }

    public final Object removeValue(Object object) {
        return this.doRemove((Comparable)object, 1);
    }

    public final Set entrySetByValue() {
        if (this.setOfEntries[1] == null) {
            this.setOfEntries[1] = new AbstractSet(this){
                private final /* synthetic */ DoubleOrderedMap this$0;

                public final Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1, this.this$0){
                        private final /* synthetic */ 1 this$0;

                        protected final Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                        {
                            DoubleOrderedMap doubleOrderedMap2 = doubleOrderedMap;
                            if (doubleOrderedMap2 == null) {
                                throw null;
                            }
                            super(n);
                            this.this$0 = var1_1;
                            this.constructor$0(var1_1, n);
                        }

                        private final void constructor$0(1 var1_1, int n) {
                        }
                    };
                }

                public final boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    K k = entry.getKey();
                    Node node = DoubleOrderedMap.access$1(this.this$0, (Comparable)entry.getValue(), 1);
                    return node != null && Node.access$0(node, 0).equals(k);
                }

                public final boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    K k = entry.getKey();
                    Node node = DoubleOrderedMap.access$1(this.this$0, (Comparable)entry.getValue(), 1);
                    if (node != null && Node.access$0(node, 0).equals(k)) {
                        DoubleOrderedMap.access$3(this.this$0, node);
                        return true;
                    }
                    return false;
                }

                public final int size() {
                    return this.this$0.size();
                }

                public final void clear() {
                    this.this$0.clear();
                }
                {
                    this.this$0 = doubleOrderedMap;
                    this.constructor$0(doubleOrderedMap);
                }

                private final void constructor$0(DoubleOrderedMap doubleOrderedMap) {
                }
            };
        }
        return this.setOfEntries[1];
    }

    public final Set keySetByValue() {
        if (this.setOfKeys[1] == null) {
            this.setOfKeys[1] = new AbstractSet(this){
                private final /* synthetic */ DoubleOrderedMap this$0;

                public final Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1, this.this$0){
                        private final /* synthetic */ 3 this$0;

                        protected final Object doGetNext() {
                            return Node.access$0(this.lastReturnedNode, 0);
                        }
                        {
                            DoubleOrderedMap doubleOrderedMap2 = doubleOrderedMap;
                            if (doubleOrderedMap2 == null) {
                                throw null;
                            }
                            super(n);
                            this.this$0 = var1_1;
                            this.constructor$0(var1_1, n);
                        }

                        private final void constructor$0(3 var1_1, int n) {
                        }
                    };
                }

                public final int size() {
                    return this.this$0.size();
                }

                public final boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public final boolean remove(Object object) {
                    int n = DoubleOrderedMap.access$4(this.this$0);
                    this.this$0.remove(object);
                    return DoubleOrderedMap.access$4(this.this$0) != n;
                }

                public final void clear() {
                    this.this$0.clear();
                }
                {
                    this.this$0 = doubleOrderedMap;
                    this.constructor$0(doubleOrderedMap);
                }

                private final void constructor$0(DoubleOrderedMap doubleOrderedMap) {
                }
            };
        }
        return this.setOfKeys[1];
    }

    public final Collection valuesByValue() {
        if (this.collectionOfValues[1] == null) {
            this.collectionOfValues[1] = new AbstractCollection(this){
                private final /* synthetic */ DoubleOrderedMap this$0;

                public final Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1, this.this$0){
                        private final /* synthetic */ 5 this$0;

                        protected final Object doGetNext() {
                            return Node.access$0(this.lastReturnedNode, 1);
                        }
                        {
                            DoubleOrderedMap doubleOrderedMap2 = doubleOrderedMap;
                            if (doubleOrderedMap2 == null) {
                                throw null;
                            }
                            super(n);
                            this.this$0 = var1_1;
                            this.constructor$0(var1_1, n);
                        }

                        private final void constructor$0(5 var1_1, int n) {
                        }
                    };
                }

                public final int size() {
                    return this.this$0.size();
                }

                public final boolean contains(Object object) {
                    return this.this$0.containsValue(object);
                }

                public final boolean remove(Object object) {
                    int n = DoubleOrderedMap.access$4(this.this$0);
                    this.this$0.removeValue(object);
                    return DoubleOrderedMap.access$4(this.this$0) != n;
                }

                public final boolean removeAll(Collection collection) {
                    boolean bl = false;
                    Iterator<E> iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (this.this$0.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public final void clear() {
                    this.this$0.clear();
                }
                {
                    this.this$0 = doubleOrderedMap;
                    this.constructor$0(doubleOrderedMap);
                }

                private final void constructor$0(DoubleOrderedMap doubleOrderedMap) {
                }
            };
        }
        return this.collectionOfValues[1];
    }

    private final Object doRemove(Comparable comparable, int n) {
        Node node = this.lookup(comparable, n);
        Comparable comparable2 = null;
        if (node != null) {
            comparable2 = node.getData(this.oppositeIndex(n));
            this.doRedBlackDelete(node);
        }
        return comparable2;
    }

    private final Object doGet(Comparable comparable, int n) {
        DoubleOrderedMap.checkNonNullComparable(comparable, n);
        Node node = this.lookup(comparable, n);
        return node == null ? null : node.getData(this.oppositeIndex(n));
    }

    private final int oppositeIndex(int n) {
        return 1 - n;
    }

    private final Node lookup(Comparable comparable, int n) {
        Node node = null;
        Node node2 = this.rootNode[n];
        while (node2 != null) {
            int n2 = DoubleOrderedMap.compare(comparable, node2.getData(n));
            if (n2 == 0) {
                node = node2;
                break;
            }
            Node node3 = node2 = n2 < 0 ? node2.getLeft(n) : node2.getRight(n);
        }
        return node;
    }

    private static final int compare(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    private static final Node leastNode(Node node, int n) {
        Node node2 = node;
        if (node2 != null) {
            while (node2.getLeft(n) != null) {
                node2 = node2.getLeft(n);
            }
        }
        return node2;
    }

    private final Node nextGreater(Node node, int n) {
        Node node2 = null;
        if (node == null) {
            node2 = null;
        } else if (node.getRight(n) != null) {
            node2 = DoubleOrderedMap.leastNode(node.getRight(n), n);
        } else {
            Node node3 = node.getParent(n);
            Node node4 = node;
            while (node3 != null && node4 == node3.getRight(n)) {
                node4 = node3;
                node3 = node3.getParent(n);
            }
            node2 = node3;
        }
        return node2;
    }

    private static final void copyColor(Node node, Node node2, int n) {
        if (node2 != null) {
            if (node == null) {
                node2.setBlack(n);
            } else {
                node2.copyColor(node, n);
            }
        }
    }

    private static final boolean isRed(Node node, int n) {
        return node == null ? false : node.isRed(n);
    }

    private static final boolean isBlack(Node node, int n) {
        return node == null ? true : node.isBlack(n);
    }

    private static final void makeRed(Node node, int n) {
        if (node != null) {
            node.setRed(n);
        }
    }

    private static final void makeBlack(Node node, int n) {
        if (node != null) {
            node.setBlack(n);
        }
    }

    private static final Node getGrandParent(Node node, int n) {
        return DoubleOrderedMap.getParent(DoubleOrderedMap.getParent(node, n), n);
    }

    private static final Node getParent(Node node, int n) {
        return node == null ? null : node.getParent(n);
    }

    private static final Node getRightChild(Node node, int n) {
        return node == null ? null : node.getRight(n);
    }

    private static final Node getLeftChild(Node node, int n) {
        return node == null ? null : node.getLeft(n);
    }

    private static final boolean isLeftChild(Node node, int n) {
        return node == null ? true : (node.getParent(n) == null ? false : node == node.getParent(n).getLeft(n));
    }

    private static final boolean isRightChild(Node node, int n) {
        return node == null ? true : (node.getParent(n) == null ? false : node == node.getParent(n).getRight(n));
    }

    private final void rotateLeft(Node node, int n) {
        Node node2 = node.getRight(n);
        node.setRight(node2.getLeft(n), n);
        if (node2.getLeft(n) != null) {
            node2.getLeft(n).setParent(node, n);
        }
        node2.setParent(node.getParent(n), n);
        if (node.getParent(n) == null) {
            this.rootNode[n] = node2;
        } else if (node.getParent(n).getLeft(n) == node) {
            node.getParent(n).setLeft(node2, n);
        } else {
            node.getParent(n).setRight(node2, n);
        }
        node2.setLeft(node, n);
        node.setParent(node2, n);
    }

    private final void rotateRight(Node node, int n) {
        Node node2 = node.getLeft(n);
        node.setLeft(node2.getRight(n), n);
        if (node2.getRight(n) != null) {
            node2.getRight(n).setParent(node, n);
        }
        node2.setParent(node.getParent(n), n);
        if (node.getParent(n) == null) {
            this.rootNode[n] = node2;
        } else if (node.getParent(n).getRight(n) == node) {
            node.getParent(n).setRight(node2, n);
        } else {
            node.getParent(n).setLeft(node2, n);
        }
        node2.setRight(node, n);
        node.setParent(node2, n);
    }

    private final void doRedBlackInsert(Node node, int n) {
        Node node2 = node;
        DoubleOrderedMap.makeRed(node2, n);
        while (node2 != null && node2 != this.rootNode[n] && DoubleOrderedMap.isRed(node2.getParent(n), n)) {
            Node node3;
            if (DoubleOrderedMap.isLeftChild(DoubleOrderedMap.getParent(node2, n), n)) {
                node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getGrandParent(node2, n), n);
                if (DoubleOrderedMap.isRed(node3, n)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                    DoubleOrderedMap.makeBlack(node3, n);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                    node2 = DoubleOrderedMap.getGrandParent(node2, n);
                    continue;
                }
                if (DoubleOrderedMap.isRightChild(node2, n)) {
                    node2 = DoubleOrderedMap.getParent(node2, n);
                    this.rotateLeft(node2, n);
                }
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                if (DoubleOrderedMap.getGrandParent(node2, n) == null) continue;
                this.rotateRight(DoubleOrderedMap.getGrandParent(node2, n), n);
                continue;
            }
            node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getGrandParent(node2, n), n);
            if (DoubleOrderedMap.isRed(node3, n)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeBlack(node3, n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                node2 = DoubleOrderedMap.getGrandParent(node2, n);
                continue;
            }
            if (DoubleOrderedMap.isLeftChild(node2, n)) {
                node2 = DoubleOrderedMap.getParent(node2, n);
                this.rotateRight(node2, n);
            }
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
            DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
            if (DoubleOrderedMap.getGrandParent(node2, n) == null) continue;
            this.rotateLeft(DoubleOrderedMap.getGrandParent(node2, n), n);
        }
        DoubleOrderedMap.makeBlack(this.rootNode[n], n);
    }

    private final void doRedBlackDelete(Node node) {
        int n = 0;
        while (n < 2) {
            Node node2;
            if (node.getLeft(n) != null && node.getRight(n) != null) {
                this.swapPosition(this.nextGreater(node, n), node, n);
            }
            Node node3 = node2 = node.getLeft(n) != null ? node.getLeft(n) : node.getRight(n);
            if (node2 != null) {
                node2.setParent(node.getParent(n), n);
                if (node.getParent(n) == null) {
                    this.rootNode[n] = node2;
                } else if (node == node.getParent(n).getLeft(n)) {
                    node.getParent(n).setLeft(node2, n);
                } else {
                    node.getParent(n).setRight(node2, n);
                }
                node.setLeft(null, n);
                node.setRight(null, n);
                node.setParent(null, n);
                if (DoubleOrderedMap.isBlack(node, n)) {
                    this.doRedBlackDeleteFixup(node2, n);
                }
            } else if (node.getParent(n) == null) {
                this.rootNode[n] = null;
            } else {
                if (DoubleOrderedMap.isBlack(node, n)) {
                    this.doRedBlackDeleteFixup(node, n);
                }
                if (node.getParent(n) != null) {
                    if (node == node.getParent(n).getLeft(n)) {
                        node.getParent(n).setLeft(null, n);
                    } else {
                        node.getParent(n).setRight(null, n);
                    }
                    node.setParent(null, n);
                }
            }
            ++n;
        }
        this.shrink();
    }

    private final void doRedBlackDeleteFixup(Node node, int n) {
        Node node2 = node;
        while (node2 != this.rootNode[n] && DoubleOrderedMap.isBlack(node2, n)) {
            Node node3;
            if (DoubleOrderedMap.isLeftChild(node2, n)) {
                node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                if (DoubleOrderedMap.isRed(node3, n)) {
                    DoubleOrderedMap.makeBlack(node3, n);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node2, n), n);
                    this.rotateLeft(DoubleOrderedMap.getParent(node2, n), n);
                    node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n)) {
                    DoubleOrderedMap.makeRed(node3, n);
                    node2 = DoubleOrderedMap.getParent(node2, n);
                    continue;
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node3, n), n);
                    DoubleOrderedMap.makeRed(node3, n);
                    this.rotateRight(node3, n);
                    node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                }
                DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node2, n), node3, n);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node3, n), n);
                this.rotateLeft(DoubleOrderedMap.getParent(node2, n), n);
                node2 = this.rootNode[n];
                continue;
            }
            node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            if (DoubleOrderedMap.isRed(node3, n)) {
                DoubleOrderedMap.makeBlack(node3, n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node2, n), n);
                this.rotateRight(DoubleOrderedMap.getParent(node2, n), n);
                node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n)) {
                DoubleOrderedMap.makeRed(node3, n);
                node2 = DoubleOrderedMap.getParent(node2, n);
                continue;
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node3, n), n);
                DoubleOrderedMap.makeRed(node3, n);
                this.rotateLeft(node3, n);
                node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            }
            DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node2, n), node3, n);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node3, n), n);
            this.rotateRight(DoubleOrderedMap.getParent(node2, n), n);
            node2 = this.rootNode[n];
        }
        DoubleOrderedMap.makeBlack(node2, n);
    }

    private final void swapPosition(Node node, Node node2, int n) {
        boolean bl;
        Node node3 = node.getParent(n);
        Node node4 = node.getLeft(n);
        Node node5 = node.getRight(n);
        Node node6 = node2.getParent(n);
        Node node7 = node2.getLeft(n);
        Node node8 = node2.getRight(n);
        boolean bl2 = node.getParent(n) != null && node == node.getParent(n).getLeft(n);
        boolean bl3 = bl = node2.getParent(n) != null && node2 == node2.getParent(n).getLeft(n);
        if (node == node6) {
            node.setParent(node2, n);
            if (bl) {
                node2.setLeft(node, n);
                node2.setRight(node5, n);
            } else {
                node2.setRight(node, n);
                node2.setLeft(node4, n);
            }
        } else {
            node.setParent(node6, n);
            if (node6 != null) {
                if (bl) {
                    node6.setLeft(node, n);
                } else {
                    node6.setRight(node, n);
                }
            }
            node2.setLeft(node4, n);
            node2.setRight(node5, n);
        }
        if (node2 == node3) {
            node2.setParent(node, n);
            if (bl2) {
                node.setLeft(node2, n);
                node.setRight(node8, n);
            } else {
                node.setRight(node2, n);
                node.setLeft(node7, n);
            }
        } else {
            node2.setParent(node3, n);
            if (node3 != null) {
                if (bl2) {
                    node3.setLeft(node2, n);
                } else {
                    node3.setRight(node2, n);
                }
            }
            node.setLeft(node7, n);
            node.setRight(node8, n);
        }
        if (node.getLeft(n) != null) {
            node.getLeft(n).setParent(node, n);
        }
        if (node.getRight(n) != null) {
            node.getRight(n).setParent(node, n);
        }
        if (node2.getLeft(n) != null) {
            node2.getLeft(n).setParent(node2, n);
        }
        if (node2.getRight(n) != null) {
            node2.getRight(n).setParent(node2, n);
        }
        node.swapColors(node2, n);
        if (this.rootNode[n] == node) {
            this.rootNode[n] = node2;
        } else if (this.rootNode[n] == node2) {
            this.rootNode[n] = node;
        }
    }

    private static final void checkNonNullComparable(Object object, int n) {
        if (object == null) {
            throw new NullPointerException(dataName[n] + " cannot be null");
        }
        if (!(object instanceof Comparable)) {
            throw new ClassCastException(dataName[n] + " must be Comparable");
        }
    }

    private static final void checkKey(Object object) {
        DoubleOrderedMap.checkNonNullComparable(object, 0);
    }

    private static final void checkValue(Object object) {
        DoubleOrderedMap.checkNonNullComparable(object, 1);
    }

    private static final void checkKeyAndValue(Object object, Object object2) {
        DoubleOrderedMap.checkKey(object);
        DoubleOrderedMap.checkValue(object2);
    }

    private final void modify() {
        ++this.modifications;
    }

    private final void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private final void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private final void insertValue(Node node) throws IllegalArgumentException {
        block4: {
            Node node2 = this.rootNode[1];
            while (true) {
                int n;
                if ((n = DoubleOrderedMap.compare(node.getData(1), node2.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + node.getData(1) + "\") in this Map");
                }
                if (n < 0) {
                    if (node2.getLeft(1) != null) {
                        node2 = node2.getLeft(1);
                        continue;
                    }
                    node2.setLeft(node, 1);
                    node.setParent(node2, 1);
                    this.doRedBlackInsert(node, 1);
                    break block4;
                }
                if (node2.getRight(1) == null) break;
                node2 = node2.getRight(1);
            }
            node2.setRight(node, 1);
            node.setParent(node2, 1);
            this.doRedBlackInsert(node, 1);
        }
    }

    public final int size() {
        return this.nodeCount;
    }

    public final boolean containsKey(Object object) throws ClassCastException, NullPointerException {
        DoubleOrderedMap.checkKey(object);
        return this.lookup((Comparable)object, 0) != null;
    }

    public final boolean containsValue(Object object) {
        DoubleOrderedMap.checkValue(object);
        return this.lookup((Comparable)object, 1) != null;
    }

    public final Object get(Object object) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)object, 0);
    }

    public final Object put(Object object, Object object2) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            DoubleOrderedMap.checkKeyAndValue(object, object2);
            Node node = this.rootNode[0];
            if (node == null) {
                Node node2;
                this.rootNode[0] = node2 = new Node((Comparable)object, (Comparable)object2);
                this.rootNode[1] = node2;
                this.grow();
            } else {
                while (true) {
                    int n;
                    if ((n = DoubleOrderedMap.compare((Comparable)object, node.getData(0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + object + "\") in this Map");
                    }
                    if (n < 0) {
                        if (node.getLeft(0) != null) {
                            node = node.getLeft(0);
                            continue;
                        }
                        Node node3 = new Node((Comparable)object, (Comparable)object2);
                        this.insertValue(node3);
                        node.setLeft(node3, 0);
                        node3.setParent(node, 0);
                        this.doRedBlackInsert(node3, 0);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(0) == null) break;
                    node = node.getRight(0);
                }
                Node node4 = new Node((Comparable)object, (Comparable)object2);
                this.insertValue(node4);
                node.setRight(node4, 0);
                node4.setParent(node, 0);
                this.doRedBlackInsert(node4, 0);
                this.grow();
            }
        }
        return null;
    }

    public final Object remove(Object object) {
        return this.doRemove((Comparable)object, 0);
    }

    public final void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public final Set keySet() {
        if (this.setOfKeys[0] == null) {
            this.setOfKeys[0] = new AbstractSet(this){
                private final /* synthetic */ DoubleOrderedMap this$0;

                public final Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0, this.this$0){
                        private final /* synthetic */ 7 this$0;

                        protected final Object doGetNext() {
                            return Node.access$0(this.lastReturnedNode, 0);
                        }
                        {
                            DoubleOrderedMap doubleOrderedMap2 = doubleOrderedMap;
                            if (doubleOrderedMap2 == null) {
                                throw null;
                            }
                            super(n);
                            this.this$0 = var1_1;
                            this.constructor$0(var1_1, n);
                        }

                        private final void constructor$0(7 var1_1, int n) {
                        }
                    };
                }

                public final int size() {
                    return this.this$0.size();
                }

                public final boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public final boolean remove(Object object) {
                    int n = DoubleOrderedMap.access$4(this.this$0);
                    this.this$0.remove(object);
                    return DoubleOrderedMap.access$4(this.this$0) != n;
                }

                public final void clear() {
                    this.this$0.clear();
                }
                {
                    this.this$0 = doubleOrderedMap;
                    this.constructor$0(doubleOrderedMap);
                }

                private final void constructor$0(DoubleOrderedMap doubleOrderedMap) {
                }
            };
        }
        return this.setOfKeys[0];
    }

    public final Collection values() {
        if (this.collectionOfValues[0] == null) {
            this.collectionOfValues[0] = new AbstractCollection(this){
                private final /* synthetic */ DoubleOrderedMap this$0;

                public final Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0, this.this$0){
                        private final /* synthetic */ 9 this$0;

                        protected final Object doGetNext() {
                            return Node.access$0(this.lastReturnedNode, 1);
                        }
                        {
                            DoubleOrderedMap doubleOrderedMap2 = doubleOrderedMap;
                            if (doubleOrderedMap2 == null) {
                                throw null;
                            }
                            super(n);
                            this.this$0 = var1_1;
                            this.constructor$0(var1_1, n);
                        }

                        private final void constructor$0(9 var1_1, int n) {
                        }
                    };
                }

                public final int size() {
                    return this.this$0.size();
                }

                public final boolean contains(Object object) {
                    return this.this$0.containsValue(object);
                }

                public final boolean remove(Object object) {
                    int n = DoubleOrderedMap.access$4(this.this$0);
                    this.this$0.removeValue(object);
                    return DoubleOrderedMap.access$4(this.this$0) != n;
                }

                public final boolean removeAll(Collection collection) {
                    boolean bl = false;
                    Iterator<E> iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (this.this$0.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public final void clear() {
                    this.this$0.clear();
                }
                {
                    this.this$0 = doubleOrderedMap;
                    this.constructor$0(doubleOrderedMap);
                }

                private final void constructor$0(DoubleOrderedMap doubleOrderedMap) {
                }
            };
        }
        return this.collectionOfValues[0];
    }

    public final Set entrySet() {
        if (this.setOfEntries[0] == null) {
            this.setOfEntries[0] = new AbstractSet(this){
                private final /* synthetic */ DoubleOrderedMap this$0;

                public final Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0, this.this$0){
                        private final /* synthetic */ 11 this$0;

                        protected final Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                        {
                            DoubleOrderedMap doubleOrderedMap2 = doubleOrderedMap;
                            if (doubleOrderedMap2 == null) {
                                throw null;
                            }
                            super(n);
                            this.this$0 = var1_1;
                            this.constructor$0(var1_1, n);
                        }

                        private final void constructor$0(11 var1_1, int n) {
                        }
                    };
                }

                public final boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    V v = entry.getValue();
                    Node node = DoubleOrderedMap.access$1(this.this$0, (Comparable)entry.getKey(), 0);
                    return node != null && Node.access$0(node, 1).equals(v);
                }

                public final boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    V v = entry.getValue();
                    Node node = DoubleOrderedMap.access$1(this.this$0, (Comparable)entry.getKey(), 0);
                    if (node != null && Node.access$0(node, 1).equals(v)) {
                        DoubleOrderedMap.access$3(this.this$0, node);
                        return true;
                    }
                    return false;
                }

                public final int size() {
                    return this.this$0.size();
                }

                public final void clear() {
                    this.this$0.clear();
                }
                {
                    this.this$0 = doubleOrderedMap;
                    this.constructor$0(doubleOrderedMap);
                }

                private final void constructor$0(DoubleOrderedMap doubleOrderedMap) {
                }
            };
        }
        return this.setOfEntries[0];
    }

    static /* synthetic */ int access$0() {
        return VALUE;
    }

    static /* synthetic */ Node access$1(DoubleOrderedMap doubleOrderedMap, Comparable comparable, int n) {
        return doubleOrderedMap.lookup(comparable, n);
    }

    static /* synthetic */ int access$2() {
        return KEY;
    }

    static /* synthetic */ int access$4(DoubleOrderedMap doubleOrderedMap) {
        return doubleOrderedMap.nodeCount;
    }

    public DoubleOrderedMap() {
    }

    public DoubleOrderedMap(Map map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this.putAll(map);
    }

    private abstract class DoubleOrderedMapIterator
    implements Iterator {
        private int expectedModifications;
        protected Node lastReturnedNode;
        private Node nextNode;
        private int iteratorType;

        protected abstract Object doGetNext();

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (DoubleOrderedMap.this.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.nextNode = DoubleOrderedMap.this.nextGreater(this.nextNode, this.iteratorType);
            return this.doGetNext();
        }

        public final void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (DoubleOrderedMap.this.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            DoubleOrderedMap.this.doRedBlackDelete(this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
        }

        DoubleOrderedMapIterator(int n) {
            this.iteratorType = n;
            this.expectedModifications = DoubleOrderedMap.this.modifications;
            this.lastReturnedNode = null;
            this.nextNode = DoubleOrderedMap.leastNode(DoubleOrderedMap.this.rootNode[this.iteratorType], this.iteratorType);
        }
    }

    private static final class Node
    implements Map.Entry {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        private final Comparable getData(int n) {
            return this.data[n];
        }

        private final void setLeft(Node node, int n) {
            this.leftNode[n] = node;
        }

        private final Node getLeft(int n) {
            return this.leftNode[n];
        }

        private final void setRight(Node node, int n) {
            this.rightNode[n] = node;
        }

        private final Node getRight(int n) {
            return this.rightNode[n];
        }

        private final void setParent(Node node, int n) {
            this.parentNode[n] = node;
        }

        private final Node getParent(int n) {
            return this.parentNode[n];
        }

        private final void swapColors(Node node, int n) {
            int n2 = n;
            this.blackColor[n2] = this.blackColor[n2] ^ node.blackColor[n];
            int n3 = n;
            node.blackColor[n3] = node.blackColor[n3] ^ this.blackColor[n];
            int n4 = n;
            this.blackColor[n4] = this.blackColor[n4] ^ node.blackColor[n];
        }

        private final boolean isBlack(int n) {
            return this.blackColor[n];
        }

        private final boolean isRed(int n) {
            return !this.blackColor[n];
        }

        private final void setBlack(int n) {
            this.blackColor[n] = true;
        }

        private final void setRed(int n) {
            this.blackColor[n] = false;
        }

        private final void copyColor(Node node, int n) {
            this.blackColor[n] = node.blackColor[n];
        }

        public final Object getKey() {
            return this.data[0];
        }

        public final Object getValue() {
            return this.data[1];
        }

        public final Object setValue(Object object) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.data[0].equals(entry.getKey()) && this.data[1].equals(entry.getValue());
        }

        public final int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }

        Node(Comparable comparable, Comparable comparable2) {
            this.data = new Comparable[]{comparable, comparable2};
            this.leftNode = new Node[]{null, null};
            this.rightNode = new Node[]{null, null};
            this.parentNode = new Node[]{null, null};
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }
    }
}

