/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import org.apache.avalon.util.internet.LineReader;
import org.apache.avalon.util.internet.LineWriter;

public class InternetStream {
    protected static final int MAX_OUTGOING_LINE_LENGTH = 512;
    protected LineReader m_reader;
    protected LineWriter m_writer;
    protected String m_lastLine;
    protected String m_responseText;
    protected int m_responseCode;
    protected String m_requestVerb;
    protected String m_requestParameter;

    public InternetStream(InputStream inputStream, OutputStream outputStream) {
        this.m_reader = new LineReader(inputStream);
        this.m_writer = new LineWriter(outputStream);
    }

    public String getRequestVerb() {
        return this.m_requestVerb;
    }

    public String getRequestParameter() {
        return this.m_requestParameter;
    }

    public String getResponseText() {
        return this.m_responseText;
    }

    public int getResponseCode() {
        return this.m_responseCode;
    }

    public String getLastLine() {
        return this.m_lastLine;
    }

    public void sendRequest(String string) throws IOException {
        this.sendRequest(string, null);
    }

    public void sendRequest(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (null != string2) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        this.m_writer.println(stringBuffer.toString());
    }

    public void sendResponse(int n, String string) throws IOException {
        int n2 = 0;
        int n3 = string.indexOf(10);
        while (-1 != n3) {
            this.sendResponseLines(n, false, string.substring(n2, n3));
            n2 = n3 + 1;
            n3 = string.indexOf(10, n2);
        }
        n3 = string.length();
        this.sendResponseLines(n, true, string.substring(n2, n3));
    }

    public void receiveRequest() throws IOException {
        this.m_requestVerb = null;
        this.m_requestParameter = null;
        String string = this.m_reader.readln();
        int n = string.indexOf(32);
        if (-1 == n) {
            this.m_requestVerb = string.toUpperCase();
        } else {
            this.m_requestVerb = string.substring(0, n).toUpperCase();
            this.m_requestParameter = string.substring(n + 1).trim();
            if (this.m_requestParameter.equals("")) {
                this.m_requestParameter = null;
            }
        }
    }

    public void receiveResponse() throws IOException {
        boolean bl = false;
        this.m_responseCode = 0;
        this.m_responseText = null;
        while (!bl) {
            String string = this.m_reader.readln();
            int n = Integer.parseInt(string.substring(0, 3));
            if (0 != this.m_responseCode && n != this.m_responseCode) {
                throw new ProtocolException("Badly formed response with differing codes");
            }
            this.m_responseCode = n;
            bl = ' ' == string.charAt(3);
            String string2 = string.substring(4, string.length());
            this.m_responseText = null == this.m_responseText ? string2 : this.m_responseText + '\n' + string2;
        }
    }

    protected void sendResponseLines(int n, boolean bl, String string) throws IOException {
        int n2 = string.length();
        if (n2 < 512) {
            this.sendResponseLine(n, bl, string);
        } else {
            int n3 = 0;
            int n4 = 512;
            while (n4 < n2) {
                this.sendResponseLine(n, false, string.substring(n3, n4));
                n3 = n4 + 1;
                n4 += 512;
            }
            this.sendResponseLine(n, bl, string.substring(n3, n2));
        }
    }

    protected void sendResponseLine(int n, boolean bl, String string) throws IOException {
        char c = bl ? (char)' ' : '-';
        String string2 = Integer.toString(n) + c + string;
        this.sendLine(string2);
    }

    public final void sendLine(String string) throws IOException {
        this.m_writer.println(string);
    }

    public final String receiveLine() throws IOException {
        this.m_lastLine = this.m_reader.readln();
        return this.m_lastLine;
    }
}

