/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.extension;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.excalibur.extension.Extension;
import org.apache.avalon.excalibur.extension.OptionalPackage;
import org.apache.avalon.excalibur.extension.PackageRepository;
import org.apache.avalon.excalibur.extension.UnsatisfiedExtensionException;

public class PackageManager {
    private PackageRepository m_repository;

    public PackageManager(PackageRepository repository) {
        if (null == repository) {
            throw new NullPointerException("repository");
        }
        this.m_repository = repository;
    }

    public OptionalPackage getOptionalPackage(Extension extension) {
        OptionalPackage[] packages = this.m_repository.getOptionalPackages(extension);
        if (null == packages || 0 == packages.length) {
            return null;
        }
        return packages[0];
    }

    public OptionalPackage[] scanDependencies(Extension required, Extension[] available) throws UnsatisfiedExtensionException {
        return this.scanDependencies(required, available);
    }

    public OptionalPackage[] scanDependencies(Extension[] required, Extension[] available) throws UnsatisfiedExtensionException {
        ArrayList dependencies = new ArrayList();
        ArrayList unsatisfied = new ArrayList();
        this.scanDependencies(required, available, dependencies, unsatisfied);
        if (0 != unsatisfied.size()) {
            Extension extension = (Extension)unsatisfied.get(0);
            throw new UnsatisfiedExtensionException(extension);
        }
        return dependencies.toArray(new OptionalPackage[0]);
    }

    public void scanDependencies(Extension[] required, Extension[] available, List dependencies, List unsatisfied) {
        int i = 0;
        while (i < required.length) {
            this.scanDependencies(required[i], available, dependencies, unsatisfied);
            ++i;
        }
    }

    public void scanDependencies(Extension required, Extension[] available, List dependencies, List unsatisfied) {
        OptionalPackage optionalPackage;
        int i = 0;
        while (i < available.length) {
            Extension other = available[i];
            if (other.isCompatibleWith(required)) {
                return;
            }
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            optionalPackage = (OptionalPackage)dependencies.get(i2);
            if (optionalPackage.isCompatible(required)) {
                return;
            }
            ++i2;
        }
        optionalPackage = this.getOptionalPackage(required);
        if (null == optionalPackage) {
            if (!unsatisfied.contains(required)) {
                unsatisfied.add(required);
            }
        } else {
            if (!dependencies.contains(optionalPackage)) {
                dependencies.add(optionalPackage);
            }
            this.scanDependencies(optionalPackage.getRequiredExtensions(), available, dependencies, unsatisfied);
        }
    }
}

