/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler,
ErrorListener {
    public void error(TransformerException transformerException) throws TransformerException {
        this.printLocation(transformerException);
        throw transformerException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printLocation(sAXParseException);
        throw sAXParseException;
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.printLocation(transformerException);
        throw transformerException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printLocation(sAXParseException);
        throw sAXParseException;
    }

    private void printLocation(TransformerException transformerException) {
        SourceLocator sourceLocator = transformerException.getLocator();
        if (sourceLocator != null) {
            String string = sourceLocator.getPublicId() != sourceLocator.getPublicId() ? sourceLocator.getPublicId() : (sourceLocator.getSystemId() != null ? sourceLocator.getSystemId() : "SystemId Unknown");
            System.out.print(String.valueOf(string) + "; Line " + sourceLocator.getLineNumber() + "; Column " + sourceLocator.getColumnNumber() + "; ");
        }
    }

    private void printLocation(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId() != null ? sAXParseException.getSystemId() : "SystemId Unknown";
        System.out.print(String.valueOf(string) + "; Line " + sAXParseException.getLineNumber() + "; Column " + sAXParseException.getColumnNumber() + "; ");
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        this.printLocation(transformerException);
        System.out.println(transformerException.getMessage());
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printLocation(sAXParseException);
        System.out.println("Parser warning: " + sAXParseException.getMessage());
    }
}

