/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.PooledConnection;

public class DefaultConnectionPool
implements ConnectionPool {
    private static final boolean DEBUG = false;
    private String m_driver = new String("");
    private String m_url = new String("");
    private int m_PoolMinSize = 1;
    private Properties m_ConnectionProtocol = new Properties();
    private Vector m_pool = new Vector();
    private boolean m_IsActive = false;

    private void addConnection(PooledConnection pooledConnection) {
        this.m_pool.addElement(pooledConnection);
    }

    private Connection createConnection() throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection(this.m_url, this.m_ConnectionProtocol);
        return connection;
    }

    public void disablePool() {
        this.m_IsActive = false;
        this.freeUnused();
    }

    public void enablePool() {
        this.m_IsActive = true;
    }

    protected void finalize() throws Throwable {
        int n = 0;
        while (n < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (!pooledConnection.inUse()) {
                pooledConnection.close();
            } else {
                try {
                    Thread.sleep(30000L);
                    pooledConnection.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n;
        }
        super.finalize();
    }

    public void freeUnused() {
        int n = 0;
        while (n < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (!pooledConnection.inUse()) {
                pooledConnection.close();
            }
            ++n;
        }
    }

    public synchronized Connection getConnection() throws IllegalArgumentException, SQLException {
        PooledConnection pooledConnection = null;
        if (this.m_pool.size() < this.m_PoolMinSize) {
            this.initializePool();
        }
        int n = 0;
        while (n < this.m_pool.size()) {
            pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (!pooledConnection.inUse()) {
                pooledConnection.setInUse(true);
                return pooledConnection.getConnection();
            }
            ++n;
        }
        Connection connection = this.createConnection();
        pooledConnection = new PooledConnection(connection);
        pooledConnection.setInUse(true);
        this.m_pool.addElement(pooledConnection);
        return pooledConnection.getConnection();
    }

    public boolean hasActiveConnections() {
        return this.m_pool.size() > 0;
    }

    public synchronized void initializePool() throws IllegalArgumentException, SQLException {
        if (this.m_driver == null) {
            throw new IllegalArgumentException("No Driver Name Specified!");
        }
        if (this.m_url == null) {
            throw new IllegalArgumentException("No URL Specified!");
        }
        if (this.m_PoolMinSize < 1) {
            throw new IllegalArgumentException("Pool size is less than 1!");
        }
        try {
            Class.forName(this.m_driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Invalid Driver Name Specified!");
        }
        if (!this.m_IsActive) {
            return;
        }
        do {
            Connection connection;
            if ((connection = this.createConnection()) == null) continue;
            PooledConnection pooledConnection = new PooledConnection(connection);
            this.addConnection(pooledConnection);
        } while (this.m_pool.size() < this.m_PoolMinSize);
    }

    public boolean isEnabled() {
        return this.m_IsActive;
    }

    public synchronized void releaseConnection(Connection connection) throws SQLException {
        int n = 0;
        while (n < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (pooledConnection.getConnection() == connection) {
                if (!this.isEnabled()) {
                    connection.close();
                    this.m_pool.removeElementAt(n);
                    break;
                }
                pooledConnection.setInUse(false);
                break;
            }
            ++n;
        }
    }

    public void setDriver(String string) {
        this.m_driver = string;
    }

    public void setMinConnections(int n) {
        this.m_PoolMinSize = n;
    }

    public void setPassword(String string) {
        ((Hashtable)this.m_ConnectionProtocol).put("password", string);
    }

    public void setProtocol(Properties properties) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Hashtable)this.m_ConnectionProtocol).put(string, properties.getProperty(string));
        }
    }

    public void setURL(String string) {
        this.m_url = string;
    }

    public void setUser(String string) {
        ((Hashtable)this.m_ConnectionProtocol).put("user", string);
    }

    public boolean testConnection() {
        try {
            Connection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            this.releaseConnection(connection);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

