/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.io.test;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.avalon.util.io.FileUtil;
import org.apache.testlet.AbstractTestlet;

public final class FileUtilTestlet
extends AbstractTestlet {
    protected final int FILE1_SIZE = 1;
    protected final int FILE2_SIZE = 4097;
    protected final File m_testDirectory = new File("test/io/").getAbsoluteFile();
    protected final File m_testFile1;
    protected final File m_testFile2;

    public FileUtilTestlet() throws IOException {
        if (!this.m_testDirectory.exists()) {
            this.m_testDirectory.mkdirs();
        }
        this.m_testFile1 = new File(this.m_testDirectory, "file1-test.txt");
        this.m_testFile2 = new File(this.m_testDirectory, "file2-test.txt");
        this.createFile(this.m_testFile1, 1L);
        this.createFile(this.m_testFile2, 4097L);
    }

    protected void createFile(File file, long l) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int n = 0;
        while ((long)n < l) {
            bufferedOutputStream.write(88);
            ++n;
        }
        bufferedOutputStream.close();
    }

    public void testCopyFile1() throws Exception {
        File file = new File(this.m_testDirectory, "copy1.txt");
        FileUtil.copyFile(this.m_testFile1, file);
        this.assert("Check Exist", file.exists());
        this.assert("Check Full copy", file.length() == 1L);
    }

    public void testCopyFile2() throws Exception {
        File file = new File(this.m_testDirectory, "copy2.txt");
        FileUtil.copyFile(this.m_testFile2, file);
        this.assert("Check Exist", file.exists());
        this.assert("Check Full copy", file.length() == 4097L);
    }

    public void testForceDeleteFile1() throws Exception {
        File file = new File(this.m_testDirectory, "copy1.txt");
        FileUtil.forceDelete(file);
        this.assert("Check No Exist", !file.exists());
    }

    public void testForceDeleteFile2() throws Exception {
        File file = new File(this.m_testDirectory, "copy2.txt");
        FileUtil.forceDelete(file);
        this.assert("Check No Exist", !file.exists());
    }

    public void testCopyFile1ToDir() throws Exception {
        File file = new File(this.m_testDirectory, "subdir");
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, "file1-test.txt");
        FileUtil.copyFileToDirectory(this.m_testFile1, file);
        this.assert("Check Exist", file2.exists());
        this.assert("Check Full copy", file2.length() == 1L);
    }

    public void testCopyFile2ToDir() throws Exception {
        File file = new File(this.m_testDirectory, "subdir");
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, "file2-test.txt");
        FileUtil.copyFileToDirectory(this.m_testFile2, file);
        this.assert("Check Exist", file2.exists());
        this.assert("Check Full copy", file2.length() == 4097L);
    }

    public void testForceDeleteDir() throws Exception {
        FileUtil.forceDelete(this.m_testDirectory.getParentFile());
        this.assert("Check No Exist", !this.m_testDirectory.getParentFile().exists());
    }

    public void testResolveFileDotDot() throws Exception {
        File file = FileUtil.resolveFile(this.m_testDirectory, "..");
        this.assertEquality("Check .. operator", file, this.m_testDirectory.getParentFile());
    }

    public void testResolveFileDot() throws Exception {
        File file = FileUtil.resolveFile(this.m_testDirectory, ".");
        this.assertEquality("Check . operator", file, this.m_testDirectory);
    }
}

