/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.AbstractPool;
import org.apache.avalon.excalibur.pool.DefaultObjectFactory;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.excalibur.pool.Resizable;
import org.apache.avalon.framework.activity.Disposable;

public class DefaultPool
extends AbstractPool
implements Disposable {
    protected int m_min;
    protected int m_max;
    protected PoolController m_controller;
    protected boolean m_disposed = false;

    public DefaultPool(ObjectFactory objectFactory, PoolController poolController) throws Exception {
        this(objectFactory, poolController, 8, 8);
    }

    public DefaultPool(ObjectFactory objectFactory, PoolController poolController, int n, int n2) throws Exception {
        super(objectFactory);
        int n3 = n2;
        int n4 = n;
        if (n4 < 0) {
            if (null != this.getLogger()) {
                this.getLogger().warn("Minumum number of poolables specified is less than 0, using 0");
            }
            n4 = 0;
        }
        if (n3 < n4 || n3 < 1) {
            if (null != this.getLogger()) {
                this.getLogger().warn("Maximum number of poolables specified must be at least 1 and must be greater than the minumum number of connections");
            }
            n3 = n4 > 1 ? n4 : 1;
        }
        this.m_max = n3;
        this.m_min = n4;
        this.m_controller = null != poolController ? poolController : new DefaultPoolController(n4 / 2);
    }

    public DefaultPool(ObjectFactory objectFactory) throws Exception {
        this(objectFactory, null, 8, 8);
    }

    public DefaultPool(Class clazz, int n, int n2) throws NoSuchMethodException, Exception {
        this(new DefaultObjectFactory(clazz), null, n, n2);
    }

    public DefaultPool(Class clazz, int n) throws NoSuchMethodException, Exception {
        this(clazz, n, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Poolable get() throws Exception {
        Poolable poolable = null;
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a Poolable before the pool is initialized");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a Poolable after the pool is disposed");
        }
        try {
            this.m_mutex.lock();
            if (this.m_ready.size() == 0) {
                if (this instanceof Resizable) {
                    this.m_mutex.unlock();
                    ((Resizable)((Object)this)).grow(this.m_controller.grow());
                    this.m_mutex.lock();
                    if (this.m_ready.size() <= 0) throw new Exception("Could not create enough Components to service your request.");
                    poolable = (Poolable)this.m_ready.remove(0);
                } else {
                    poolable = this.newPoolable();
                }
            } else {
                poolable = (Poolable)this.m_ready.remove(0);
            }
            this.m_active.add(poolable);
            this.getLogger().debug("Retrieving a " + this.m_factory.getCreatedClass().getName() + " from the pool");
            Poolable poolable2 = poolable;
            Object var4_3 = null;
            this.m_mutex.unlock();
            return poolable2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public final void put(Poolable poolable) {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a Poolable before the pool is initialized");
        }
        try {
            block8: {
                try {
                    this.m_mutex.lock();
                    if (poolable instanceof Recyclable) {
                        ((Recyclable)poolable).recycle();
                    }
                    this.m_active.remove(this.m_active.indexOf(poolable));
                    this.getLogger().debug("Returning a " + this.m_factory.getCreatedClass().getName() + " to the pool");
                    if (!this.m_disposed) {
                        this.m_ready.add(poolable);
                        if (this.size() >= this.m_max && this instanceof Resizable) {
                            this.m_mutex.unlock();
                            ((Resizable)((Object)this)).shrink(this.m_controller.shrink());
                            this.m_mutex.lock();
                        }
                        break block8;
                    }
                    this.removePoolable(poolable);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Pool interrupted while waiting for lock.", (Throwable)exception);
                    Object var4_3 = null;
                    this.m_mutex.unlock();
                }
            }
            Object var4_2 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public final void dispose() throws Exception {
        try {
            this.m_mutex.lock();
            while (this.m_ready.size() > 0) {
                this.removePoolable((Poolable)this.m_ready.remove(0));
            }
            Object var2_1 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }
}

