/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.log.Logger;

public final class JdbcConnection
extends AbstractLoggable
implements Connection,
Recyclable,
Disposable {
    private Connection m_connection;
    private Pool m_pool;
    private PreparedStatement m_test_statement;
    private SQLException m_test_exception;

    public JdbcConnection(Connection connection, boolean bl) {
        this.m_connection = connection;
        try {
            this.m_test_statement = bl ? this.prepareStatement("select 1 from dual") : this.prepareStatement("select 1");
        }
        catch (SQLException sQLException) {
            this.m_test_statement = null;
            this.m_test_exception = sQLException;
        }
    }

    protected void setPool(Pool pool) {
        this.m_pool = pool;
    }

    public final void setLogger(Logger logger) {
        super.setLogger(logger);
        if (this.m_test_statement == null) {
            this.getLogger().warn("Could not prepare test statement", (Throwable)this.m_test_exception);
            this.m_test_exception = null;
        }
    }

    public final Statement createStatement() throws SQLException {
        return this.m_connection.createStatement();
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.m_connection.prepareStatement(string);
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.m_connection.prepareCall(string);
    }

    public final String nativeSQL(String string) throws SQLException {
        return this.m_connection.nativeSQL(string);
    }

    public final void setAutoCommit(boolean bl) throws SQLException {
        this.m_connection.setAutoCommit(bl);
    }

    public final boolean getAutoCommit() throws SQLException {
        return this.m_connection.getAutoCommit();
    }

    public final void commit() throws SQLException {
        this.m_connection.commit();
    }

    public final void rollback() throws SQLException {
        this.m_connection.rollback();
    }

    public final void close() throws SQLException {
        this.clearWarnings();
        this.m_pool.put(this);
    }

    public final void dispose() {
        try {
            this.m_connection.close();
        }
        catch (SQLException sQLException) {
            this.getLogger().warn("Could not close connection", (Throwable)sQLException);
        }
    }

    public final void recycle() {
        this.m_test_exception = null;
    }

    public final boolean isClosed() throws SQLException {
        if (this.m_connection.isClosed()) {
            return true;
        }
        if (this.m_test_statement != null) {
            try {
                this.m_test_statement.executeQuery();
            }
            catch (SQLException sQLException) {
                return true;
            }
        }
        return false;
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.m_connection.getMetaData();
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        this.m_connection.setReadOnly(bl);
    }

    public final boolean isReadOnly() throws SQLException {
        return this.m_connection.isReadOnly();
    }

    public final void setCatalog(String string) throws SQLException {
        this.m_connection.setCatalog(string);
    }

    public final String getCatalog() throws SQLException {
        return this.m_connection.getCatalog();
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        this.m_connection.setTransactionIsolation(n);
    }

    public final int getTransactionIsolation() throws SQLException {
        return this.m_connection.getTransactionIsolation();
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.m_connection.getWarnings();
    }

    public final void clearWarnings() throws SQLException {
        this.m_connection.clearWarnings();
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        return this.m_connection.createStatement(n, n2);
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.m_connection.prepareStatement(string, n, n2);
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.m_connection.prepareCall(string, n, n2);
    }

    public final Map getTypeMap() throws SQLException {
        return this.m_connection.getTypeMap();
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.m_connection.setTypeMap(map);
    }
}

