/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultComponentSelector;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;

public class DefaultComponentManager
extends AbstractLoggable
implements ComponentManager,
Configurable,
Contextualizable,
Disposable {
    private Context m_context;
    private Map m_componentMapping;
    private Map m_componentHandlers = Collections.synchronizedMap(new HashMap());
    private RoleManager m_roles;
    private boolean m_disposed;

    public DefaultComponentManager() {
        this.m_componentMapping = Collections.synchronizedMap(new HashMap());
    }

    public void contextualize(Context context) {
        if (null == this.m_context) {
            this.m_context = context;
        }
    }

    public synchronized void dispose() {
        this.m_disposed = true;
        Iterator<Object> iterator = this.m_componentHandlers.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ComponentHandler componentHandler = (ComponentHandler)((Object)this.m_componentHandlers.get(k));
            try {
                componentHandler.dispose();
            }
            catch (Exception exception) {
                this.getLogger().debug("Caught an exception trying to dispose of the component handler.", (Throwable)exception);
            }
            arrayList.add(k);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.m_componentHandlers.remove(iterator.next());
        }
        arrayList.clear();
    }

    public Component lookup(String string) throws ComponentException {
        Object object;
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot lookup components on a disposed ComponentManager");
        }
        if (null == string) {
            this.getLogger().error("ComponentManager Attempted to retrieve component with null role.");
            throw new ComponentException("ComponentManager Attempted to retrieve component with null role.");
        }
        ComponentHandler componentHandler = (ComponentHandler)((Object)this.m_componentHandlers.get(string));
        if (null == componentHandler) {
            this.getLogger().debug("Could not find ComponentHandler, attempting to create one for role: " + string);
            try {
                object = this.m_roles.getDefaultClassNameForRole(string);
                Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass((String)object);
                DefaultConfiguration defaultConfiguration = new DefaultConfiguration("", "-");
                componentHandler = ComponentHandler.getComponentHandler(clazz, (Configuration)defaultConfiguration, this, this.m_context, this.m_roles);
                componentHandler.setLogger(this.getLogger());
                componentHandler.initialize();
            }
            catch (Exception exception) {
                String string2 = "ComponentManager Could not find component for role: " + string;
                this.getLogger().error(string2, (Throwable)exception);
                throw new ComponentException(string2, (Throwable)exception);
            }
            this.m_componentHandlers.put(string, componentHandler);
        }
        object = null;
        try {
            object = componentHandler.get();
            if (object instanceof DefaultComponentSelector) {
                ((DefaultComponentSelector)((Object)object)).setRoleManager(this.m_roles);
            }
        }
        catch (IllegalStateException illegalStateException) {
            try {
                componentHandler.initialize();
                object = componentHandler.get();
            }
            catch (Exception exception) {
                String string3 = "Could not access the Component for role: " + string;
                this.getLogger().debug(string3, (Throwable)exception);
                throw new ComponentException(string3, (Throwable)exception);
            }
        }
        catch (Exception exception) {
            String string4 = "Could not access the Component for role: " + string;
            this.getLogger().debug(string4, (Throwable)exception);
            throw new ComponentException(string4, (Throwable)exception);
        }
        this.m_componentMapping.put(object, componentHandler);
        return object;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Object object;
        if (null == this.m_roles) {
            object = new DefaultRoleManager();
            object.setLogger(this.getLogger());
            ((DefaultRoleManager)object).configure(configuration);
            this.m_roles = object;
        }
        object = configuration.getChildren();
        int n = 0;
        while (n < ((Configuration[])object).length) {
            String string = object[n].getName();
            if (!string.equals("role")) {
                String string2 = object[n].getAttribute("role", "");
                String string3 = object[n].getAttribute("class", "");
                if (string2.equals("")) {
                    string2 = this.m_roles.getRoleForName(string);
                }
                if (null != string2 && !string2.equals("")) {
                    if (string3.equals("")) {
                        string3 = this.m_roles.getDefaultClassNameForRole(string2);
                    }
                    try {
                        this.getLogger().debug("Adding component (" + string2 + " = " + string3 + ")");
                        Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(string3);
                        this.addComponent(string2, clazz, (Configuration)object[n]);
                    }
                    catch (Exception exception) {
                        String string4 = "Could not get class " + string3 + " for role " + string2 + " on configuration element " + object[n].getName();
                        this.getLogger().error(string4, (Throwable)exception);
                        throw new ConfigurationException(string4, (Throwable)exception);
                    }
                }
            }
            ++n;
        }
    }

    public void setRoleManager(RoleManager roleManager) {
        if (null == this.m_roles) {
            this.m_roles = roleManager;
        }
    }

    public void release(Component component) {
        if (null == component) {
            return;
        }
        ComponentHandler componentHandler = (ComponentHandler)((Object)this.m_componentMapping.get(component));
        if (null != componentHandler) {
            try {
                componentHandler.put(component);
            }
            catch (Exception exception) {
                this.getLogger().debug("Error trying to release component.", (Throwable)exception);
            }
            this.m_componentMapping.remove(component);
        }
    }

    public void addComponent(String string, Class clazz, Configuration configuration) throws ComponentException {
        try {
            this.getLogger().debug("Attempting to get Handler for: " + string);
            ComponentHandler componentHandler = ComponentHandler.getComponentHandler(clazz, configuration, this, this.m_context, this.m_roles);
            this.getLogger().debug("Handler type = " + ((Object)((Object)componentHandler)).getClass().getName());
            componentHandler.setLogger(this.getLogger());
            this.m_componentHandlers.put(string, componentHandler);
        }
        catch (Exception exception) {
            throw new ComponentException("Could not set up Component for role: " + string, (Throwable)exception);
        }
    }

    public void addComponentInstance(String string, Object object) {
        try {
            ComponentHandler componentHandler = ComponentHandler.getComponentHandler((Component)object);
            componentHandler.setLogger(this.getLogger());
            this.m_componentHandlers.put(string, componentHandler);
        }
        catch (Exception exception) {
            this.getLogger().warn("Could not set up Component for role: " + string, (Throwable)exception);
        }
    }
}

