/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.utils.recycle;

import org.apache.avalon.utils.recycle.Controller;
import org.apache.avalon.utils.recycle.Recyclable;

public class GaussianController
implements Controller {
    private static final int WINDOW = 8;
    private static final int BIAS = 1;
    private static final int FACTOR = 3;
    private int level = 0;
    private int[] levels = new int[256];
    private int cursor = 0;

    public void up() {
        this.levels[++this.cursor & 7] = ++this.level;
    }

    public void down() {
        this.levels[++this.cursor & 7] = --this.level;
    }

    public boolean isThereRoomFor(Recyclable object) {
        return this.level < 1 + (int)(3.0f * this.getStandardDeviation(this.levels));
    }

    private float getStandardDeviation(int[] array) {
        float sum = 0.0f;
        float average = this.getAverage(array);
        int i = 0;
        while (i < array.length) {
            sum = (float)((double)sum + Math.pow(Math.abs((float)array[i] - average), 2.0));
            ++i;
        }
        return (float)Math.sqrt(sum / (float)array.length);
    }

    private float getAverage(int[] array) {
        int sum = 0;
        int i = 0;
        while (i < array.length) {
            sum += array[i++];
        }
        return sum / array.length;
    }
}

