/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public final class FileUtil {
    public static void copyFileToDirectory(String source, String destinationDirectory) throws IOException {
        FileUtil.copyFileToDirectory(new File(source), new File(destinationDirectory));
    }

    public static void copyFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtil.copyFile(source, new File(destinationDirectory, source.getName()));
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        if (!destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Unable to open file " + destination + " for writing.");
        }
        FileUtil.copy(new FileInputStream(source), new FileOutputStream(destination));
        if (source.length() != destination.length()) {
            throw new IOException("Failed to copy full contents from " + source + " to " + destination);
        }
    }

    public static void copyURLToFile(URL source, File destination) throws IOException {
        if (!destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Unable to open file " + destination + " for writing.");
        }
        FileUtil.copy(source.openStream(), new FileOutputStream(destination));
    }

    public static void copy(InputStream source, OutputStream destination) throws IOException {
        try {
            int count;
            BufferedInputStream input = new BufferedInputStream(source);
            BufferedOutputStream output = new BufferedOutputStream(destination);
            int BUFFER_SIZE = 4096;
            byte[] buffer = new byte[4096];
            while (-1 != (count = input.read(buffer, 0, 4096))) {
                output.write(buffer, 0, count);
            }
            input.close();
            output.close();
        }
        finally {
            Object var3_8 = null;
            try {
                source.close();
            }
            catch (IOException ioe) {}
            try {
                destination.close();
            }
            catch (IOException ioe) {}
        }
    }

    public static String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        lookupPath = lookupPath.substring(0, index);
        while (path.startsWith("../")) {
            if (lookupPath.length() <= 0) {
                return null;
            }
            index = lookupPath.lastIndexOf("/");
            lookupPath = lookupPath.substring(0, index);
            index = path.indexOf("../") + 3;
            path = path.substring(index);
        }
        return lookupPath + "/" + path;
    }

    public static File resolveFile(File baseFile, String filename) {
        if ('/' != File.separatorChar) {
            filename = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filename = filename.replace('\\', File.separatorChar);
        }
        if (filename.startsWith(File.separator)) {
            File file = new File(filename);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return file;
        }
        int start = 0;
        if ('\\' == File.separatorChar) {
            ++start;
        }
        char[] chars = filename.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < chars.length) {
            boolean doubleSeperator;
            boolean bl = doubleSeperator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (!doubleSeperator) {
                sb.append(chars[i]);
            }
            ++i;
        }
        filename = sb.toString();
        File file = new File(baseFile, filename).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return file;
    }

    public static void forceDelete(String file) throws IOException {
        FileUtil.forceDelete(new File(file));
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else if (!file.delete()) {
            throw new IOException("File " + file + " unable to be deleted.");
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtil.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Directory " + directory + " unable to be deleted.");
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtil.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                FileUtil.cleanDirectory(file);
                if (!file.delete()) {
                    throw new IOException("Directory " + file + " unable to be deleted.");
                }
            }
            ++i;
        }
    }

    private FileUtil() {
    }
}

