/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.template;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import xdoclet.template.PrettyPrintWriter;
import xdoclet.template.TemplateContext;
import xdoclet.template.TemplateException;
import xdoclet.template.TemplateParser;
import xdoclet.template.TemplateTagHandler;
import xdoclet.util.FileManager;
import xdoclet.util.Log;
import xdoclet.util.Translator;

public class TemplateEngine {
    public static final String TAG_MAPPINGS_FILE = "/tagmappings.properties";
    protected static String XDOCLET_PREFIX = "XD";
    protected static String XDOCLET_HEAD = "<" + XDOCLET_PREFIX;
    protected static String XDOCLET_TAIL = "</" + XDOCLET_PREFIX;
    protected static int XDOCLET_HEAD_LEN = XDOCLET_HEAD.length();
    protected static int XDOCLET_TAIL_LEN = XDOCLET_TAIL.length();
    protected transient PrettyPrintWriter out;
    protected transient File output = null;
    private transient URL templateURL = null;
    private transient TemplateContext context = null;
    private transient int currentLineNum = 0;
    private Map tagMappings = new HashMap();
    static /* synthetic */ Class class$xdoclet$template$TemplateEngine;

    public TemplateEngine(TemplateContext context) throws TemplateException {
        Category cat = Log.getCategory(class$xdoclet$template$TemplateEngine == null ? (class$xdoclet$template$TemplateEngine = TemplateEngine.class$("xdoclet.template.TemplateEngine")) : class$xdoclet$template$TemplateEngine, "TemplateEngine");
        try {
            this.context = context;
            Properties tag_handler_mappings = new Properties();
            tag_handler_mappings.load(this.getClass().getResourceAsStream(TAG_MAPPINGS_FILE));
            Iterator tag_handler_mapping_names = ((Hashtable)tag_handler_mappings).keySet().iterator();
            while (tag_handler_mapping_names.hasNext()) {
                String prefix = (String)tag_handler_mapping_names.next();
                String className = (String)((Hashtable)tag_handler_mappings).get(prefix);
                try {
                    TemplateTagHandler tag_handler = (TemplateTagHandler)Class.forName(className).newInstance();
                    tag_handler.setEngine(this);
                    if (this instanceof TemplateParser) {
                        tag_handler.setParser((TemplateParser)this);
                    }
                    tag_handler.setContext(context);
                    this.tagMappings.put(prefix, tag_handler);
                }
                catch (NoClassDefFoundError e) {
                    cat.warn((Object)Translator.getString("template_noclassdeffounderror", new String[]{className, e.getMessage()}));
                }
                catch (ClassNotFoundException e) {
                    cat.warn((Object)Translator.getString("template_classnotfoundexception", new String[]{className, e.getMessage()}));
                }
                catch (InstantiationException e) {
                    cat.warn((Object)Translator.getString("template_instantiationexception", new String[]{className, e.getMessage()}));
                }
                catch (IllegalAccessException e) {
                    cat.warn((Object)Translator.getString("template_illegalaccessexception", new String[]{className, e.getMessage()}));
                }
            }
        }
        catch (IOException ioe) {
            throw new TemplateException(Translator.getString("template_ioexception", new String[]{ioe.getMessage()}));
        }
    }

    public static int skipWhitespace(String template, int i) {
        while (i < template.length() && Character.isWhitespace(template.charAt(i))) {
            ++i;
        }
        return i;
    }

    protected static int getLineNumber(String template, int till_index) {
        int NL_LEN = "\n".length();
        int index = 0;
        int line_num = 0;
        while ((index = template.indexOf("\n", index)) != -1) {
            ++line_num;
            if ((index += NL_LEN) < till_index) continue;
        }
        return line_num;
    }

    public URL getTemplateURL() {
        return this.templateURL;
    }

    public File getOutput() {
        return this.output;
    }

    public int getCurrentLineNum() {
        return this.currentLineNum;
    }

    public TemplateTagHandler getTagHandlerFor(String prefix) throws TemplateException {
        Category cat = Log.getCategory(class$xdoclet$template$TemplateEngine == null ? (class$xdoclet$template$TemplateEngine = TemplateEngine.class$("xdoclet.template.TemplateEngine")) : class$xdoclet$template$TemplateEngine, "getTagHandlerFor");
        TemplateTagHandler tag_handler = (TemplateTagHandler)this.tagMappings.get(prefix);
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("prefix=" + prefix));
            cat.debug((Object)("tag_handler=" + tag_handler));
        }
        if (tag_handler == null) {
            String msg = Translator.getString("template_no_taghandler", new String[]{prefix});
            cat.error((Object)msg);
            throw new TemplateException(msg);
        }
        return tag_handler;
    }

    public void setWriter(PrettyPrintWriter out) {
        this.out = out;
    }

    public void setCurrentLineNum(int currentLineNum) {
        this.currentLineNum = currentLineNum;
    }

    public void setTemplateURL(URL templateURL) {
        this.templateURL = templateURL;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setTagHandlerFor(String prefix, TemplateTagHandler tag_handler) throws TemplateException {
        Category cat = Log.getCategory(class$xdoclet$template$TemplateEngine == null ? (class$xdoclet$template$TemplateEngine = TemplateEngine.class$("xdoclet.template.TemplateEngine")) : class$xdoclet$template$TemplateEngine, "setTagHandlerFor");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("prefix=" + prefix));
            cat.debug((Object)("tag_handler=" + tag_handler));
        }
        tag_handler.setEngine(this);
        if (this instanceof TemplateParser) {
            tag_handler.setParser((TemplateParser)this);
        }
        tag_handler.setContext(this.context);
        this.tagMappings.put(prefix, tag_handler);
    }

    public void generate(String template) throws TemplateException {
        Category cat = Log.getCategory(class$xdoclet$template$TemplateEngine == null ? (class$xdoclet$template$TemplateEngine = TemplateEngine.class$("xdoclet.template.TemplateEngine")) : class$xdoclet$template$TemplateEngine, "generate");
        int index = 0;
        int prev_index = 0;
        boolean i = false;
        while (true) {
            if ((index = template.indexOf(XDOCLET_HEAD, prev_index)) == -1) break;
            this.out.print(template.substring(prev_index, index));
            prev_index = this.handleTag(index, template);
        }
        this.out.print(template.substring(prev_index));
        this.out.flush();
    }

    public String outputOf(String template) throws TemplateException {
        PrettyPrintWriter oldOut = this.out;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.out = new PrettyPrintWriter(bout);
        this.generate(template);
        this.out.close();
        this.out = oldOut;
        return new String(bout.toByteArray());
    }

    public void print(String output) {
        this.out.print(output);
    }

    public void start() throws TemplateException {
        Category cat = Log.getCategory(class$xdoclet$template$TemplateEngine == null ? (class$xdoclet$template$TemplateEngine = TemplateEngine.class$("xdoclet.template.TemplateEngine")) : class$xdoclet$template$TemplateEngine, "start");
        this.output.getParentFile().mkdirs();
        String content = FileManager.getURLContent(this.getTemplateURL());
        if (content != null) {
            cat.debug((Object)("content.length()=" + content.length()));
            try {
                PrettyPrintWriter out = new PrettyPrintWriter(new BufferedWriter(new FileWriter(this.output)));
                this.setWriter(out);
                this.setCurrentLineNum(0);
                this.generate(content);
                out.close();
            }
            catch (IOException ex) {
                String msg = Translator.getString("template_error_writing_output", new String[]{this.output.toString()});
                cat.error((Object)msg, (Throwable)ex);
                throw new TemplateException(ex, msg);
            }
        } else {
            String msg = Translator.getString("template_not_found", new String[]{this.getTemplateURL().toString()});
            cat.error((Object)msg);
            throw new TemplateException(msg);
        }
    }

    protected int handleTag(int index, String template) throws TemplateException {
        int i = index + XDOCLET_HEAD_LEN;
        StringBuffer cmd = new StringBuffer();
        TagContext tagContext = new TagContext();
        Properties attributes = new Properties();
        i = this.extractTagName(template, i, cmd);
        i = this.doInitialTagParse(template, i, tagContext);
        i = this.extractAttributes(tagContext, template, i, attributes);
        if (tagContext.isBlock()) {
            i = this.handleBlockTag(i, template, cmd.toString(), attributes);
        } else {
            this.invokeContentMethod(cmd.toString(), attributes, template, i);
        }
        return i;
    }

    private int extractAttributes(TagContext tagContext, String template, int i, Properties attributes) throws TemplateException {
        while (tagContext.hasMoreAttributes()) {
            i = this.extractNextAttribute(template, i, tagContext, attributes);
        }
        return i;
    }

    private int extractTagName(String template, int index, StringBuffer cmd) {
        while (!Character.isWhitespace(template.charAt(index)) && template.charAt(index) != '>' && template.charAt(index) != '/') {
            cmd.append(template.charAt(index));
            ++index;
        }
        return index;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int extractNextAttribute(String template, int index, TagContext tagContext, Properties attributes) throws TemplateException {
        Category cat = Log.getCategory(class$xdoclet$template$TemplateEngine == null ? (class$xdoclet$template$TemplateEngine = TemplateEngine.class$("xdoclet.template.TemplateEngine")) : class$xdoclet$template$TemplateEngine, "extractNextAttribute");
        String attr_name = "";
        String attr_value = "";
        char quote_char = '\"';
        while (template.charAt(index) != '=' && !Character.isWhitespace(template.charAt(index))) {
            attr_name = attr_name + template.charAt(index);
            ++index;
        }
        if (template.charAt(index = TemplateEngine.skipWhitespace(template, index)) != '=') {
            throw new TemplateException(Translator.getString("template_equals_expected", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
        }
        ++index;
        if (template.charAt(index = TemplateEngine.skipWhitespace(template, index)) == '\"') {
            ++index;
            quote_char = '\"';
        } else {
            if (template.charAt(index) != '\'') {
                throw new TemplateException(Translator.getString("template_quote_expected", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
            }
            ++index;
            quote_char = '\'';
        }
        while (template.charAt(index) != quote_char) {
            attr_value = attr_value + template.charAt(index);
            ++index;
        }
        ++index;
        tagContext.setHasMoreAttributes(true);
        if (attr_value.indexOf(XDOCLET_HEAD) != -1) {
            attr_value = this.outputOf(attr_value);
        }
        if (template.charAt(index = TemplateEngine.skipWhitespace(template, index)) == '>') {
            ++index;
            tagContext.setBlock(true);
            tagContext.setHasMoreAttributes(false);
        } else if (template.charAt(index) == '/') {
            if (template.charAt(++index) != '>') {
                throw new TemplateException(Translator.getString("template_gt_expected", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
            }
            ++index;
            tagContext.setBlock(false);
            tagContext.setHasMoreAttributes(false);
        }
        cat.debug((Object)("Attribute " + attr_name + "=" + attr_value));
        attributes.setProperty(attr_name, attr_value);
        return index;
    }

    private int doInitialTagParse(String template, int index, TagContext tagContext) throws TemplateException {
        while (true) {
            if (template.charAt(index) == '>') {
                tagContext.setHasMoreAttributes(false);
                tagContext.setBlock(true);
                return ++index;
            }
            if (template.charAt(index) == '/') {
                if (template.charAt(++index) == '>') {
                    tagContext.setHasMoreAttributes(false);
                    tagContext.setBlock(false);
                    return ++index;
                }
                throw new TemplateException(Translator.getString("template_gt_expected", new String[]{Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
            }
            if (!Character.isWhitespace(template.charAt(index))) break;
            index = TemplateEngine.skipWhitespace(template, index);
        }
        tagContext.setHasMoreAttributes(true);
        return index;
    }

    private int handleBlockTag(int index, String template, String cmd, Properties attributes) throws TemplateException {
        Category cat = Log.getCategory(class$xdoclet$template$TemplateEngine == null ? (class$xdoclet$template$TemplateEngine = TemplateEngine.class$("xdoclet.template.TemplateEngine")) : class$xdoclet$template$TemplateEngine, "handleBlockTag");
        int open_nested_elem_count = 1;
        String new_body = null;
        int body_start_index = index;
        int body_end_index = -1;
        while (index < template.length()) {
            int from_index = index;
            body_end_index = template.indexOf(XDOCLET_TAIL + cmd, index);
            if (body_end_index == -1) {
                throw new TemplateException(Translator.getString("template_close_tag_missing", new String[]{XDOCLET_TAIL + cmd + ">", Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
            }
            --open_nested_elem_count;
            index = body_end_index + XDOCLET_TAIL_LEN + cmd.length();
            index = TemplateEngine.skipWhitespace(template, index);
            ++index;
            int nested_start_index = template.indexOf(XDOCLET_PREFIX + cmd, from_index);
            while (nested_start_index != -1 && nested_start_index < body_end_index) {
                if (template.charAt(nested_start_index - 1) == '<') {
                    ++open_nested_elem_count;
                } else {
                    throw new TemplateException(Translator.getString("template_corresponding_tag_missing", new String[]{XDOCLET_TAIL + cmd + ">", Integer.toString(TemplateEngine.getLineNumber(template, index)), this.getTemplateURL().toString()}));
                }
                nested_start_index = template.indexOf(XDOCLET_PREFIX + cmd, nested_start_index + 1);
            }
            if (open_nested_elem_count == 0) break;
        }
        new_body = template.substring(body_start_index, body_end_index);
        int prev_line_num = this.currentLineNum;
        int local_body_line_num = TemplateEngine.getLineNumber(template, body_start_index);
        this.currentLineNum += local_body_line_num;
        if (prev_line_num > 0) {
            --this.currentLineNum;
        }
        this.invokeBlockMethod(cmd, new_body, attributes, template, index);
        this.currentLineNum = prev_line_num;
        return index;
    }

    private Object invokeMethod(String cmd, Object[] params1, Object[] params2, String template, int i) throws TemplateException {
        Category cat = Log.getCategory(class$xdoclet$template$TemplateEngine == null ? (class$xdoclet$template$TemplateEngine = TemplateEngine.class$("xdoclet.template.TemplateEngine")) : class$xdoclet$template$TemplateEngine, "invokeMethod");
        int colon = cmd.indexOf(58);
        String prefix = cmd.substring(0, colon);
        String methodName = cmd.substring(colon + 1);
        TemplateTagHandler cmdImplProvider = this.getTagHandlerFor(prefix.substring(1));
        try {
            Class[] param_types = new Class[params1.length];
            int j = 0;
            while (j < params1.length) {
                param_types[j] = params1[j].getClass();
                ++j;
            }
            Method m = cmdImplProvider.getClass().getMethod(methodName, param_types);
            return m.invoke((Object)cmdImplProvider, params1);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof TemplateException) {
                throw (TemplateException)e.getTargetException();
            }
            cat.error((Object)("Invoking method failed: " + methodName + ", line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()), (Throwable)e);
            throw new TemplateException(Translator.getString("template_invoke_method_failed", new String[]{methodName, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString(), e.getMessage()}));
        }
        catch (IllegalAccessException e) {
            cat.error((Object)("Invoking method failed: " + methodName + ", line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()), (Throwable)e);
            throw new TemplateException(Translator.getString("template_invoke_method_failed", new String[]{methodName, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString(), e.getMessage()}));
        }
        catch (NoSuchMethodException e) {
            Class[] param_types = new Class[params2.length];
            try {
                int j = 0;
                while (j < params2.length) {
                    param_types[j] = params2[j].getClass();
                    ++j;
                }
                Method m = cmdImplProvider.getClass().getMethod(methodName, param_types);
                return m.invoke((Object)cmdImplProvider, params2);
            }
            catch (NoSuchMethodException nsme) {
                cat.error((Object)("Could not find method " + methodName + " in class " + cmdImplProvider.getClass().getName()));
                throw new TemplateException(Translator.getString("template_no_such_method", new String[]{methodName, cmdImplProvider.getClass().getName(), nsme.getMessage()}));
            }
            catch (InvocationTargetException e2) {
                if (e2.getTargetException() instanceof TemplateException) {
                    throw (TemplateException)e2.getTargetException();
                }
                cat.error((Object)("Invoking method failed: " + methodName + ", line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()), (Throwable)e2);
                throw new TemplateException(Translator.getString("template_invoke_method_failed", new String[]{methodName, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString(), e2.getMessage()}));
            }
            catch (IllegalAccessException e2) {
                cat.error((Object)("Invoking method failed: " + methodName + ", line=" + TemplateEngine.getLineNumber(template, i) + " of template file: " + this.getTemplateURL()), (Throwable)e2);
                throw new TemplateException(Translator.getString("template_invoke_method_failed", new String[]{methodName, Integer.toString(TemplateEngine.getLineNumber(template, i)), this.getTemplateURL().toString(), e2.getMessage()}));
            }
        }
    }

    private void invokeBlockMethod(String cmd, String block, Properties attributes, String template, int i) throws TemplateException {
        Object[] params1 = null;
        Object[] params2 = null;
        if (((Hashtable)attributes).size() > 0) {
            params1 = new Object[]{block, attributes};
            params2 = new Object[]{block};
        } else {
            params1 = new Object[]{block};
            params2 = new Object[]{block, attributes};
        }
        this.invokeMethod(cmd, params1, params2, template, i);
    }

    private void invokeContentMethod(String cmd, Properties attributes, String template, int i) throws TemplateException {
        Object[] params1 = null;
        Object[] params2 = null;
        if (((Hashtable)attributes).size() > 0) {
            params1 = new Object[]{attributes};
            params2 = new Object[]{};
        } else {
            params1 = new Object[]{};
            params2 = new Object[]{attributes};
        }
        String result = (String)this.invokeMethod(cmd, params1, params2, template, i);
        if (result != null && this.out != null) {
            this.out.print(result);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TagContext {
        private boolean hasMoreAttributes = false;
        private boolean isBlock = false;

        private TagContext() {
        }

        public boolean isBlock() {
            return this.isBlock;
        }

        public void setHasMoreAttributes(boolean attributes) {
            this.hasMoreAttributes = attributes;
        }

        public void setBlock(boolean block) {
            this.isBlock = block;
        }

        public boolean hasMoreAttributes() {
            return this.hasMoreAttributes;
        }
    }
}

