/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.filter;

import org.apache.log.FilterTarget;
import org.apache.log.LogEntry;
import org.apache.log.LogTarget;

public abstract class AbstractFilterTarget
implements FilterTarget {
    protected LogTarget[] m_targets;

    public void addTarget(LogTarget target) {
        if (this.m_targets == null) {
            this.m_targets = new LogTarget[]{target};
        } else {
            LogTarget[] oldTargets = this.m_targets;
            this.m_targets = new LogTarget[oldTargets.length + 1];
            System.arraycopy(oldTargets, 0, this.m_targets, 0, oldTargets.length);
            this.m_targets[this.m_targets.length - 1] = target;
        }
    }

    protected abstract boolean filter(LogEntry var1);

    public void processEntry(LogEntry entry) {
        if (this.m_targets == null || this.filter(entry)) {
            return;
        }
        int i = 0;
        while (i < this.m_targets.length) {
            this.m_targets[i].processEntry(entry);
            ++i;
        }
    }
}

