/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class ExecuteJava {
    private Commandline javaCommand = null;
    private Path classpath = null;
    private CommandlineJava.SysProperties sysProperties = null;
    private PrintStream out;

    public void execute(Project project) throws BuildException {
        PrintStream sErr;
        PrintStream sOut;
        block15: {
            sOut = System.out;
            sErr = System.err;
            String classname = this.javaCommand.getExecutable();
            Object[] argument = new Object[]{this.javaCommand.getArguments()};
            try {
                try {
                    if (this.sysProperties != null) {
                        this.sysProperties.setSystem();
                    }
                    if (this.out != null) {
                        System.setErr(this.out);
                        System.setOut(this.out);
                    }
                    Class[] param = new Class[]{Class.forName("[Ljava.lang.String;")};
                    Class target = null;
                    if (this.classpath == null) {
                        target = Class.forName(classname);
                    } else {
                        AntClassLoader loader = new AntClassLoader(project, this.classpath);
                        target = loader.forceLoadClass(classname);
                    }
                    Method main = target.getMethod("main", param);
                    main.invoke(null, argument);
                }
                catch (NullPointerException nullPointerException) {
                    throw new BuildException("Could not find main() method in " + classname);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new BuildException("Could not find " + classname + ". Make sure you have it in your classpath");
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (!(t instanceof SecurityException)) {
                        throw new BuildException(t);
                    }
                }
                catch (Exception e) {
                    throw new BuildException(e);
                }
                Object var7_12 = null;
                if (this.sysProperties == null) break block15;
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                if (this.sysProperties != null) {
                    this.sysProperties.restoreSystem();
                }
                if (this.out != null) {
                    System.setOut(sOut);
                    System.setErr(sErr);
                    this.out.close();
                }
                throw throwable;
            }
            this.sysProperties.restoreSystem();
        }
        if (this.out != null) {
            System.setOut(sOut);
            System.setErr(sErr);
            this.out.close();
        }
    }

    public void setClasspath(Path p) {
        this.classpath = p;
    }

    public void setJavaCommand(Commandline javaCommand) {
        this.javaCommand = javaCommand;
    }

    public void setOutput(PrintStream out) {
        this.out = out;
    }

    public void setSystemProperties(CommandlineJava.SysProperties s) {
        this.sysProperties = s;
    }
}

