/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Loggable;
import org.apache.avalon.camelot.DefaultLoader;
import org.apache.avalon.camelot.Factory;
import org.apache.avalon.camelot.FactoryException;
import org.apache.avalon.camelot.Loader;
import org.apache.avalon.camelot.Locator;

public class DefaultFactory
extends AbstractLoggable
implements Factory {
    protected final HashMap m_loaders = new HashMap();

    public Object create(Locator locator) throws FactoryException {
        Loader loader = this.getLoaderFor(locator.getLocation());
        try {
            return loader.load(locator.getName());
        }
        catch (Exception e) {
            throw new FactoryException("Unable to create " + locator.getName() + " from " + locator.getLocation(), e);
        }
    }

    public Object create(Locator locator, Class clazz) throws FactoryException {
        Object object = this.create(locator);
        if (!clazz.isInstance(object)) {
            throw new FactoryException("Created object of type " + object.getClass().getName() + " not compatable with type " + clazz.getName());
        }
        return object;
    }

    protected Loader getLoaderFor(URL url) {
        LoaderEntry loader;
        block0: {
            String location = url.toString();
            loader = (LoaderEntry)this.m_loaders.get(location);
            if (loader != null) break block0;
            this.m_logger.info("Creating ClassLoader for " + location);
            loader = new LoaderEntry();
            loader.m_loader = this.setupLoader(url);
            loader.m_lastModified = System.currentTimeMillis();
            this.m_loaders.put(location, loader);
        }
        return loader.m_loader;
    }

    protected Loader setupLoader(URL url) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Loader loader = this.createLoader(url, classLoader);
        if (loader instanceof Loggable) {
            ((Loggable)((Object)loader)).setLogger(this.m_logger);
        }
        return loader;
    }

    protected Loader createLoader(URL url, ClassLoader classLoader) {
        return new DefaultLoader(url, classLoader);
    }

    protected static class LoaderEntry {
        Loader m_loader;
        long m_lastModified;

        LoaderEntry() {
        }
    }
}

