/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.xalan.processor.StopParseException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.StylesheetPIHandler;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.transformer.TrAXFilter;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    public static String XSLT_PROPERTIES = "/org/apache/xalan/res/XSLTInfo.properties";
    private static boolean isInited = false;
    private String m_DOMsystemID = null;
    URIResolver m_uriResolver;
    private ErrorListener m_errorListener = new DefaultErrorHandler();
    static /* synthetic */ Class class$java$lang$Process;

    public TransformerFactoryImpl() {
        TransformerFactoryImpl.loadPropertyFileToSystem(XSLT_PROPERTIES);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        Object object;
        block14: {
            String string4;
            InputSource inputSource = null;
            Node node = null;
            XMLReader xMLReader = null;
            if (source instanceof DOMSource) {
                object = (DOMSource)source;
                node = ((DOMSource)object).getNode();
                string4 = ((DOMSource)object).getSystemId();
            } else {
                inputSource = SAXSource.sourceToInputSource(source);
                string4 = inputSource.getSystemId();
            }
            object = new StylesheetPIHandler(string4, string, string2, string3);
            if (this.m_uriResolver != null) {
                ((StylesheetPIHandler)object).setURIResolver(this.m_uriResolver);
            }
            try {
                if (node != null) {
                    TreeWalker treeWalker = new TreeWalker((ContentHandler)object, new DOM2Helper());
                    treeWalker.traverse(node);
                    break block14;
                }
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
                if (xMLReader == null) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                xMLReader.setContentHandler((ContentHandler)object);
                xMLReader.parse(inputSource);
            }
            catch (StopParseException stopParseException) {
            }
            catch (SAXException sAXException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", sAXException);
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", iOException);
            }
        }
        return ((StylesheetPIHandler)object).getAssociatedStylesheet();
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    String getDOMsystemID() {
        return this.m_DOMsystemID;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public boolean getFeature(String string) {
        if (string == "http://javax.xml.transform.dom.DOMResult/feature" || string == "http://javax.xml.transform.dom.DOMSource/feature" || string == "http://javax.xml.transform.sax.SAXResult/feature" || string == "http://javax.xml.transform.sax.SAXSource/feature" || string == "http://javax.xml.transform.stream.StreamResult/feature" || string == "http://javax.xml.transform.stream.StreamSource/feature" || string == "http://javax.xml.transform.sax.SAXTransformerFactory/feature" || string == "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter") {
            return true;
        }
        return "http://javax.xml.transform.dom.DOMResult/feature".equals(string) || "http://javax.xml.transform.dom.DOMSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXResult/feature".equals(string) || "http://javax.xml.transform.sax.SAXSource/feature".equals(string) || "http://javax.xml.transform.stream.StreamResult/feature".equals(string) || "http://javax.xml.transform.stream.StreamSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter".equals(string);
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    private static void loadPropertyFileToSystem(String string) {
        block5: {
            if (isInited) break block5;
            try {
                try {
                    Properties properties = new Properties();
                    InputStream inputStream = (class$java$lang$Process != null ? class$java$lang$Process : (class$java$lang$Process = TransformerFactoryImpl.class$("java.lang.Process"))).getResourceAsStream(string);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    properties.load(bufferedInputStream);
                    bufferedInputStream.close();
                    Properties properties2 = System.getProperties();
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (((Hashtable)properties2).containsKey(string2)) continue;
                        ((Hashtable)properties2).put(string2, properties.getProperty(string2));
                    }
                    System.setProperties(properties2);
                    isInited = true;
                }
                catch (Exception exception) {
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Object object;
        TemplatesHandler templatesHandler = this.newTemplatesHandler();
        String string = source.getSystemId();
        if (string == null) {
            try {
                object = System.getProperty("user.dir");
                string = "file:///" + (String)object + File.separatorChar + source.getClass().getName();
            }
            catch (SecurityException securityException) {}
        } else {
            try {
                string = SystemIDResolver.getAbsoluteURI(string);
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
        }
        templatesHandler.setSystemId(string);
        if (source instanceof DOMSource) {
            object = (DOMSource)source;
            Node node = ((DOMSource)object).getNode();
            if (node != null) {
                return this.processFromNode(node, string);
            }
            String string2 = XSLMessages.createMessage(108, null);
            throw new IllegalArgumentException(string2);
        }
        try {
            object = SAXSource.sourceToInputSource(source);
            XMLReader xMLReader = null;
            if (source instanceof SAXSource) {
                xMLReader = ((SAXSource)source).getXMLReader();
            }
            if (xMLReader == null) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
            }
            if (xMLReader == null) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            try {
                xMLReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException sAXException) {}
            xMLReader.setContentHandler(templatesHandler);
            xMLReader.parse((InputSource)object);
        }
        catch (SAXException sAXException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(sAXException));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw new TransformerConfigurationException(sAXException.getMessage(), sAXException);
        }
        catch (Exception exception) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(exception));
                    return null;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw new TransformerConfigurationException(exception.getMessage(), exception);
        }
        return templatesHandler.getTemplates();
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new StylesheetHandler(this);
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerIdentityImpl();
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        try {
            Templates templates = this.newTemplates(source);
            if (templates == null) {
                return null;
            }
            return templates.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformerConfigurationException transformerConfigurationException2;
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    transformerConfigurationException2 = new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException2;
        }
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return new TransformerIdentityImpl();
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newTransformerHandler(templates);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        try {
            TransformerImpl transformerImpl = (TransformerImpl)templates.newTransformer();
            TransformerHandler transformerHandler = (TransformerHandler)transformerImpl.getInputContentHandler(true);
            return transformerHandler;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformerConfigurationException transformerConfigurationException2;
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    transformerConfigurationException2 = new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException2;
        }
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException;
        }
    }

    public Templates processFromNode(Node node) throws TransformerConfigurationException {
        try {
            TemplatesHandler templatesHandler = this.newTemplatesHandler();
            TreeWalker treeWalker = new TreeWalker(templatesHandler, new DOM2Helper());
            treeWalker.traverse(node);
            return templatesHandler.getTemplates();
        }
        catch (SAXException sAXException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(sAXException));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
                return null;
            }
            throw new TransformerConfigurationException("processFromNode failed", sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw transformerConfigurationException;
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException.getMessage(), transformerException);
        }
        catch (Exception exception) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(exception));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
                return null;
            }
            throw new TransformerConfigurationException("processFromNode failed", exception);
        }
    }

    Templates processFromNode(Node node, String string) throws TransformerConfigurationException {
        this.m_DOMsystemID = string;
        return this.processFromNode(node);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException("ErrorListener");
        }
        this.m_errorListener = errorListener;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }
}

