/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.tar;

class TarUtils {
    TarUtils() {
    }

    public static int getCheckSumOctalBytes(long value, byte[] buf, int offset, int length) {
        TarUtils.getOctalBytes(value, buf, offset, length);
        buf[offset + length - 1] = 32;
        buf[offset + length - 2] = 0;
        return offset + length;
    }

    public static int getLongOctalBytes(long value, byte[] buf, int offset, int length) {
        byte[] temp = new byte[length + 1];
        TarUtils.getOctalBytes(value, temp, 0, length + 1);
        System.arraycopy(temp, 0, buf, offset, length);
        return offset + length;
    }

    public static int getNameBytes(StringBuffer name, byte[] buffer, int offset, int length) {
        int i = 0;
        while (i < length && i < name.length()) {
            buffer[offset + i] = (byte)name.charAt(i);
            ++i;
        }
        while (i < length) {
            buffer[offset + i] = 0;
            ++i;
        }
        return offset + length;
    }

    public static int getOctalBytes(long value, byte[] buffer, int offset, int length) {
        int idx = length - 1;
        buffer[offset + idx] = 0;
        buffer[offset + --idx] = 32;
        --idx;
        if (value == 0L) {
            buffer[offset + idx] = 48;
            --idx;
        } else {
            long val = value;
            while (idx >= 0 && val > 0L) {
                buffer[offset + idx] = (byte)(48 + (byte)(val & 7L));
                val >>= 3;
                --idx;
            }
        }
        while (idx >= 0) {
            buffer[offset + idx] = 32;
            --idx;
        }
        return offset + length;
    }

    public static long computeCheckSum(byte[] buffer) {
        long sum = 0L;
        int i = 0;
        while (i < buffer.length) {
            sum += (long)(0xFF & buffer[i]);
            ++i;
        }
        return sum;
    }

    public static StringBuffer parseName(byte[] header, int offset, int length) {
        StringBuffer result = new StringBuffer(length);
        int end = offset + length;
        int i = offset;
        while (i < end) {
            if (header[i] == 0) break;
            result.append((char)header[i]);
            ++i;
        }
        return result;
    }

    public static long parseOctal(byte[] header, int offset, int length) {
        long result = 0L;
        boolean stillPadding = true;
        int end = offset + length;
        int i = offset;
        while (i < end) {
            if (header[i] == 0) break;
            if (header[i] == 32 || header[i] == 48) {
                if (!stillPadding) {
                    if (header[i] == 32) break;
                }
            } else {
                stillPadding = false;
                result = (result << 3) + (long)(header[i] - 48);
            }
            ++i;
        }
        return result;
    }
}

