/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultConfigurationBuilder {
    protected static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    protected static final String PARSER = System.getProperty("org.xml.sax.parser", "org.apache.xerces.parsers.SAXParser");
    private SAXConfigurationHandler m_handler = this.getHandler();
    private XMLReader m_parser;

    protected SAXConfigurationHandler getHandler() {
        return new SAXConfigurationHandler();
    }

    public Configuration buildFromFile(String filename) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            Configuration configuration = this.buildFromFile(new File(filename));
            Object var3_4 = null;
            return configuration;
        }
    }

    public Configuration buildFromFile(File file) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            this.m_handler.clear();
            this.m_parser.parse(file.toURL().toString());
            Configuration configuration = this.m_handler.getConfiguration();
            Object var3_4 = null;
            return configuration;
        }
    }

    public Configuration build(InputStream inputStream) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            InputSource inputSource = new InputSource(inputStream);
            Configuration configuration = this.build(inputSource);
            Object var3_5 = null;
            return configuration;
        }
    }

    public Configuration build(String uri) throws SAXException, IOException, ConfigurationException {
        return this.build(new InputSource(uri));
    }

    public Configuration build(InputSource input) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            this.m_handler.clear();
            this.m_parser.parse(input);
            Configuration configuration = this.m_handler.getConfiguration();
            Object var3_4 = null;
            return configuration;
        }
    }

    public DefaultConfigurationBuilder() {
        this(PARSER);
    }

    public DefaultConfigurationBuilder(String parserClass) {
        try {
            this.m_parser = XMLReaderFactory.createXMLReader(parserClass);
            this.m_parser.setContentHandler(this.m_handler);
            this.m_parser.setErrorHandler(this.m_handler);
        }
        catch (SAXException se) {
            throw new Error("Unable to setup SAX parser" + se);
        }
    }
}

