/*
 * Decompiled with CFR 0.152.
 */
package xdoclet;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.loader.ModuleFinder;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.template.TemplateEngine;
import xdoclet.template.TemplateException;
import xdoclet.template.TemplateParser;
import xdoclet.util.LogUtil;
import xjavadoc.ClassIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;

public class GenerationManager {
    private static final File newestJar = ModuleFinder.getNewestFileOnClassPath();
    private static Map parserDb = null;
    private final TemplateSubTask subTask;
    private boolean guessGenerationNeeded = true;
    static /* synthetic */ Class class$xdoclet$GenerationManager;

    public GenerationManager(TemplateSubTask subTask) {
        this.subTask = subTask;
    }

    private static Map getParserDb() {
        if (parserDb == null) {
            parserDb = new HashMap();
        }
        return parserDb;
    }

    private static void updateParserDb(URL templateURL, String[] files) throws XDocletException {
        String[] mergeFiles = (String[])GenerationManager.getParserDb().get(new File(templateURL.getFile()).getName());
        ArrayList<String> complete = new ArrayList<String>(Arrays.asList(files));
        if (mergeFiles != null) {
            int j = 0;
            while (j < mergeFiles.length) {
                String file = mergeFiles[j];
                if (!complete.contains(file)) {
                    complete.add(file);
                }
                ++j;
            }
        }
        GenerationManager.getParserDb().put(new File(templateURL.getFile()).getName(), complete.toArray(new String[complete.size()]));
    }

    public boolean isGuessGenerationNeeded() {
        return this.guessGenerationNeeded;
    }

    public boolean isGenerationNeeded(XClass clazz, File file, boolean withTemplate) throws XDocletException {
        Log log = LogUtil.getLog(class$xdoclet$GenerationManager == null ? (class$xdoclet$GenerationManager = GenerationManager.class$("xdoclet.GenerationManager")) : class$xdoclet$GenerationManager, "generation");
        if (this.subTask.getContext().isForce()) {
            log.debug((Object)"Force generation enabled");
            return true;
        }
        if (!this.isGuessGenerationNeeded()) {
            log.debug((Object)"guessGenerationNeeded enabled");
            return true;
        }
        if (this.isClasspathNewerThanFile(file)) {
            return true;
        }
        if (this.isClassHierarchyNewerThanFile(clazz, file)) {
            return true;
        }
        return this.isTemplateNewerThanFile(withTemplate, file);
    }

    public boolean isGenerationNeeded(File file) throws XDocletException {
        Log log = LogUtil.getLog(class$xdoclet$GenerationManager == null ? (class$xdoclet$GenerationManager = GenerationManager.class$("xdoclet.GenerationManager")) : class$xdoclet$GenerationManager, "generation");
        log.debug((Object)("Generation need check for " + file.getName()));
        if (this.subTask.getContext().isForce()) {
            log.debug((Object)"Force generation enabled");
            return true;
        }
        if (!this.isGuessGenerationNeeded()) {
            log.debug((Object)"guessGenerationNeeded enabled");
            return true;
        }
        if (this.isClasspathNewerThanFile(file)) {
            return true;
        }
        if (this.isGenerationNeeded(file, this.subTask.getTemplateURL())) {
            return true;
        }
        log.debug((Object)("Generation need check for " + file.getName()));
        Collection classes = AbstractProgramElementTagsHandler.getAllClasses();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            if (!this.isGenerationNeeded(i.next(), file, false)) continue;
            return true;
        }
        return false;
    }

    public void setGuessGenerationNeeded(boolean guessGenerationNeeded) {
        this.guessGenerationNeeded = guessGenerationNeeded;
    }

    private boolean isClassHierarchyNewerThanFile(XClass clazz, File file) {
        Log log = LogUtil.getLog(class$xdoclet$GenerationManager == null ? (class$xdoclet$GenerationManager = GenerationManager.class$("xdoclet.GenerationManager")) : class$xdoclet$GenerationManager, "generation");
        while (clazz != null) {
            if (clazz.getQualifiedName().equals("java.lang.Object")) {
                return false;
            }
            if (file.lastModified() < clazz.lastModified()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Generation needed for '" + file.getAbsolutePath() + "' because " + clazz.getQualifiedName() + " is newer (it's in the class hierarchy)"));
                }
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private boolean isTemplateNewerThanFile(boolean withTemplate, File file) throws XDocletException {
        Log log = LogUtil.getLog(class$xdoclet$GenerationManager == null ? (class$xdoclet$GenerationManager = GenerationManager.class$("xdoclet.GenerationManager")) : class$xdoclet$GenerationManager, "generation");
        log.debug((Object)("Checking template. withTemplate=" + withTemplate));
        if (withTemplate && this.isGenerationNeeded(file, this.subTask.getTemplateURL())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generation needed for '" + file.getAbsolutePath() + "' because template file is newer."));
            }
            return true;
        }
        return false;
    }

    private boolean isClasspathNewerThanFile(File file) {
        Log log = LogUtil.getLog(class$xdoclet$GenerationManager == null ? (class$xdoclet$GenerationManager = GenerationManager.class$("xdoclet.GenerationManager")) : class$xdoclet$GenerationManager, "generation");
        if (file.lastModified() < newestJar.lastModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generation needed for '" + file.getAbsolutePath() + "' because " + newestJar.getName() + " is newer."));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No files on classpath are newer than '" + file.getAbsolutePath() + "'"));
        }
        return false;
    }

    private boolean isGenerationNeeded(File file, URL templateURL) throws XDocletException {
        String[] files;
        File templateFile;
        Log log = LogUtil.getLog(class$xdoclet$GenerationManager == null ? (class$xdoclet$GenerationManager = GenerationManager.class$("xdoclet.GenerationManager")) : class$xdoclet$GenerationManager, "xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generation need check for " + file.getAbsolutePath()));
        }
        if ((templateFile = new File(this.subTask.getTemplateURL().getFile())).exists() && file.lastModified() < templateFile.lastModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generation needed for '" + file.getAbsolutePath() + "' because of timestamp of " + this.subTask.getTemplateURL()));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reject file '" + file.getAbsolutePath() + "' because of timestamp of " + this.subTask.getTemplateURL()));
        }
        if (GenerationManager.getParserDb().get(templateFile) == null) {
            TemplateEngine the_engine = this.subTask.getEngine();
            TemplateParser the_parser = TemplateParser.getParserInstance();
            this.subTask.setEngine(the_parser);
            the_parser.setOutput(file);
            the_parser.setTemplateURL(templateURL);
            try {
                the_parser.start();
            }
            catch (TemplateException e) {
                throw new XDocletException(e, e.toString());
            }
            files = the_parser.getMergeFiles();
            if (files != null) {
                GenerationManager.updateParserDb(templateURL, files);
            }
            this.subTask.setEngine(the_engine);
        } else {
            files = (String[])GenerationManager.getParserDb().get(new File(templateURL.getFile()).getName());
            int i = 0;
            while (i < files.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(templateURL.getFile() + " : " + files[i]));
                }
                ++i;
            }
        }
        log.debug((Object)("Number of Merge files involved = " + files.length));
        int i = 0;
        while (i < files.length) {
            String mergeFilePattern = files[i];
            ArrayList<File> mergeFiles = new ArrayList<File>();
            if (mergeFilePattern.indexOf("{0}") != -1) {
                Collection classes = AbstractProgramElementTagsHandler.getAllClasses();
                ClassIterator j = XCollections.classIterator((Collection)classes);
                while (j.hasNext()) {
                    XClass aClass = j.next();
                    String ejbName = MessageFormat.format(mergeFilePattern, AbstractProgramElementTagsHandler.getClassNameFor(aClass));
                    String mergeFileName = PackageTagsHandler.packageNameAsPathFor(aClass.getContainingPackage()) + File.separator + ejbName;
                    if (this.subTask.getMergeDir() == null) continue;
                    mergeFiles.add(new File(this.subTask.getMergeDir(), mergeFileName));
                }
            } else if (this.subTask.getMergeDir() != null) {
                mergeFiles.add(new File(this.subTask.getMergeDir(), mergeFilePattern));
            }
            Iterator iterator = mergeFiles.iterator();
            while (iterator.hasNext()) {
                File mergeFile = (File)iterator.next();
                log.debug((Object)("Generation check for '" + file.getAbsolutePath() + "' because of " + mergeFile.getName()));
                if (!mergeFile.exists()) continue;
                if (file.lastModified() < mergeFile.lastModified()) {
                    log.debug((Object)("Generation needed for '" + file.getAbsolutePath() + "' because of timestamp of " + mergeFile.getName()));
                    return true;
                }
                log.debug((Object)("Reject file '" + file.getAbsolutePath() + "' because of timestamp of " + mergeFile.getName()));
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

