/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class Delete
extends MatchingTask {
    protected File file = null;
    protected File dir = null;
    protected Vector filesets = new Vector();
    protected boolean usedMatchingTask = false;
    protected boolean includeEmpty = false;
    private int verbosity = 3;
    private boolean quiet = false;
    private boolean failonerror = true;

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setVerbose(boolean bl) {
        this.verbosity = bl ? 2 : 3;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
        if (bl) {
            this.failonerror = false;
        }
    }

    public void setFailOnError(boolean bl) {
        this.failonerror = bl;
    }

    public void setIncludeEmptyDirs(boolean bl) {
        this.includeEmpty = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public PatternSet.NameEntry createInclude() {
        this.usedMatchingTask = true;
        return super.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        this.usedMatchingTask = true;
        return super.createExclude();
    }

    public PatternSet createPatternSet() {
        this.usedMatchingTask = true;
        return super.createPatternSet();
    }

    public void setIncludes(String string) {
        this.usedMatchingTask = true;
        super.setIncludes(string);
    }

    public void setExcludes(String string) {
        this.usedMatchingTask = true;
        super.setExcludes(string);
    }

    public void setDefaultexcludes(boolean bl) {
        this.usedMatchingTask = true;
        super.setDefaultexcludes(bl);
    }

    public void setIncludesfile(File file) {
        this.usedMatchingTask = true;
        super.setIncludesfile(file);
    }

    public void setExcludesfile(File file) {
        this.usedMatchingTask = true;
        super.setExcludesfile(file);
    }

    public void execute() throws BuildException {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        if (this.usedMatchingTask) {
            this.log("DEPRECATED - Use of the implicit FileSet is deprecated.  Use a nested fileset element instead.");
        }
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new BuildException("At least one of the file or dir attributes, or a fileset element, must be set.");
        }
        if (this.quiet && this.failonerror) {
            throw new BuildException("quiet and failonerror cannot both be set to true", this.location);
        }
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    this.log("Directory " + this.file.getAbsolutePath() + " cannot be removed using the file attribute.  Use dir instead.");
                } else {
                    this.log("Deleting: " + this.file.getAbsolutePath());
                    if (!this.file.delete()) {
                        String string = "Unable to delete file " + this.file.getAbsolutePath();
                        if (this.failonerror) {
                            throw new BuildException(string);
                        }
                        this.log(string, this.quiet ? 3 : 1);
                    }
                }
            } else {
                this.log("Could not find file " + this.file.getAbsolutePath() + " to delete.", 3);
            }
        }
        if (this.dir != null && this.dir.exists() && this.dir.isDirectory() && !this.usedMatchingTask) {
            if (this.verbosity == 3) {
                this.log("Deleting directory " + this.dir.getAbsolutePath());
            }
            this.removeDir(this.dir);
        }
        int n = 0;
        while (n < this.filesets.size()) {
            object = (FileSet)this.filesets.elementAt(n);
            try {
                stringArray2 = ((FileSet)object).getDirectoryScanner(this.project);
                stringArray = stringArray2.getIncludedFiles();
                String[] stringArray3 = stringArray2.getIncludedDirectories();
                this.removeFiles(((FileSet)object).getDir(this.project), stringArray, stringArray3);
            }
            catch (BuildException buildException) {
                if (this.failonerror) {
                    throw buildException;
                }
                this.log(buildException.getMessage(), this.quiet ? 3 : 1);
            }
            ++n;
        }
        if (this.usedMatchingTask && this.dir != null) {
            try {
                object = super.getDirectoryScanner(this.dir);
                stringArray2 = ((DirectoryScanner)object).getIncludedFiles();
                stringArray = ((DirectoryScanner)object).getIncludedDirectories();
                this.removeFiles(this.dir, stringArray2, stringArray);
            }
            catch (BuildException buildException) {
                if (this.failonerror) {
                    throw buildException;
                }
                this.log(buildException.getMessage(), this.quiet ? 3 : 1);
            }
        }
    }

    protected void removeDir(File file) {
        String string;
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                this.removeDir(file2);
            } else {
                this.log("Deleting " + file2.getAbsolutePath(), this.verbosity);
                if (!file2.delete()) {
                    String string2 = "Unable to delete file " + file2.getAbsolutePath();
                    if (this.failonerror) {
                        throw new BuildException(string2);
                    }
                    this.log(string2, this.quiet ? 3 : 1);
                }
            }
            ++n;
        }
        this.log("Deleting directory " + file.getAbsolutePath(), this.verbosity);
        if (!file.delete()) {
            string = "Unable to delete directory " + this.dir.getAbsolutePath();
            if (this.failonerror) {
                throw new BuildException(string);
            }
            this.log(string, this.quiet ? 3 : 1);
        }
    }

    protected void removeFiles(File file, String[] stringArray, String[] stringArray2) {
        Object object;
        int n;
        if (stringArray.length > 0) {
            this.log("Deleting " + stringArray.length + " files from " + file.getAbsolutePath());
            n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                this.log("Deleting " + file2.getAbsolutePath(), this.verbosity);
                if (!file2.delete()) {
                    object = "Unable to delete file " + file2.getAbsolutePath();
                    if (this.failonerror) {
                        throw new BuildException((String)object);
                    }
                    this.log((String)object, this.quiet ? 3 : 1);
                }
                ++n;
            }
        }
        if (stringArray2.length > 0 && this.includeEmpty) {
            n = 0;
            int n2 = stringArray2.length - 1;
            while (n2 >= 0) {
                object = new File(file, stringArray2[n2]);
                String[] stringArray3 = ((File)object).list();
                if (stringArray3 == null || stringArray3.length == 0) {
                    this.log("Deleting " + ((File)object).getAbsolutePath(), this.verbosity);
                    if (!((File)object).delete()) {
                        String string = "Unable to delete directory " + ((File)object).getAbsolutePath();
                        if (this.failonerror) {
                            throw new BuildException(string);
                        }
                        this.log(string, this.quiet ? 3 : 1);
                    } else {
                        ++n;
                    }
                }
                --n2;
            }
            if (n > 0) {
                this.log("Deleted " + n + " director" + (n == 1 ? "y" : "ies") + " from " + file.getAbsolutePath());
            }
        }
    }
}

