/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class XSLProcessorContext {
    private TransformerImpl transformer;
    private Stylesheet stylesheetTree;
    private Node sourceTree;
    private Node sourceNode;
    private QName mode;

    public XSLProcessorContext(TransformerImpl transformerImpl, Stylesheet stylesheet, Node node, Node node2, QName qName) {
        this.transformer = transformerImpl;
        this.stylesheetTree = stylesheet;
        this.mode = qName;
        this.sourceTree = node;
        this.sourceNode = node2;
    }

    public Node getContextNode() {
        return this.sourceNode;
    }

    public QName getMode() {
        return this.mode;
    }

    public Node getSourceTree() {
        return this.sourceTree;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheetTree;
    }

    public TransformerImpl getTransformer() {
        return this.transformer;
    }

    public void outputToResultTree(Stylesheet stylesheet, Object object) throws TransformerException, MalformedURLException, FileNotFoundException, IOException {
        try {
            ResultTreeHandler resultTreeHandler = this.transformer.getResultTreeHandler();
            XObject xObject = object instanceof XObject ? (XObject)object : (object instanceof String ? new XString((String)object) : (object instanceof Boolean ? new XBoolean((Boolean)object) : (object instanceof Double ? new XNumber((Double)object) : (object instanceof DocumentFragment ? new XRTreeFrag((DocumentFragment)object) : (object instanceof Node ? new XNodeSet((Node)object) : (object instanceof NodeIterator ? new XNodeSet((NodeIterator)object) : new XString(object.toString())))))));
            int n = xObject.getType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    String string = xObject.str();
                    resultTreeHandler.characters(string.toCharArray(), 0, string.length());
                    break;
                }
                case 4: {
                    Node node;
                    NodeIterator nodeIterator = xObject.nodeset();
                    while ((node = nodeIterator.nextNode()) != null) {
                        Node node2 = node;
                        while (node != null) {
                            resultTreeHandler.flushPending();
                            resultTreeHandler.cloneToResultTree(node, true);
                            Node node3 = node.getFirstChild();
                            while (node3 == null) {
                                if (node.getNodeType() == 1) {
                                    resultTreeHandler.endElement("", "", node.getNodeName());
                                }
                                if (node2 == node) break;
                                node3 = node.getNextSibling();
                                if (node3 != null || node2 != (node = node.getParentNode())) continue;
                                if (node.getNodeType() == 1) {
                                    resultTreeHandler.endElement("", "", node.getNodeName());
                                }
                                node3 = null;
                                break;
                            }
                            node = node3;
                        }
                    }
                    break;
                }
                case 5: {
                    resultTreeHandler.outputResultTreeFragment(xObject, this.transformer.getXPathContext());
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }
}

