/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.avalon.excalibur.monitor.ResourceOutputStream;
import org.apache.avalon.excalibur.monitor.ResourceWriter;
import org.apache.avalon.excalibur.monitor.StreamResource;

public class FileResource
extends StreamResource {
    private final File m_file;

    public FileResource(String resource) throws Exception {
        this(new File(resource));
    }

    public FileResource(File resource) throws Exception {
        super(resource.getCanonicalPath());
        this.m_file = resource;
        this.m_previousModified = this.m_file.lastModified();
    }

    public long lastModified() {
        return this.m_file.lastModified();
    }

    public InputStream getResourceAsStream() throws IOException {
        return new FileInputStream(this.m_file);
    }

    public Reader getResourceAsReader() throws IOException {
        return new FileReader(this.m_file);
    }

    public OutputStream setResourceAsStream() throws IOException {
        return new ResourceOutputStream(new FileOutputStream(this.m_file), this);
    }

    public Writer setResourceAsWriter() throws IOException {
        return new ResourceWriter(new FileWriter(this.m_file), this);
    }
}

