/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.RecorderEntry;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class Recorder
extends Task {
    private String filename = null;
    private Boolean append = null;
    private Boolean start = null;
    private int loglevel = -1;
    private static Hashtable recorderEntries = new Hashtable();

    public void setName(String string) {
        this.filename = string;
    }

    public void setAction(ActionChoices actionChoices) {
        this.start = actionChoices.getValue().equalsIgnoreCase("start") ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAppend(boolean bl) {
        this.append = new Boolean(bl);
    }

    public void setLoglevel(VerbosityLevelChoices verbosityLevelChoices) {
        String string = verbosityLevelChoices.getValue();
        if (string.equalsIgnoreCase("error")) {
            this.loglevel = 0;
        } else if (string.equalsIgnoreCase("warn")) {
            this.loglevel = 1;
        } else if (string.equalsIgnoreCase("info")) {
            this.loglevel = 2;
        } else if (string.equalsIgnoreCase("verbose")) {
            this.loglevel = 3;
        } else if (string.equalsIgnoreCase("debug")) {
            this.loglevel = 4;
        }
    }

    public void execute() throws BuildException {
        if (this.filename == null) {
            throw new BuildException("No filename specified");
        }
        this.getProject().log("setting a recorder for name " + this.filename, 4);
        RecorderEntry recorderEntry = this.getRecorder(this.filename, this.getProject());
        recorderEntry.setMessageOutputLevel(this.loglevel);
        recorderEntry.setRecordState(this.start);
    }

    protected RecorderEntry getRecorder(String string, Project project) throws BuildException {
        RecorderEntry recorderEntry;
        Object v = recorderEntries.get(string);
        if (v == null) {
            try {
                recorderEntry = new RecorderEntry(string);
                PrintStream printStream = null;
                printStream = this.append == null ? new PrintStream(new FileOutputStream(string)) : new PrintStream(new FileOutputStream(string, (boolean)this.append));
                recorderEntry.setErrorPrintStream(printStream);
                recorderEntry.setOutputPrintStream(printStream);
            }
            catch (IOException iOException) {
                throw new BuildException("Problems creating a recorder entry", iOException);
            }
            project.addBuildListener(recorderEntry);
            recorderEntries.put(string, recorderEntry);
        } else {
            recorderEntry = (RecorderEntry)v;
        }
        return recorderEntry;
    }

    public static class VerbosityLevelChoices
    extends EnumeratedAttribute {
        private static final String[] values = new String[]{"error", "warn", "info", "verbose", "debug"};

        public String[] getValues() {
            return values;
        }
    }

    public static class ActionChoices
    extends EnumeratedAttribute {
        private static final String[] values = new String[]{"start", "stop"};

        public String[] getValues() {
            return values;
        }
    }
}

