/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.blocks;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;
import org.apache.avalon.DefaultConfigurationBuilder;
import org.apache.avalon.blocks.BlockInfo;
import org.apache.avalon.blocks.DefaultBlockInfo;
import org.apache.avalon.blocks.DefaultDependencyInfo;
import org.apache.avalon.blocks.DefaultServiceInfo;
import org.apache.avalon.blocks.DependencyInfo;
import org.apache.avalon.blocks.MetaInfo;
import org.apache.avalon.blocks.ServiceInfo;
import org.apache.avalon.blocks.Version;

public final class BlockInfoBuilder {
    protected DefaultConfigurationBuilder m_builder = new DefaultConfigurationBuilder();

    public BlockInfo build(InputStream inputStream) throws Exception {
        Configuration info = this.m_builder.build(inputStream);
        Configuration configuration = null;
        try {
            configuration = info.getChild("services");
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        ServiceInfo[] services = this.buildServices(configuration);
        try {
            configuration = info.getChild("dependencies");
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        DependencyInfo[] dependencies = this.buildDependencies(configuration);
        try {
            configuration = info.getChild("meta");
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        MetaInfo metaInfo = this.buildMetaInfo(configuration);
        return new DefaultBlockInfo(metaInfo, services, dependencies);
    }

    protected DependencyInfo[] buildDependencies(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            return new DependencyInfo[0];
        }
        Iterator elements = configuration.getChildren("dependency");
        ArrayList<DependencyInfo> infos = new ArrayList<DependencyInfo>();
        while (elements.hasNext()) {
            DependencyInfo info = this.buildDependency((Configuration)elements.next());
            infos.add(info);
        }
        return infos.toArray(new DependencyInfo[0]);
    }

    protected DependencyInfo buildDependency(Configuration dependency) throws ConfigurationException {
        String role = dependency.getChild("role").getValue();
        ServiceInfo serviceInfo = this.buildService(dependency.getChild("service"));
        return new DefaultDependencyInfo(role, serviceInfo);
    }

    protected ServiceInfo[] buildServices(Configuration servicesSet) throws ConfigurationException {
        if (servicesSet == null) {
            return new ServiceInfo[0];
        }
        Iterator elements = servicesSet.getChildren("service");
        ArrayList<ServiceInfo> infos = new ArrayList<ServiceInfo>();
        while (elements.hasNext()) {
            ServiceInfo info = this.buildService((Configuration)elements.next());
            infos.add(info);
        }
        return infos.toArray(new ServiceInfo[0]);
    }

    protected ServiceInfo buildService(Configuration service) throws ConfigurationException {
        String name = service.getAttribute("name");
        Version version = this.buildVersion(service.getAttribute("version"));
        return new DefaultServiceInfo(name, version);
    }

    protected Version buildVersion(String version) {
        int length = version.length();
        int start = 0;
        int end = version.indexOf(46);
        int major = 1;
        int minor = 0;
        int revision = 0;
        try {
            major = Integer.parseInt(version.substring(start, end));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        start = end + 1;
        end = version.indexOf(46, start);
        if (-1 == end) {
            end = version.length();
        }
        try {
            minor = Integer.parseInt(version.substring(start, end));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (end != length) {
            start = end + 1;
            end = length;
            try {
                revision = Integer.parseInt(version.substring(start, end));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return new Version(major, minor, revision);
    }

    protected MetaInfo buildMetaInfo(Configuration meta) {
        if (meta == null) {
            return null;
        }
        return null;
    }
}

