/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.tasks;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.helper.ProjectHelperImpl2;

public class Import
extends Task {
    String file;

    public void setFile(String file) {
        this.file = file;
    }

    public void execute() throws BuildException {
        String importedFilename;
        if (this.file == null) {
            throw new BuildException("import element appears without a file attribute");
        }
        ProjectHelperImpl2.AntXmlContext context = (ProjectHelperImpl2.AntXmlContext)this.project.getReference("ant.parsing.context");
        this.project.log("importlevel: " + (++ProjectHelperImpl2.AntXmlContext.importlevel - 1) + " -> " + ProjectHelperImpl2.AntXmlContext.importlevel, 4);
        this.project.log("Importing file " + this.file + " from " + context.buildFile.getAbsolutePath(), 3);
        File importedFile = new File(this.file);
        if (!importedFile.isAbsolute()) {
            importedFile = new File(context.buildFileParent, this.file);
        }
        if (!importedFile.exists()) {
            throw new BuildException("Cannot find " + this.file + " imported from " + context.buildFile.getAbsolutePath());
        }
        String parentFilename = Import.getPath(context.buildFile);
        if (!ProjectHelperImpl2.AntXmlContext.importedFiles.containsKey(parentFilename)) {
            ProjectHelperImpl2.AntXmlContext.importedFiles.put(parentFilename, context.buildFile);
        }
        if (ProjectHelperImpl2.AntXmlContext.importedFiles.containsKey(importedFilename = Import.getPath(importedFile))) {
            this.project.log("\nSkipped already imported file:\n   " + importedFilename + '\n', 1);
            return;
        }
        ProjectHelperImpl2.AntXmlContext.importedFiles.put(importedFilename, importedFile);
        context.ignoreProjectTag = true;
        context.helper.parse(this.project, importedFile, new ProjectHelperImpl2.RootHandler(context));
        this.project.log("importlevel: " + --ProjectHelperImpl2.AntXmlContext.importlevel + " <- " + (ProjectHelperImpl2.AntXmlContext.importlevel + 1), 4);
    }

    private static final String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }
}

