/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;

public class Target {
    private String name;
    private String ifCondition = "";
    private String unlessCondition = "";
    private Vector dependencies = new Vector(2);
    private Vector tasks = new Vector(5);
    private Project project;
    private String description = null;

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setDepends(String string) {
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.addDependency(stringTokenizer.nextToken().trim());
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addTask(Task task) {
        this.tasks.addElement(task);
    }

    public Task[] getTasks() {
        Object[] objectArray = new Task[this.tasks.size()];
        this.tasks.copyInto(objectArray);
        return objectArray;
    }

    public void addDependency(String string) {
        this.dependencies.addElement(string);
    }

    public Enumeration getDependencies() {
        return this.dependencies.elements();
    }

    public void setIf(String string) {
        this.ifCondition = string == null ? "" : string;
    }

    public void setUnless(String string) {
        this.unlessCondition = string == null ? "" : string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            Enumeration enumeration = this.tasks.elements();
            while (enumeration.hasMoreElements()) {
                Task task = (Task)enumeration.nextElement();
                try {
                    this.project.fireTaskStarted(task);
                    task.maybeConfigure();
                    task.execute();
                    this.project.fireTaskFinished(task, null);
                }
                catch (RuntimeException runtimeException) {
                    BuildException buildException;
                    if (runtimeException instanceof BuildException && (buildException = (BuildException)runtimeException).getLocation() == Location.UNKNOWN_LOCATION) {
                        buildException.setLocation(task.getLocation());
                    }
                    this.project.fireTaskFinished(task, runtimeException);
                    throw runtimeException;
                }
            }
        } else if (!this.testIfCondition()) {
            this.project.log(this, "Skipped because property '" + this.ifCondition + "' not set.", 3);
        } else {
            this.project.log(this, "Skipped because property '" + this.unlessCondition + "' set.", 3);
        }
    }

    void replaceTask(UnknownElement unknownElement, Task task) {
        int n = -1;
        while ((n = this.tasks.indexOf(unknownElement)) >= 0) {
            this.tasks.setElementAt(task, n);
        }
    }

    private boolean testIfCondition() {
        return "".equals(this.ifCondition) || this.project.getProperty(this.ifCondition) != null;
    }

    private boolean testUnlessCondition() {
        return "".equals(this.unlessCondition) || this.project.getProperty(this.unlessCondition) == null;
    }
}

