/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.i18n;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.avalon.util.i18n.XPathAPI;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.PrefixResolverDefault;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLResourceBundle {
    private Hashtable cacheIS = new Hashtable();
    private Hashtable cacheNO = new Hashtable();
    private Document resource;
    public String bundleName = "";
    protected XMLResourceBundle parent = null;

    public void addToCache(String key, String value) {
        this.cacheIS.put(key, value);
    }

    public Document getResource() {
        return this.resource;
    }

    public String getStringSimple(String xPathKey) {
        String result = "";
        try {
            result = this.getString(xPathKey);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    public String getString(String xPathKey) throws MissingResourceException {
        if (this.cacheIS.containsKey(xPathKey)) {
            return (String)this.cacheIS.get(xPathKey);
        }
        if (this.cacheNO.containsKey(xPathKey)) {
            new MissingResourceException("Unable to locate resource: " + xPathKey, "XMLResourceBundle", xPathKey);
        }
        Element root = this.resource.getDocumentElement();
        try {
            Node node = XPathAPI.selectSingleNode(root, xPathKey);
            if (node != null) {
                String temp = this.getTextNodeAsString(node);
                this.addToCache(xPathKey, temp);
                return temp;
            }
            if (this.parent != null) {
                return this.parent.getString(xPathKey);
            }
            throw new Exception();
        }
        catch (Exception e) {
            this.cacheNO.put(xPathKey, "");
            throw new MissingResourceException("Unable to locate resource: " + xPathKey, "XMLResourceBundle", xPathKey);
        }
    }

    public String getString(Node role, String key) throws MissingResourceException {
        try {
            Node node = XPathAPI.selectSingleNode(role, key);
            if (node != null) {
                return this.getTextNodeAsString(node);
            }
            throw new Exception();
        }
        catch (Exception e) {
            throw new MissingResourceException("Unable to locate resource: " + key, "XMLResourceBundle", key);
        }
    }

    private String getTextNodeAsString(Node node) throws MissingResourceException {
        if ((node = node.getFirstChild()).getNodeType() == 3) {
            return ((TextImpl)node).getData();
        }
        throw new MissingResourceException("Unable to locate XMLResourceBundle", "XMLResourceBundleFactory", "");
    }

    public Node getRole(String xPath) {
        Element root = this.resource.getDocumentElement();
        try {
            Node node = XPathAPI.selectSingleNode(root, xPath);
            if (node != null) {
                return node;
            }
            throw new Exception();
        }
        catch (Exception e) {
            throw new MissingResourceException("Unable to locate resource: " + xPath, "XMLResourceBundle", xPath);
        }
    }

    public Node getRole(Node role, String xPath) {
        try {
            Node node = XPathAPI.selectSingleNode(role, xPath);
            if (node != null) {
                return node;
            }
            throw new Exception();
        }
        catch (Exception e) {
            throw new MissingResourceException("Unable to locate resource: " + xPath, "XMLResourceBundle", xPath);
        }
    }

    public XPath createXPath(String str, Node namespaceNode) throws SAXException {
        XMLParserLiaisonDefault xpathSupport = new XMLParserLiaisonDefault();
        if (namespaceNode == null) {
            throw new SAXException("A namespace node is required to resolve prefixes!");
        }
        PrefixResolverDefault prefixResolver = new PrefixResolverDefault(namespaceNode.getNodeType() == 9 ? ((Document)namespaceNode).getDocumentElement() : namespaceNode);
        XPath xpath = new XPath();
        XPathProcessorImpl parser = new XPathProcessorImpl((XPathSupport)xpathSupport);
        parser.initXPath(xpath, str, (PrefixResolver)prefixResolver);
        return xpath;
    }

    public Locale getLocale() {
        String bundle = this.bundleName.substring(0, this.bundleName.indexOf(".xml"));
        int localeStart = bundle.indexOf("_");
        if (localeStart == -1) {
            return new Locale("", "", "");
        }
        if ((localeStart = (bundle = bundle.substring(localeStart + 1)).indexOf("_")) == -1) {
            return new Locale(bundle, "", "");
        }
        String lang = bundle.substring(0, localeStart);
        if ((localeStart = (bundle = bundle.substring(localeStart + 1)).indexOf("_")) == -1) {
            return new Locale(lang, bundle, "");
        }
        String country = bundle.substring(0, localeStart);
        bundle = bundle.substring(localeStart + 1);
        return new Locale(lang, country, bundle);
    }

    public XMLResourceBundle(Document doc, String name, XMLResourceBundle p) {
        System.out.print("Constructing XMLResourceBundle: " + name);
        if (p != null) {
            System.out.println("  --> parent: " + p.bundleName);
        } else {
            System.out.println("  --> parent: " + p);
        }
        this.resource = doc;
        this.bundleName = name;
        this.parent = p;
    }
}

