/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.log4j.Category;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.tags.PackageTagsHandler;
import xdoclet.template.PrettyPrintWriter;
import xdoclet.util.FileManager;
import xdoclet.util.Log;

public class MergeTagsHandler
extends XDocletTagSupport {
    static /* synthetic */ Class class$xdoclet$tags$MergeTagsHandler;

    public void merge(String template, Properties attributes) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$MergeTagsHandler == null ? (class$xdoclet$tags$MergeTagsHandler = MergeTagsHandler.class$("xdoclet.tags.MergeTagsHandler")) : class$xdoclet$tags$MergeTagsHandler, "merge");
        String merge_file_pattern = attributes.getProperty("file");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("Pattern = " + merge_file_pattern));
        }
        if (merge_file_pattern != null) {
            String contents = this.getMergeFileContents(merge_file_pattern);
            if (contents != null) {
                String generate_merged_file = attributes.getProperty("generateMergedFile");
                if (generate_merged_file != null && !generate_merged_file.equalsIgnoreCase("true") && !generate_merged_file.equalsIgnoreCase("yes")) {
                    this.getEngine().print(contents);
                } else {
                    this.generateUsingMergedFile(merge_file_pattern, contents);
                }
            } else {
                this.generateUsingMergedFile(((TemplateSubTask)XDocletTagSupport.getDocletContext().getActiveSubTask()).getTemplateURL().toString(), template);
            }
        } else {
            cat.error((Object)"<XDtMerge:merge/> file parameter missing from template file, ignoring merge command.");
            this.generate(template);
        }
    }

    protected String getMergeFileContents(String merge_file_pattern) {
        Category cat = Log.getCategory(class$xdoclet$tags$MergeTagsHandler == null ? (class$xdoclet$tags$MergeTagsHandler = MergeTagsHandler.class$("xdoclet.tags.MergeTagsHandler")) : class$xdoclet$tags$MergeTagsHandler, "merge");
        try {
            if (merge_file_pattern.indexOf("{0}") != -1) {
                String ejb_name = MessageFormat.format(merge_file_pattern, AbstractProgramElementTagsHandler.getClassNameFor(XDocletTagSupport.getCurrentClass()));
                String merge_file_name = PackageTagsHandler.packageNameAsPathFor(XDocletTagSupport.getCurrentClass().containingPackage()) + File.separator + ejb_name;
                File merge_file = new File(XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir(), merge_file_name);
                if (cat.isDebugEnabled()) {
                    cat.debug((Object)("Search for File " + merge_file));
                }
                if (merge_file.exists()) {
                    if (cat.isDebugEnabled()) {
                        cat.debug((Object)"Search for File OK");
                    }
                    if (this.getParser() != null) {
                        this.getParser().addMergeFile(merge_file);
                    }
                    return FileManager.getURLContent(merge_file.toURL());
                }
                if (cat.isDebugEnabled()) {
                    cat.debug((Object)"Search for File not OK");
                }
            } else {
                File merge_file = new File(XDocletTagSupport.getDocletContext().getActiveSubTask().getMergeDir(), merge_file_pattern);
                if (merge_file.exists()) {
                    if (this.getParser() != null) {
                        this.getParser().addMergeFile(merge_file);
                    }
                    return FileManager.getURLContent(merge_file.toURL());
                }
            }
            URL jarResource = this.getClass().getResource("/" + merge_file_pattern);
            if (jarResource != null) {
                return FileManager.getURLContent(jarResource);
            }
            return null;
        }
        catch (MalformedURLException e) {
            cat.error((Object)e.getMessage());
            return null;
        }
    }

    protected void generateUsingMergedFile(String merge_file, String contents) throws XDocletException {
        try {
            int line_num = this.getEngine().getCurrentLineNum();
            URL prev_template_url = ((TemplateSubTask)XDocletTagSupport.getDocletContext().getActiveSubTask()).getTemplateURL();
            this.getEngine().setTemplateURL(new File(merge_file).toURL());
            this.getEngine().setCurrentLineNum(0);
            this.generate(contents);
            this.getEngine().setTemplateURL(prev_template_url);
            this.getEngine().setCurrentLineNum(line_num);
        }
        catch (MalformedURLException e) {
            throw new XDocletException(e.getMessage());
        }
    }

    protected void generateFileUsingTemplate(String dest_file, String template_file_name) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$MergeTagsHandler == null ? (class$xdoclet$tags$MergeTagsHandler = MergeTagsHandler.class$("xdoclet.tags.MergeTagsHandler")) : class$xdoclet$tags$MergeTagsHandler, "generateFileUsingTemplate");
        ClassDoc[] classes = this.getContext().getRoot().classes();
        File file = new File(XDocletTagSupport.getDocletContext().getDestDir().toString(), dest_file);
        file.getParentFile().mkdirs();
        try {
            this.getEngine().setTemplateURL(new File(template_file_name).toURL());
            String content = FileManager.getURLContent(((TemplateSubTask)XDocletTagSupport.getDocletContext().getActiveSubTask()).getTemplateURL());
            if (content != null) {
                try {
                    PrettyPrintWriter out = new PrettyPrintWriter(new BufferedWriter(new FileWriter(file)));
                    this.getEngine().setWriter(out);
                    this.getEngine().setCurrentLineNum(0);
                    this.generate(content);
                    out.close();
                }
                catch (IOException ex) {
                    cat.error((Object)("An error occured while writing output to file " + file), (Throwable)ex);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new XDocletException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

