/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.thread;

import org.apache.avalon.Loggable;
import org.apache.avalon.Poolable;
import org.apache.avalon.util.pool.ObjectFactory;
import org.apache.avalon.util.pool.ThreadSafePool;
import org.apache.avalon.util.thread.WorkerThread;
import org.apache.log.Logger;

public class ThreadPool
extends ThreadGroup
implements ObjectFactory,
Loggable {
    protected final ThreadSafePool m_pool = new ThreadSafePool((ObjectFactory)this, 0);
    protected int m_level;
    protected Logger m_logger;
    static /* synthetic */ Class class$org$apache$avalon$util$thread$WorkerThread;

    public ThreadPool(int n) throws Exception {
        this("Worker Pool", n);
    }

    public ThreadPool(String string, int n) throws Exception {
        super(string);
        this.m_pool.init();
        this.m_pool.grow(n);
    }

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    public Poolable newInstance() {
        WorkerThread workerThread = new WorkerThread(this, this.m_pool, this.getName() + " Worker #" + this.m_level++);
        workerThread.setLogger(this.m_logger);
        workerThread.start();
        return workerThread;
    }

    public Class getCreatedClass() {
        return class$org$apache$avalon$util$thread$WorkerThread == null ? (class$org$apache$avalon$util$thread$WorkerThread = ThreadPool.class$("org.apache.avalon.util.thread.WorkerThread")) : class$org$apache$avalon$util$thread$WorkerThread;
    }

    public void execute(Runnable runnable) throws Exception {
        this.execute(runnable, 5);
    }

    public void execute(Runnable runnable, int n) throws Exception {
        WorkerThread workerThread = this.getWorker(n);
        workerThread.execute(runnable);
    }

    public void executeAndWait(Runnable runnable) throws Exception {
        this.executeAndWait(runnable, 5);
    }

    public void executeAndWait(Runnable runnable, int n) throws Exception {
        WorkerThread workerThread = this.getWorker(n);
        workerThread.executeAndWait(runnable);
    }

    protected WorkerThread getWorker(int n) throws Exception {
        WorkerThread workerThread = (WorkerThread)this.m_pool.get();
        workerThread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        workerThread.setPriority(n);
        return workerThread;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

