/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import org.apache.avalon.excalibur.monitor.FileResource;
import org.apache.avalon.excalibur.monitor.Monitorable;
import org.apache.avalon.excalibur.monitor.Resource;
import org.apache.avalon.excalibur.monitor.SourceResource;
import org.apache.avalon.excalibur.source.ModifiableSource;
import org.apache.avalon.excalibur.source.SourceParameters;
import org.apache.avalon.excalibur.source.SourceUtil;
import org.apache.avalon.excalibur.source.SourceValidity;
import org.apache.avalon.excalibur.source.validity.TimeStampValidity;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.excalibur.xml.XMLizable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class URLSource
implements ModifiableSource,
XMLizable,
Monitorable {
    private final String FILE = "file:";
    private long lastModificationDate;
    private long contentLength;
    private String systemId;
    private URL url;
    private URLConnection connection;
    private boolean isFile;
    private boolean gotInfos;
    private ComponentManager manager;
    private static boolean checkedURLClass = false;
    private static boolean urlSupportsGetUserInfo = false;
    private static Method urlGetUserInfo = null;
    private static Object[] emptyParams = new Object[0];
    static /* synthetic */ Class class$java$net$URL;

    public URLSource(URL url, SourceParameters parameters) throws IOException {
        this.systemId = url.toExternalForm();
        this.isFile = this.systemId.startsWith("file:");
        this.url = url;
        this.gotInfos = false;
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    private void getInfos() {
        if (!this.gotInfos) {
            if (this.isFile) {
                File file = new File(this.systemId.substring("file:".length()));
                this.lastModificationDate = file.lastModified();
                this.contentLength = file.length();
            } else {
                try {
                    if (this.connection == null) {
                        this.connection = this.url.openConnection();
                        String userInfo = this.getUserInfo();
                        if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                            this.connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
                        }
                    }
                    this.lastModificationDate = this.connection.getLastModified();
                    this.contentLength = this.connection.getContentLength();
                }
                catch (IOException ignore) {
                    this.lastModificationDate = 0L;
                    this.contentLength = -1L;
                }
            }
            this.gotInfos = true;
        }
    }

    public long getLastModified() {
        this.getInfos();
        return this.lastModificationDate;
    }

    public Resource getResource() throws Exception {
        this.getInfos();
        if (this.isFile) {
            return new FileResource(this.systemId.substring("file:".length()));
        }
        return new SourceResource(this);
    }

    public long getContentLength() {
        this.getInfos();
        return this.contentLength;
    }

    public InputStream getInputStream() throws IOException {
        this.getInfos();
        InputStream input = null;
        if (this.isFile) {
            input = new FileInputStream(this.systemId.substring("file:".length()));
        } else {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
                String userInfo = this.getUserInfo();
                if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                    this.connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
                }
            }
            input = this.connection.getInputStream();
            this.connection = null;
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    private String getUserInfo() {
        if (checkedURLClass) {
            if (urlSupportsGetUserInfo) {
                try {
                    return (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        try {
            void e;
            urlGetUserInfo = (class$java$net$URL == null ? (class$java$net$URL = URLSource.class$("java.net.URL")) : class$java$net$URL).getMethod("getUserInfo", null);
            String ui = (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
            checkedURLClass = true;
            urlSupportsGetUserInfo = true;
            return e;
        }
        catch (Exception exception) {
            checkedURLClass = true;
            urlSupportsGetUserInfo = false;
            urlGetUserInfo = null;
            return null;
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm == -1L) {
            return null;
        }
        return new TimeStampValidity(lm);
    }

    public void refresh() {
        this.connection = null;
        this.gotInfos = false;
    }

    public InputSource getInputSource() throws IOException {
        InputSource newObject = new InputSource(this.getInputStream());
        newObject.setSystemId(this.systemId);
        return newObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ContentHandler handler) throws SAXException {
        Parser parser = null;
        try {
            try {
                parser = (Parser)this.manager.lookup("org.apache.avalon.excalibur.xml.Parser");
                parser.parse(this.getInputSource(), handler);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException("Exception during processing of " + this.systemId, e);
            }
            Object var6_3 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (parser == null) throw throwable;
            this.manager.release((Component)parser);
            throw throwable;
        }
        this.manager.release((Component)parser);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

