/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Available
extends Task {
    private String property;
    private String classname;
    private File file;
    private String resource;
    private Path classpath;
    private AntClassLoader loader;
    private String value = "true";

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setClassname(String classname) {
        if (!"".equals(classname)) {
            this.classname = classname;
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute is required", this.location);
        }
        if (this.classname == null && this.file == null && this.resource == null) {
            throw new BuildException("At least one of (classname|file|resource) is required", this.location);
        }
        if (this.classpath != null) {
            this.loader = new AntClassLoader(this.project, this.classpath, false);
        }
        if (this.classname != null && !this.checkClass(this.classname)) {
            return;
        }
        if (this.file != null && !this.checkFile(this.file)) {
            return;
        }
        if (this.resource != null && !this.checkResource(this.resource)) {
            return;
        }
        this.project.setProperty(this.property, this.value);
    }

    private boolean checkFile(File file) {
        return file.exists();
    }

    private boolean checkResource(String resource) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(resource) != null;
        }
        return this.getClass().getResourceAsStream(resource) != null;
    }

    private boolean checkClass(String classname) {
        try {
            if (this.loader != null) {
                this.loader.loadClass(classname);
            } else {
                ClassLoader l = this.getClass().getClassLoader();
                if (l != null) {
                    l.loadClass(classname);
                } else {
                    Class.forName(classname);
                }
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            this.log(e.toString(), 3);
            return false;
        }
    }
}

