/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ejb.vendor;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import xdoclet.XDocletException;
import xdoclet.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.ejb.tags.vendor.StrutsFormTagsHandler;
import xdoclet.tags.PackageTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Translator;

public class StrutsFormSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String SUBTASK_NAME = "strutsForm";
    protected static String DEFAULT_TEMPLATE_FILE = "/xdoclet/ejb/vendor/struts_form.j";
    protected String formClassPattern;
    protected Tag currentFormTag;

    public StrutsFormSubTask() {
        this.setTemplateURL(this.getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getStrutsFormClassPattern() + ".java");
        this.setOfType("javax.ejb.EntityBean");
    }

    public Tag getCurrentFormTag() {
        return this.currentFormTag;
    }

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public String getStrutsFormClassPattern() {
        if (this.formClassPattern != null) {
            return this.formClassPattern;
        }
        return "{0}{1}Form";
    }

    public void setCurrentFormTag(Tag t) {
        this.currentFormTag = t;
    }

    public void setPattern(String new_pattern) {
        this.formClassPattern = new_pattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getStrutsFormClassPattern() == null || this.getStrutsFormClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString("parameter_missing_or_empty", new String[]{"pattern"}));
        }
        if (this.getStrutsFormClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString("xdoclet.ejb.Messages", "pattern_has_no_placeholder"));
        }
        if (this.getStrutsFormClassPattern().indexOf("{1}") == -1) {
            throw new XDocletException(Translator.getString("xdoclet.ejb.vendor.StrutsMessages", "pattern_has_no_form_placeholder"));
        }
    }

    protected String getGeneratedFileName(ClassDoc clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor(StrutsFormTagsHandler.getStrutsFormClassFor(this.getCurrentClass())) + ".java";
    }

    protected boolean matchesGenerationRules(ClassDoc clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        return StrutsFormTagsHandler.hasFormDefinition(this.getCurrentClass());
    }

    protected void generateForClass(ClassDoc clazz) throws XDocletException {
        Tag[] formTags = DocletUtil.getTagsByName(clazz, "struts:form", false);
        System.out.println(Translator.getString("xdoclet.ejb.vendor.StrutsMessages", "generating_forms_for", new String[]{this.getCurrentClass().qualifiedName()}));
        int i = 0;
        while (i < formTags.length) {
            this.setCurrentFormTag(formTags[i]);
            super.generateForClass(clazz);
            ++i;
        }
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString("xdoclet.ejb.vendor.StrutsMessages", "generating_file", new String[]{StrutsFormTagsHandler.getStrutsFormClassName(this.getCurrentClass())}));
    }
}

