/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;

public class JikesOutputParser
implements ExecuteStreamHandler {
    protected Task task;
    protected boolean errorFlag = false;
    protected int errors;
    protected int warnings;
    protected boolean error = false;
    protected boolean emacsMode;
    protected BufferedReader br;

    public void setProcessInputStream(OutputStream outputStream) {
    }

    public void setProcessErrorStream(InputStream inputStream) {
    }

    public void setProcessOutputStream(InputStream inputStream) throws IOException {
        this.br = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void start() throws IOException {
        this.parseOutput(this.br);
    }

    public void stop() {
    }

    protected JikesOutputParser(Task task, boolean bl) {
        this.task = task;
        this.emacsMode = bl;
    }

    protected void parseOutput(BufferedReader bufferedReader) throws IOException {
        if (this.emacsMode) {
            this.parseEmacsOutput(bufferedReader);
        } else {
            this.parseStandardOutput(bufferedReader);
        }
    }

    private void parseStandardOutput(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            String string2 = string.toLowerCase();
            if (string.trim().equals("")) continue;
            if (string2.indexOf("error") != -1) {
                this.setError(true);
            } else if (string2.indexOf("warning") != -1) {
                this.setError(false);
            } else if (this.emacsMode) {
                this.setError(true);
            }
            this.log(string);
        }
    }

    private void parseEmacsOutput(BufferedReader bufferedReader) throws IOException {
        this.parseStandardOutput(bufferedReader);
    }

    private void setError(boolean bl) {
        this.error = bl;
        if (this.error) {
            this.errorFlag = true;
        }
    }

    private void log(String string) {
        if (!this.emacsMode) {
            this.task.log("", this.error ? 0 : 1);
        }
        this.task.log(string, this.error ? 0 : 1);
    }

    protected boolean getErrorFlag() {
        return this.errorFlag;
    }
}

