/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class ExecuteOn
extends ExecTask {
    protected Vector filesets = new Vector();
    private boolean parallel = false;
    protected String type = "file";
    protected Commandline.Marker srcFilePos = null;
    private boolean skipEmpty = false;

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void setParallel(boolean bl) {
        this.parallel = bl;
    }

    public void setType(FileDirBoth fileDirBoth) {
        this.type = fileDirBoth.getValue();
    }

    public void setSkipEmptyFilesets(boolean bl) {
        this.skipEmpty = bl;
    }

    public Commandline.Marker createSrcfile() {
        if (this.srcFilePos != null) {
            throw new BuildException(this.taskType + " doesn't support multiple srcfile elements.", this.location);
        }
        this.srcFilePos = this.cmdl.createMarker();
        return this.srcFilePos;
    }

    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.filesets.size() == 0) {
            throw new BuildException("no filesets specified", this.location);
        }
    }

    protected void runExec(Execute execute) throws BuildException {
        try {
            try {
                int n = 0;
                while (n < this.filesets.size()) {
                    int n2;
                    Object[] objectArray;
                    Vector<Object> vector = new Vector<Object>();
                    FileSet fileSet = (FileSet)this.filesets.elementAt(n);
                    File file = fileSet.getDir(this.project);
                    DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
                    if (!"dir".equals(this.type)) {
                        objectArray = this.getFiles(file, directoryScanner);
                        n2 = 0;
                        while (n2 < objectArray.length) {
                            vector.addElement(objectArray[n2]);
                            ++n2;
                        }
                    }
                    if (!"file".equals(this.type)) {
                        objectArray = this.getDirs(file, directoryScanner);
                        n2 = 0;
                        while (n2 < objectArray.length) {
                            vector.addElement(objectArray[n2]);
                            ++n2;
                        }
                    }
                    if (vector.size() == 0 && this.skipEmpty) {
                        this.log("Skipping fileset for directory " + file + ". It is empty.", 2);
                    } else {
                        objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                        n2 = -1;
                        if (this.parallel) {
                            String[] stringArray = this.getCommandline((String[])objectArray, file);
                            this.log("Executing " + Commandline.toString(stringArray), 3);
                            execute.setCommandline(stringArray);
                            this.runExecute(execute);
                        } else {
                            int n3 = 0;
                            while (n3 < objectArray.length) {
                                String[] stringArray = this.getCommandline((String)objectArray[n3], file);
                                this.log("Executing " + Commandline.toString(stringArray), 3);
                                execute.setCommandline(stringArray);
                                this.runExecute(execute);
                                ++n3;
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Execute failed: " + iOException, iOException, this.location);
            }
            Object var12_13 = null;
            this.logFlush();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.logFlush();
            throw throwable;
        }
    }

    protected String[] getCommandline(String[] stringArray, File file) {
        String[] stringArray2 = this.cmdl.getCommandline();
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        int n = stringArray2.length;
        if (this.srcFilePos != null) {
            n = this.srcFilePos.getPosition();
        }
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray3[n + n2] = new File(file, stringArray[n2]).getAbsolutePath();
            ++n2;
        }
        System.arraycopy(stringArray2, n, stringArray3, n + stringArray.length, stringArray2.length - n);
        return stringArray3;
    }

    protected String[] getCommandline(String string, File file) {
        return this.getCommandline(new String[]{string}, file);
    }

    protected String[] getFiles(File file, DirectoryScanner directoryScanner) {
        return directoryScanner.getIncludedFiles();
    }

    protected String[] getDirs(File file, DirectoryScanner directoryScanner) {
        return directoryScanner.getIncludedDirectories();
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"file", "dir", "both"};
        }
    }
}

