/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;

public class Project {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    private static String javaVersion;
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String TOKEN_START = "@";
    public static final String TOKEN_END = "@";
    private String name;
    private Hashtable properties = new Hashtable();
    private Hashtable userProperties = new Hashtable();
    private Hashtable references = new Hashtable();
    private String defaultTarget;
    private Hashtable dataClassDefinitions = new Hashtable();
    private Hashtable taskClassDefinitions = new Hashtable();
    private Hashtable targets = new Hashtable();
    private Hashtable filters = new Hashtable();
    private File baseDir;
    private Vector listeners = new Vector();
    private static Method setLastModified;
    private static Object lockReflection;
    static /* synthetic */ Class class$java$io$File;

    public void init() throws BuildException {
        Object object;
        String string;
        Object object2;
        Enumeration enumeration;
        Object object3;
        Object object4;
        this.setJavaVersionProperty();
        String string2 = "/org/apache/tools/ant/taskdefs/defaults.properties";
        try {
            object4 = new Properties();
            object3 = this.getClass().getResourceAsStream(string2);
            if (object3 == null) {
                throw new BuildException("Can't load default task list");
            }
            ((Properties)object4).load((InputStream)object3);
            ((InputStream)object3).close();
            enumeration = ((Properties)object4).propertyNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                string = ((Properties)object4).getProperty((String)object2);
                try {
                    object = Class.forName(string);
                    this.addTaskDefinition((String)object2, (Class)object);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Can't load default task list");
        }
        object4 = "/org/apache/tools/ant/types/defaults.properties";
        try {
            object3 = new Properties();
            enumeration = this.getClass().getResourceAsStream((String)object4);
            if (enumeration == null) {
                throw new BuildException("Can't load default datatype list");
            }
            ((Properties)object3).load((InputStream)((Object)enumeration));
            ((InputStream)((Object)enumeration)).close();
            object2 = ((Properties)object3).propertyNames();
            while (object2.hasMoreElements()) {
                string = (String)object2.nextElement();
                object = ((Properties)object3).getProperty(string);
                try {
                    Class<?> clazz = Class.forName((String)object);
                    this.addDataTypeDefinition(string, clazz);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Can't load default datatype list");
        }
        object3 = System.getProperties();
        enumeration = ((Hashtable)object3).keys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            string = ((Hashtable)object3).get(object2).toString();
            this.setProperty(object2.toString(), string);
        }
    }

    public void addBuildListener(BuildListener buildListener) {
        this.listeners.addElement(buildListener);
    }

    public void removeBuildListener(BuildListener buildListener) {
        this.listeners.removeElement(buildListener);
    }

    public Vector getBuildListeners() {
        return this.listeners;
    }

    public void log(String string) {
        this.log(string, 2);
    }

    public void log(String string, int n) {
        this.fireMessageLogged(this, string, n);
    }

    public void log(Task task, String string, int n) {
        this.fireMessageLogged(task, string, n);
    }

    public void log(Target target, String string, int n) {
        this.fireMessageLogged(target, string, n);
    }

    public void setProperty(String string, String string2) {
        if (null != this.userProperties.get(string)) {
            return;
        }
        this.log("Setting project property: " + string + " -> " + string2, 4);
        this.properties.put(string, string2);
    }

    public void setUserProperty(String string, String string2) {
        this.log("Setting ro project property: " + string + " -> " + string2, 4);
        this.userProperties.put(string, string2);
        this.properties.put(string, string2);
    }

    public String getProperty(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.properties.get(string);
        return string2;
    }

    public String getUserProperty(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.userProperties.get(string);
        return string2;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public Hashtable getUserProperties() {
        return this.userProperties;
    }

    public void setDefaultTarget(String string) {
        this.defaultTarget = string;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefault(String string) {
        this.defaultTarget = string;
    }

    public void setName(String string) {
        this.setUserProperty("ant.project.name", string);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addFilter(String string, String string2) {
        if (string == null) {
            return;
        }
        this.log("Setting token to filter: " + string + " -> " + string2, 4);
        this.filters.put(string, string2);
    }

    public Hashtable getFilters() {
        return this.filters;
    }

    public void setBasedir(String string) throws BuildException {
        try {
            this.setBaseDir(new File(new File(string).getCanonicalPath()));
        }
        catch (IOException iOException) {
            String string2 = "Can't set basedir " + string + " due to " + iOException.getMessage();
            throw new BuildException(string2);
        }
    }

    public void setBaseDir(File file) {
        this.baseDir = file;
        this.setProperty("basedir", file.getAbsolutePath());
        String string = "Project base dir set to: " + file;
        this.log(string, 3);
    }

    public File getBaseDir() {
        if (this.baseDir == null) {
            try {
                this.setBasedir(".");
            }
            catch (BuildException buildException) {
                buildException.printStackTrace();
            }
        }
        return this.baseDir;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public void setJavaVersionProperty() {
        this.setProperty("ant.java.version", javaVersion);
        if (javaVersion == JAVA_1_0) {
            throw new BuildException("Ant cannot work on Java 1.0");
        }
        this.log("Detected Java version: " + javaVersion + " in: " + System.getProperty("java.home"), 3);
        this.log("Detected OS: " + System.getProperty("os.name"), 3);
    }

    public void addTaskDefinition(String string, Class clazz) {
        String string2 = " +User task: " + string + "     " + clazz.getName();
        this.log(string2, 4);
        this.taskClassDefinitions.put(string, clazz);
    }

    public Hashtable getTaskDefinitions() {
        return this.taskClassDefinitions;
    }

    public void addDataTypeDefinition(String string, Class clazz) {
        String string2 = " +User datatype: " + string + "     " + clazz.getName();
        this.log(string2, 4);
        this.dataClassDefinitions.put(string, clazz);
    }

    public Hashtable getDataTypeDefinitions() {
        return this.dataClassDefinitions;
    }

    public void addTarget(Target target) {
        String string = target.getName();
        if (this.targets.get(string) != null) {
            throw new BuildException("Duplicate target: `" + string + "'");
        }
        this.addOrReplaceTarget(string, target);
    }

    public void addTarget(String string, Target target) throws BuildException {
        if (this.targets.get(string) != null) {
            throw new BuildException("Duplicate target: `" + string + "'");
        }
        this.addOrReplaceTarget(string, target);
    }

    public void addOrReplaceTarget(Target target) {
        this.addOrReplaceTarget(target.getName(), target);
    }

    public void addOrReplaceTarget(String string, Target target) {
        String string2 = " +Target: " + string;
        this.log(string2, 4);
        target.setProject(this);
        this.targets.put(string, target);
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Task createTask(String string) throws BuildException {
        Class clazz = (Class)this.taskClassDefinitions.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            Object object;
            Object t = clazz.newInstance();
            Task task = null;
            if (t instanceof Task) {
                task = (Task)t;
            } else {
                object = new TaskAdapter();
                ((TaskAdapter)object).setProxy(t);
                task = object;
            }
            task.setProject(this);
            task.setTaskType(string);
            task.setTaskName(string);
            object = "   +Task: " + string;
            this.log((String)object, 4);
            return task;
        }
        catch (Throwable throwable) {
            String string2 = "Could not create task of type: " + string + " due to " + throwable;
            throw new BuildException(string2, throwable);
        }
    }

    public Object createDataType(String string) throws BuildException {
        Class clazz = (Class)this.dataClassDefinitions.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            Constructor constructor = null;
            boolean bl = false;
            try {
                constructor = clazz.getConstructor(new Class[0]);
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = clazz.getConstructor(this.getClass());
                bl = false;
            }
            Object var5_9 = null;
            var5_9 = bl ? constructor.newInstance(new Object[0]) : constructor.newInstance(this);
            String string2 = "   +DataType: " + string;
            this.log(string2, 4);
            return var5_9;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string3 = "Could not create datatype of type: " + string + " due to " + throwable;
            throw new BuildException(string3, throwable);
        }
        catch (Throwable throwable) {
            String string4 = "Could not create datatype of type: " + string + " due to " + throwable;
            throw new BuildException(string4, throwable);
        }
    }

    public void executeTargets(Vector vector) throws BuildException {
        Object var2_2 = null;
        int n = 0;
        while (n < vector.size()) {
            this.executeTarget((String)vector.elementAt(n));
            ++n;
        }
    }

    public void executeTarget(String string) throws BuildException {
        Target target;
        if (string == null) {
            String string2 = "No target specified";
            throw new BuildException(string2);
        }
        Vector vector = this.topoSort(string, this.targets);
        int n = 0;
        do {
            target = (Target)vector.elementAt(n++);
            this.runTarget(target);
        } while (!target.getName().equals(string));
    }

    public File resolveFile(String string, File file) {
        if ((string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(File.separator)) {
            try {
                return new File(new File(string).getCanonicalPath());
            }
            catch (IOException iOException) {
                this.log("IOException getting canonical path for " + string + ": " + iOException.getMessage(), 0);
                return new File(string);
            }
        }
        if (string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            char[] cArray = string.replace('/', '\\').toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] != '\\' || cArray[n] == '\\' && n > 0 && cArray[n - 1] != '\\') {
                    char c = n == 0 && Character.isLetter(cArray[n]) && n < cArray.length - 1 && cArray[n + 1] == ':' ? Character.toUpperCase(cArray[n]) : cArray[n];
                    stringBuffer.append(c);
                }
                ++n;
            }
            return new File(stringBuffer.toString());
        }
        File file2 = new File(file.getAbsolutePath());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("..")) {
                String string3 = file2.getParent();
                if (string3 == null) {
                    throw new BuildException("The file or path you specified (" + string + ") is invalid releative to " + file.getAbsolutePath());
                }
                file2 = new File(string3);
                continue;
            }
            if (string2.equals(".")) continue;
            file2 = new File(file2, string2);
        }
        try {
            return new File(file2.getCanonicalPath());
        }
        catch (IOException iOException) {
            this.log("IOException getting canonical path for " + file2 + ": " + iOException.getMessage(), 0);
            return new File(file2.getAbsolutePath());
        }
    }

    public File resolveFile(String string) {
        return this.resolveFile(string, this.baseDir);
    }

    public static String translatePath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        while (pathTokenizer.hasMoreTokens()) {
            String string2 = pathTokenizer.nextToken();
            string2 = string2.replace('/', File.separatorChar);
            string2 = string2.replace('\\', File.separatorChar);
            if (stringBuffer.length() != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void copyFile(String string, String string2) throws IOException {
        this.copyFile(new File(string), new File(string2), false);
    }

    public void copyFile(String string, String string2, boolean bl) throws IOException {
        this.copyFile(new File(string), new File(string2), bl);
    }

    public void copyFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        this.copyFile(new File(string), new File(string2), bl, bl2);
    }

    public void copyFile(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.copyFile(new File(string), new File(string2), bl, bl2, bl3);
    }

    public void copyFile(File file, File file2) throws IOException {
        this.copyFile(file, file2, false);
    }

    public void copyFile(File file, File file2, boolean bl) throws IOException {
        this.copyFile(file, file2, bl, false);
    }

    public void copyFile(File file, File file2, boolean bl, boolean bl2) throws IOException {
        this.copyFile(file, file2, bl, bl2, false);
    }

    public void copyFile(File file, File file2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (bl2 || file2.lastModified() < file.lastModified()) {
            this.log("Copy: " + file.getAbsolutePath() + " -> " + file2.getAbsolutePath(), 3);
            File file3 = new File(file2.getParent());
            if (!file3.exists()) {
                file3.mkdirs();
            }
            if (bl) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                String string = null;
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.length() == 0) {
                        bufferedWriter.newLine();
                    } else {
                        string = this.replace(string2, this.filters);
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                    string2 = bufferedReader.readLine();
                }
                bufferedWriter.close();
                bufferedReader.close();
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    fileOutputStream.write(byArray, 0, n);
                } while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1);
                fileInputStream.close();
                fileOutputStream.close();
            }
            if (bl3) {
                this.setFileLastModified(file2, file.lastModified());
            }
        }
    }

    public void setFileLastModified(File file, long l) throws BuildException {
        Object[] objectArray;
        if (Project.getJavaVersion() == JAVA_1_1) {
            this.log("Cannot change the modification time of " + file + " in JDK 1.1", 1);
            return;
        }
        if (setLastModified == null) {
            objectArray = lockReflection;
            synchronized (objectArray) {
                if (setLastModified == null) {
                    try {
                        setLastModified = (class$java$io$File == null ? (class$java$io$File = Project.class$("java.io.File")) : class$java$io$File).getMethod("setLastModified", Long.TYPE);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new BuildException("File.setlastModified not in JDK > 1.1?", noSuchMethodException);
                    }
                }
            }
        }
        objectArray = new Long[]{l < 0L ? new Long(System.currentTimeMillis()) : new Long(l)};
        try {
            this.log("Setting modification time for " + file, 3);
            setLastModified.invoke((Object)file, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new BuildException("Exception setting the modification time of " + file, throwable);
        }
        catch (Throwable throwable) {
            throw new BuildException("Exception setting the modification time of " + file, throwable);
        }
    }

    private String replace(String string, Hashtable hashtable) {
        int n = string.indexOf("@");
        if (n > -1) {
            try {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                String string2 = null;
                String string3 = null;
                while ((n2 = string.indexOf("@", n + "@".length() + 1)) != -1) {
                    string2 = string.substring(n + "@".length(), n2);
                    stringBuffer.append(string.substring(n3, n));
                    if (hashtable.containsKey(string2)) {
                        string3 = (String)hashtable.get(string2);
                        this.log("Replacing: @" + string2 + "@" + " -> " + string3, 3);
                        stringBuffer.append(string3);
                        n3 = n + "@".length() + string2.length() + "@".length();
                    } else {
                        stringBuffer.append("@");
                        n3 = n + "@".length();
                    }
                    if ((n = string.indexOf("@", n3)) > -1) continue;
                }
                stringBuffer.append(string.substring(n3));
                return stringBuffer.toString();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return string;
            }
        }
        return string;
    }

    public static boolean toBoolean(String string) {
        return string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public void runTarget(Target target) throws BuildException {
        try {
            this.fireTargetStarted(target);
            target.execute();
            this.fireTargetFinished(target, null);
        }
        catch (RuntimeException runtimeException) {
            this.fireTargetFinished(target, runtimeException);
            throw runtimeException;
        }
    }

    public final Vector topoSort(String string, Hashtable hashtable) throws BuildException {
        Vector vector = new Vector();
        Hashtable hashtable2 = new Hashtable();
        Stack stack = new Stack();
        this.tsort(string, hashtable, hashtable2, stack, vector);
        this.log("Build sequence for target `" + string + "' is " + vector, 3);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable2.get(string2);
            if (string3 == null) {
                this.tsort(string2, hashtable, hashtable2, stack, vector);
                continue;
            }
            if (string3 != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + string2);
        }
        this.log("Complete build sequence is " + vector, 3);
        return vector;
    }

    private final void tsort(String string, Hashtable hashtable, Hashtable hashtable2, Stack stack, Vector vector) throws BuildException {
        String string2;
        hashtable2.put(string, VISITING);
        stack.push(string);
        Target target = (Target)hashtable.get(string);
        if (target == null) {
            StringBuffer stringBuffer = new StringBuffer("Target `");
            stringBuffer.append(string);
            stringBuffer.append("' does not exist in this project. ");
            stack.pop();
            if (!stack.empty()) {
                String string3 = (String)stack.peek();
                stringBuffer.append("It is used from target `");
                stringBuffer.append(string3);
                stringBuffer.append("'.");
            }
            throw new BuildException(new String(stringBuffer));
        }
        Enumeration enumeration = target.getDependencies();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            String string4 = (String)hashtable2.get(string2);
            if (string4 == null) {
                this.tsort(string2, hashtable, hashtable2, stack, vector);
                continue;
            }
            if (string4 != VISITING) continue;
            throw Project.makeCircularException(string2, stack);
        }
        string2 = (String)stack.pop();
        if (string != string2) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + string + " but got " + string2);
        }
        hashtable2.put(string, VISITED);
        vector.addElement(target);
    }

    private static BuildException makeCircularException(String string, Stack stack) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("Circular dependency: ");
        stringBuffer.append(string);
        do {
            string2 = (String)stack.pop();
            stringBuffer.append(" <- ");
            stringBuffer.append(string2);
        } while (!string2.equals(string));
        return new BuildException(new String(stringBuffer));
    }

    public void addReference(String string, Object object) {
        this.references.put(string, object);
    }

    public Hashtable getReferences() {
        return this.references;
    }

    protected void fireBuildStarted() {
        BuildEvent buildEvent = new BuildEvent(this);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.buildStarted(buildEvent);
            ++n;
        }
    }

    protected void fireBuildFinished(Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(this);
        buildEvent.setException(throwable);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.buildFinished(buildEvent);
            ++n;
        }
    }

    protected void fireTargetStarted(Target target) {
        BuildEvent buildEvent = new BuildEvent(target);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.targetStarted(buildEvent);
            ++n;
        }
    }

    protected void fireTargetFinished(Target target, Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(target);
        buildEvent.setException(throwable);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.targetFinished(buildEvent);
            ++n;
        }
    }

    protected void fireTaskStarted(Task task) {
        BuildEvent buildEvent = new BuildEvent(task);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.taskStarted(buildEvent);
            ++n;
        }
    }

    protected void fireTaskFinished(Task task, Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(task);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.taskFinished(buildEvent);
            ++n;
        }
    }

    private void fireMessageLoggedEvent(BuildEvent buildEvent, String string, int n) {
        buildEvent.setMessage(string, n);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n2);
            buildListener.messageLogged(buildEvent);
            ++n2;
        }
    }

    protected void fireMessageLogged(Project project, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(project);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    protected void fireMessageLogged(Target target, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(target);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    protected void fireMessageLogged(Task task, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(task);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        setLastModified = null;
        lockReflection = new Object();
        try {
            javaVersion = JAVA_1_0;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            Class.forName("java.lang.ThreadLocal");
            javaVersion = JAVA_1_2;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
            Class.forName("java.lang.CharSequence");
            javaVersion = JAVA_1_4;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

