/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ejb.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import java.text.MessageFormat;
import xdoclet.DocletContext;
import xdoclet.DocletSupport;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.ejb.EntityBmpSubTask;
import xdoclet.ejb.tags.EjbTagsHandler;
import xdoclet.ejb.tags.EntityTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.TypeConversionUtil;

public class BmpTagsHandler
extends EntityTagsHandler {
    public static String getEntityBmpClassFor(ClassDoc clazz) throws XDocletException {
        String fileName = clazz.containingPackage().name();
        String entity_name = MessageFormat.format(BmpTagsHandler.getEntityBmpClassPattern(), EjbTagsHandler.getShortEjbNameFor(clazz));
        if ((fileName = EjbTagsHandler.choosePackage(fileName, null, "entitybmp")).length() > 0) {
            fileName = fileName + ".";
        }
        fileName = fileName + entity_name;
        return fileName;
    }

    public static boolean isEntityBmp(ClassDoc clazz) throws XDocletException {
        if (!EntityTagsHandler.isEntity(clazz)) {
            return false;
        }
        String bean_str = DocletUtil.getText((Doc)clazz, "ejb:bean");
        if (bean_str == null) {
            return false;
        }
        String value = XDocletTagSupport.getParameterValue(clazz, bean_str, "type", -1);
        if (value == null) {
            return false;
        }
        return value.equals("BMP");
    }

    public static boolean useSoftLocking(ClassDoc clazz) throws XDocletException {
        String soft_locking_str = XDocletTagSupport.getParameterValue(clazz, DocletUtil.getText((Doc)clazz, "ejb:bean"), "use-soft-locking", -1);
        boolean soft_locking = TypeConversionUtil.stringToBoolean(soft_locking_str, false);
        return soft_locking;
    }

    protected static String getEntityBmpClassPattern() {
        EntityBmpSubTask entitybmp_subtask = (EntityBmpSubTask)DocletContext.getInstance().getSubTaskBy("entitybmp");
        if (entitybmp_subtask != null) {
            return entitybmp_subtask.getEntityBmpClassPattern();
        }
        return "{0}BMP";
    }

    public String entityBmpClass() throws XDocletException {
        return BmpTagsHandler.getEntityBmpClassFor(XDocletTagSupport.getCurrentClass());
    }

    public void ifEntityIsBmp(String template) throws XDocletException {
        if (BmpTagsHandler.isEntityBmp(XDocletTagSupport.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void forAllBmpEntityBeans(String template) throws XDocletException {
        ClassDoc[] classes = this.getContext().getRoot().classes();
        int i = 0;
        while (i < classes.length) {
            XDocletTagSupport.setCurrentClass(classes[i]);
            if (!DocletSupport.isDocletGenerated(XDocletTagSupport.getCurrentClass()) && BmpTagsHandler.isEntityBmp(XDocletTagSupport.getCurrentClass())) {
                this.generate(template);
            }
            ++i;
        }
    }

    public void ifUseSoftLocking(String template) throws XDocletException {
        if (BmpTagsHandler.useSoftLocking(XDocletTagSupport.getCurrentClass())) {
            this.generate(template);
        }
    }
}

