/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Zip
extends MatchingTask {
    private static long emptyCrc = new CRC32().getValue();
    private File zipFile;
    private File baseDir;
    private boolean doCompress = true;
    protected String archiveType = "zip";
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    private Hashtable addedDirs = new Hashtable();

    public void setZipfile(File zipFile) {
        this.zipFile = zipFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCompress(boolean c) {
        this.doCompress = c;
    }

    public void addFileset(PrefixedFileSet set) {
        this.filesets.addElement(set);
    }

    public void addPrefixedfileset(PrefixedFileSet set) {
        this.addFileset(set);
    }

    public void setWhenempty(String we) throws BuildException {
        if (!("fail".equals(we = we.toLowerCase()) || "skip".equals(we) || "create".equals(we))) {
            throw new BuildException("Unrecognized whenempty attribute: " + we);
        }
        this.emptyBehavior = we;
    }

    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset or prefixedfileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        Vector<DirectoryScanner> dss = new Vector<DirectoryScanner>();
        if (this.baseDir != null) {
            dss.addElement(this.getDirectoryScanner(this.baseDir));
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            dss.addElement(fs.getDirectoryScanner(this.project));
            ++i;
        }
        int dssSize = dss.size();
        Object[] scanners = new FileScanner[dssSize];
        dss.copyInto(scanners);
        if (this.isUpToDate((FileScanner[])scanners, this.zipFile)) {
            return;
        }
        this.log("Building " + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        try {
            try {
                boolean success = false;
                ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(this.zipFile));
                try {
                    if (this.doCompress) {
                        zOut.setMethod(8);
                    } else {
                        zOut.setMethod(0);
                    }
                    this.initZipOutputStream(zOut);
                    if (this.baseDir != null) {
                        this.addFiles(this.getDirectoryScanner(this.baseDir), zOut, "", "");
                    }
                    this.addFiles(this.filesets, zOut);
                    success = true;
                }
                finally {
                    block21: {
                        Object var9_8 = null;
                        try {
                            if (zOut != null) {
                                zOut.close();
                            }
                        }
                        catch (IOException ex) {
                            if (!success) break block21;
                            throw ex;
                        }
                    }
                }
                Object var5_13 = null;
                this.cleanUp();
            }
            catch (IOException ioe) {
                String msg = "Problem creating " + this.archiveType + ": " + ioe.getMessage();
                if (!this.zipFile.delete()) {
                    msg = msg + " (and the archive is probably corrupt but I could not delete it)";
                }
                throw new BuildException(msg, ioe, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    protected void addFiles(FileScanner scanner, ZipOutputStream zOut, String prefix, String fullpath) throws IOException {
        if (prefix.length() > 0 && fullpath.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes may not be set on the same fileset.");
        }
        File thisBaseDir = scanner.getBasedir();
        String[] dirs = scanner.getIncludedDirectories();
        if (dirs.length > 0 && fullpath.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int i = 0;
        while (i < dirs.length) {
            String name = dirs[i].replace(File.separatorChar, '/');
            if (!name.endsWith("/")) {
                name = name + "/";
            }
            this.addParentDirs(thisBaseDir, name, zOut, prefix);
            ++i;
        }
        String[] files = scanner.getIncludedFiles();
        if (files.length > 1 && fullpath.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int i2 = 0;
        while (i2 < files.length) {
            File f = new File(thisBaseDir, files[i2]);
            if (fullpath.length() > 0) {
                this.addParentDirs(null, fullpath, zOut, "");
                this.zipFile(f, zOut, fullpath);
            } else {
                String name = files[i2].replace(File.separatorChar, '/');
                this.addParentDirs(thisBaseDir, name, zOut, prefix);
                this.zipFile(f, zOut, prefix + name);
            }
            ++i2;
        }
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected boolean isUpToDate(FileScanner[] scanners, File zipFile) throws BuildException {
        String[][] fileNames = Zip.grabFileNames(scanners);
        File[] files = Zip.grabFiles(scanners, fileNames);
        if (files.length == 0) {
            if (this.emptyBehavior.equals("skip")) {
                this.log("Warning: skipping " + this.archiveType + " archive " + zipFile + " because no files were included.", 1);
                return true;
            }
            if (this.emptyBehavior.equals("fail")) {
                throw new BuildException("Cannot create " + this.archiveType + " archive " + zipFile + ": no files were included.", this.location);
            }
            if (zipFile.exists()) {
                return true;
            }
            this.log("Note: creating empty " + this.archiveType + " archive " + zipFile, 2);
            try {
                FileOutputStream os = new FileOutputStream(zipFile);
                try {
                    byte[] empty = new byte[22];
                    empty[0] = 80;
                    empty[1] = 75;
                    empty[2] = 5;
                    empty[3] = 6;
                    ((OutputStream)os).write(empty);
                }
                finally {
                    Object var7_9 = null;
                    ((OutputStream)os).close();
                }
            }
            catch (IOException ioe) {
                throw new BuildException("Could not create empty ZIP archive", ioe, this.location);
            }
            return true;
        }
        if (!zipFile.exists()) {
            return false;
        }
        SourceFileScanner sfs = new SourceFileScanner(this);
        MergingMapper mm = new MergingMapper();
        mm.setTo(zipFile.getAbsolutePath());
        int i = 0;
        while (i < scanners.length) {
            if (sfs.restrict(fileNames[i], scanners[i].getBasedir(), null, mm).length > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static File[] grabFiles(FileScanner[] scanners) {
        return Zip.grabFiles(scanners, Zip.grabFileNames(scanners));
    }

    protected static File[] grabFiles(FileScanner[] scanners, String[][] fileNames) {
        Vector<File> files = new Vector<File>();
        int i = 0;
        while (i < fileNames.length) {
            File thisBaseDir = scanners[i].getBasedir();
            int j = 0;
            while (j < fileNames[i].length) {
                files.addElement(new File(thisBaseDir, fileNames[i][j]));
                ++j;
            }
            ++i;
        }
        Object[] toret = new File[files.size()];
        files.copyInto(toret);
        return toret;
    }

    protected static String[][] grabFileNames(FileScanner[] scanners) {
        String[][] result = new String[scanners.length][];
        int i = 0;
        while (i < scanners.length) {
            String[] files = scanners[i].getIncludedFiles();
            String[] dirs = scanners[i].getIncludedDirectories();
            result[i] = new String[files.length + dirs.length];
            System.arraycopy(files, 0, result[i], 0, files.length);
            System.arraycopy(dirs, 0, result[i], files.length, dirs.length);
            ++i;
        }
        return result;
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath) throws IOException {
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.addedDirs.put(vPath, vPath);
        ZipEntry ze = new ZipEntry(vPath);
        if (dir != null) {
            ze.setTime(dir.lastModified());
        }
        ze.setSize(0L);
        ze.setMethod(0);
        ze.setCrc(emptyCrc);
        zOut.putNextEntry(ze);
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified) throws IOException {
        ZipEntry ze = new ZipEntry(vPath);
        ze.setTime(lastModified);
        if (!this.doCompress) {
            long size = 0L;
            CRC32 cal = new CRC32();
            if (!in.markSupported()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                    bos.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in = new ByteArrayInputStream(bos.toByteArray());
            } else {
                in.mark(Integer.MAX_VALUE);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in.reset();
            }
            ze.setSize(size);
            ze.setCrc(cal.getValue());
        }
        zOut.putNextEntry(ze);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut, vPath, file.lastModified());
        }
        finally {
            Object var6_5 = null;
            fIn.close();
        }
    }

    protected void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix) throws IOException {
        String dir;
        Stack<String> directories = new Stack<String>();
        int slashPos = entry.length();
        while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
            dir = entry.substring(0, slashPos + 1);
            if (this.addedDirs.get(prefix + dir) != null) break;
            directories.push(dir);
        }
        while (!directories.isEmpty()) {
            dir = (String)directories.pop();
            File f = null;
            f = baseDir != null ? new File(baseDir, dir) : new File(dir);
            this.zipDir(f, zOut, prefix + dir);
        }
    }

    protected void addFiles(Vector filesets, ZipOutputStream zOut) throws IOException {
        int i = 0;
        while (i < filesets.size()) {
            PrefixedFileSet fs = (PrefixedFileSet)filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String prefix = fs.getPrefix();
            if (prefix.length() > 0 && !prefix.endsWith("/") && !prefix.endsWith("\\")) {
                prefix = prefix + "/";
            }
            String fullpath = fs.getFullpath();
            if (prefix.length() > 0) {
                this.addParentDirs(null, prefix, zOut, "");
                this.zipDir(null, zOut, prefix);
            } else if (fullpath.length() > 0) {
                this.addParentDirs(null, fullpath, zOut, "");
            }
            this.addFiles(ds, zOut, prefix, fullpath);
            ++i;
        }
    }

    protected void cleanUp() {
    }

    public static class PrefixedFileSet
    extends FileSet {
        private String prefix = "";
        private String fullpath = "";

        public void setPrefix(String loc) {
            this.prefix = loc;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setFullpath(String loc) {
            this.fullpath = loc;
        }

        public String getFullpath() {
            return this.fullpath;
        }
    }
}

